/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.positionmanager;

import at.ssw.positionmanager.Cluster;
import at.ssw.positionmanager.Link;
import at.ssw.positionmanager.Port;
import at.ssw.positionmanager.Vertex;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class LayoutGraph {
    private Set<? extends Link> links;
    private SortedSet<Vertex> vertices;
    private Hashtable<Vertex, Set<Port>> inputPorts;
    private Hashtable<Vertex, Set<Port>> outputPorts;
    private Hashtable<Port, Set<Link>> portLinks;

    public LayoutGraph(Set<? extends Link> links) {
        this(links, new HashSet());
    }

    public LayoutGraph(Set<? extends Link> links, Set<? extends Vertex> additionalVertices) {
        this.links = links;
        assert (this.verify());
        this.vertices = new TreeSet<Vertex>();
        this.portLinks = new Hashtable();
        this.inputPorts = new Hashtable();
        this.outputPorts = new Hashtable();
        for (Link link : links) {
            Port p = link.getFrom();
            Port p2 = link.getTo();
            Vertex v1 = p.getVertex();
            Vertex v2 = p2.getVertex();
            if (!this.vertices.contains(v1)) {
                this.outputPorts.put(v1, new HashSet());
                this.inputPorts.put(v1, new HashSet());
                this.vertices.add(v1);
            }
            if (!this.vertices.contains(v2)) {
                this.vertices.add(v2);
                this.outputPorts.put(v2, new HashSet());
                this.inputPorts.put(v2, new HashSet());
            }
            if (!this.portLinks.containsKey(p)) {
                HashSet hashSet = new HashSet();
                this.portLinks.put(p, hashSet);
            }
            if (!this.portLinks.containsKey(p2)) {
                this.portLinks.put(p2, new HashSet());
            }
            this.outputPorts.get(v1).add(p);
            this.inputPorts.get(v2).add(p2);
            this.portLinks.get(p).add(link);
            this.portLinks.get(p2).add(link);
        }
        for (Vertex vertex : additionalVertices) {
            if (this.vertices.contains(vertex)) continue;
            this.outputPorts.put(vertex, new HashSet());
            this.inputPorts.put(vertex, new HashSet());
            this.vertices.add(vertex);
        }
    }

    public Set<Port> getInputPorts(Vertex v) {
        return this.inputPorts.get(v);
    }

    public Set<Port> getOutputPorts(Vertex v) {
        return this.outputPorts.get(v);
    }

    public Set<Link> getPortLinks(Port p) {
        return this.portLinks.get(p);
    }

    public Set<? extends Link> getLinks() {
        return this.links;
    }

    public boolean verify() {
        return true;
    }

    public SortedSet<Vertex> getVertices() {
        return this.vertices;
    }

    private void markNotRoot(Set<Vertex> notRootSet, Set<Vertex> visited, Vertex v, Vertex startingVertex) {
        if (visited.contains(v)) {
            return;
        }
        if (v != startingVertex) {
            notRootSet.add(v);
        }
        visited.add(v);
        Set<Port> outPorts = this.getOutputPorts(v);
        for (Port p : outPorts) {
            Set<Link> links = this.getPortLinks(p);
            for (Link l : links) {
                Port other = l.getTo();
                Vertex otherVertex = other.getVertex();
                this.markNotRoot(notRootSet, visited, otherVertex, startingVertex);
            }
        }
    }

    public Set<Vertex> findRootVertices(Set<Vertex> startingRoots) {
        HashSet<Vertex> notRootSet = new HashSet<Vertex>();
        for (Vertex vertex : startingRoots) {
            if (notRootSet.contains(vertex)) continue;
            HashSet<Vertex> visited = new HashSet<Vertex>();
            this.markNotRoot(notRootSet, visited, vertex, vertex);
        }
        SortedSet<Vertex> vertices = this.getVertices();
        for (Vertex v : vertices) {
            if (notRootSet.contains(v)) continue;
            HashSet<Vertex> visited = new HashSet<Vertex>();
            this.markNotRoot(notRootSet, visited, v, v);
        }
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        for (Vertex v : vertices) {
            if (notRootSet.contains(v)) continue;
            hashSet.add(v);
        }
        return hashSet;
    }

    public Set<Vertex> findRootVertices() {
        return this.findRootVertices(new HashSet<Vertex>());
    }

    public Set<Cluster> getClusters() {
        HashSet<Cluster> clusters = new HashSet<Cluster>();
        for (Vertex v : this.getVertices()) {
            if (v.getCluster() == null) continue;
            clusters.add(v.getCluster());
        }
        return clusters;
    }
}

