/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.block.view;

import at.ssw.visualizer.block.view.BlockTableModel;
import at.ssw.visualizer.core.selection.Selection;
import at.ssw.visualizer.core.selection.SelectionManager;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class BlockViewTopComponent
extends TopComponent {
    private ControlFlowGraph curCFG;
    private BasicBlock[] curBlocks;
    private JTable blockTable;
    private BlockTableModel tableModel;
    private boolean selectionUpdating;
    private ChangeListener selectionChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            BlockViewTopComponent.this.updateContent();
        }
    };
    private ListSelectionListener listSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent event) {
            BlockViewTopComponent.this.updateSelection();
        }
    };
    private static final String PREFERRED_ID = "BlockViewTopComponent";
    private static BlockViewTopComponent instance;

    private BlockViewTopComponent() {
        this.setName("Blocks");
        this.setToolTipText("List of Blocks");
        this.tableModel = new BlockTableModel();
        this.blockTable = new JTable(this.tableModel);
        this.blockTable.setSelectionMode(2);
        this.blockTable.setRowMargin(0);
        this.blockTable.getColumnModel().setColumnMargin(0);
        this.blockTable.setShowGrid(false);
        this.blockTable.setAutoResizeMode(0);
        for (int i = 0; i < BlockTableModel.COLUMN_WIDTHS.length; ++i) {
            this.blockTable.getColumnModel().getColumn(i).setPreferredWidth(BlockTableModel.COLUMN_WIDTHS[i]);
        }
        this.blockTable.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.blockTable.getModel());
        sorter.setComparator(0, new Comparator<String>(){

            @Override
            public int compare(String block1, String block2) {
                if (block1.charAt(0) == 'B' && block2.charAt(0) == 'B') {
                    try {
                        return Integer.parseUnsignedInt(block1.substring(1)) - Integer.parseUnsignedInt(block2.substring(1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return block1.compareTo(block2);
            }
        });
        this.blockTable.setRowSorter(sorter);
        JScrollPane scrollPane = new JScrollPane(this.blockTable);
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.add(scrollPane);
    }

    protected void componentShowing() {
        super.componentShowing();
        SelectionManager.getDefault().addChangeListener(this.selectionChangeListener);
        this.updateContent();
    }

    protected void componentHidden() {
        super.componentHidden();
        SelectionManager.getDefault().removeChangeListener(this.selectionChangeListener);
        this.selectionUpdating = true;
        this.curCFG = null;
        this.curBlocks = null;
        this.tableModel.setControlFlowGraph(null);
        this.selectionUpdating = false;
    }

    protected void updateContent() {
        if (this.selectionUpdating) {
            return;
        }
        this.selectionUpdating = true;
        Selection selection = SelectionManager.getDefault().getCurSelection();
        ControlFlowGraph newCFG = (ControlFlowGraph)selection.get(ControlFlowGraph.class);
        Object[] newBlocks = (BasicBlock[])selection.get(BasicBlock[].class);
        if (this.curCFG != newCFG) {
            this.tableModel.setControlFlowGraph(newCFG);
            this.curBlocks = null;
        }
        if (newBlocks != null) {
            if (newBlocks.length == 0) {
                this.blockTable.clearSelection();
            } else if (!Arrays.equals(this.curBlocks, newBlocks)) {
                HashMap<String, Object> blockNames = new HashMap<String, Object>();
                for (Object block : newBlocks) {
                    blockNames.put(block.getName(), block);
                }
                this.blockTable.clearSelection();
                for (int i = this.blockTable.getModel().getRowCount() - 1; i >= 0; --i) {
                    BasicBlock block = (BasicBlock)blockNames.get(this.blockTable.getValueAt(i, 0));
                    if (block == null) continue;
                    this.blockTable.addRowSelectionInterval(i, i);
                    this.blockTable.scrollRectToVisible(this.blockTable.getCellRect(i, 0, true));
                }
            }
        }
        this.curCFG = newCFG;
        this.curBlocks = newBlocks;
        this.selectionUpdating = false;
    }

    private void updateSelection() {
        if (this.selectionUpdating) {
            return;
        }
        this.selectionUpdating = true;
        ArrayList<BasicBlock> blocks = new ArrayList<BasicBlock>();
        for (int i = 0; i < this.blockTable.getModel().getRowCount(); ++i) {
            if (!this.blockTable.getSelectionModel().isSelectedIndex(i)) continue;
            blocks.add(this.curCFG.getBasicBlockByName((String)this.blockTable.getValueAt(i, 0)));
        }
        this.curBlocks = blocks.toArray(new BasicBlock[blocks.size()]);
        Selection selection = SelectionManager.getDefault().getCurSelection();
        selection.put((Object)this.curBlocks);
        this.selectionUpdating = false;
    }

    public static synchronized BlockViewTopComponent getDefault() {
        if (instance == null) {
            instance = new BlockViewTopComponent();
        }
        return instance;
    }

    public static synchronized BlockViewTopComponent findInstance() {
        return (BlockViewTopComponent)WindowManager.getDefault().findTopComponent(PREFERRED_ID);
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return BlockViewTopComponent.getDefault();
        }
    }
}

