/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.dataflow.graph;

import at.ssw.visualizer.dataflow.graph.InstructionNodeWidget;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ClusterWidget
extends Widget {
    private Collection<Widget> widgets;
    private String id;
    private Border VISIBLEBORDER;
    private static Border INVISIBLEBORDER = BorderFactory.createEmptyBorder();
    private static final int DASHSIZE = 10;
    private static final int PADDING = 10;
    private static final int CORRECT = 5;
    private boolean visible = true;
    private LabelWidget label;

    public ClusterWidget(String id, Collection<Widget> widgets, Scene scene, Color col) {
        super(scene);
        this.widgets = widgets;
        this.id = id;
        this.VISIBLEBORDER = BorderFactory.createDashedBorder((Color)col, (int)10, (int)5, (boolean)true);
        this.label = new LabelWidget(scene, id);
        this.label.setForeground(col);
        this.addChild((Widget)this.label);
        if (scene instanceof EditProvider) {
            WidgetAction.Chain actions = this.getActions();
            actions.addAction(ActionFactory.createEditAction((EditProvider)((EditProvider)scene)));
        }
    }

    public String getId() {
        return this.id;
    }

    public Collection<Widget> getWidgets() {
        return this.widgets;
    }

    private void setWidgetVisible(boolean v) {
        this.removeChildren();
        if (v) {
            this.setBorder(this.VISIBLEBORDER);
            this.addChild((Widget)this.label);
        } else {
            this.setBorder(INVISIBLEBORDER);
        }
    }

    public void setVisibility(boolean b) {
        this.visible = b;
    }

    public void refresh() {
        if (this.widgets != null) {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            boolean changed = false;
            for (Widget w : this.widgets) {
                if (w instanceof InstructionNodeWidget && !((InstructionNodeWidget)w).isWidgetVisible()) continue;
                Point p = w.getPreferredLocation();
                Rectangle r = w.getBounds();
                if (w == null || r == null) continue;
                if (minX > p.x) {
                    minX = p.x;
                }
                if (minY > p.y) {
                    minY = p.y;
                }
                if (maxX < p.x + r.width) {
                    maxX = p.x + r.width;
                }
                if (maxY < p.y + r.height) {
                    maxY = p.y + r.height;
                }
                changed = true;
            }
            if (changed && this.visible) {
                this.setPreferredBounds(new Rectangle(maxX - minX + 20, maxY - minY + 20));
                this.setPreferredLocation(new Point(minX - 10 - 5, minY - 10 - 5));
                this.setWidgetVisible(true);
                this.revalidate();
            } else {
                this.setWidgetVisible(false);
            }
        }
    }
}

