/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.dataflow.graph;

import at.ssw.dataflow.layout.ExternalGraphLayouter;
import at.ssw.positionmanager.Cluster;
import at.ssw.positionmanager.LayoutGraph;
import at.ssw.positionmanager.Link;
import at.ssw.positionmanager.Vertex;
import at.ssw.positionmanager.export.GMLFileExport;
import at.ssw.positionmanager.impl.GraphCluster;
import at.ssw.positionmanager.impl.GraphLink;
import at.ssw.positionmanager.impl.GraphPort;
import at.ssw.positionmanager.impl.GraphVertex;
import at.ssw.visualizer.dataflow.attributes.ExpandNodeSwitchAttribute;
import at.ssw.visualizer.dataflow.attributes.ExpandStructureAttribute;
import at.ssw.visualizer.dataflow.attributes.ISwitchAttribute;
import at.ssw.visualizer.dataflow.attributes.InvisibleAttribute;
import at.ssw.visualizer.dataflow.attributes.SelfSwitchingExpandAttribute;
import at.ssw.visualizer.dataflow.graph.ClusterWidget;
import at.ssw.visualizer.dataflow.graph.DirectLineRouter;
import at.ssw.visualizer.dataflow.graph.InstructionConnectionWidget;
import at.ssw.visualizer.dataflow.graph.InstructionNodeWidget;
import at.ssw.visualizer.dataflow.graph.InstructionSceneListener;
import at.ssw.visualizer.dataflow.graph.SetLocationAnimator;
import at.ssw.visualizer.dataflow.instructions.Instruction;
import at.ssw.visualizer.graphhelper.DiGraph;
import at.ssw.visualizer.graphhelper.Edge;
import at.ssw.visualizer.graphhelper.Node;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JViewport;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class InstructionNodeGraphScene
extends GraphScene<Instruction, String>
implements RectangularSelectDecorator,
RectangularSelectProvider,
MoveStrategy,
EditProvider,
SelectProvider {
    private Widget mainLayer;
    private Widget connectionLayer;
    private Widget selectLayer;
    private Widget clusterLayer;
    private Collection<ClusterWidget> clusters = null;
    private Hashtable<String, InstructionNodeWidget> nodewidgets;
    private String RELEASEINFTREE = "Collapse Influence Tree";
    private String RELEASEPARENTINF = "Collapse Parent Influence";
    private String RELEASECYCLES = "Collapse Cycles";
    private String RELEASESINGLECYCLE = "Collapse Single Cycle";
    private String RELEASENODE = "Collapse Node";
    private WidgetAction moveAction = ActionFactory.createMoveAction((MoveStrategy)this, (MoveProvider)new MultiWidgetMovementProvider());
    private WidgetAction selectAction = ActionFactory.createSelectAction((SelectProvider)this);
    private ExternalGraphLayouter layouter = null;
    private LinkedList<InstructionSceneListener> listeners;
    private boolean interCluserLinkGray = true;
    private DiGraph calculationModel;
    private boolean autoLayout = true;
    private boolean layoutInvisibleNodes = false;
    private boolean highlightClustering = false;
    private boolean clusterBordersVisible = true;
    private boolean locationAnimation = true;
    private static final String HIGHLIGHTBLOCK = "HIGHLIGHT";
    private static final String DEFAULTBLOCK = "NULL";
    private boolean USECURRENTNODEPOSITIONS = false;
    private Router linkRouter = new DirectLineRouter(this);
    private LayoutGraph layoutGraph = null;
    private Hashtable<Vertex, InstructionNodeWidget> VertexToWidget = null;
    private Hashtable<Widget, Vertex> WidgetToVertex = null;
    private Hashtable<Cluster, String> clusterToId = null;

    public InstructionNodeGraphScene() {
        this.clusterLayer = new LayerWidget((Scene)this);
        this.addChild(this.clusterLayer);
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild(this.mainLayer);
        this.connectionLayer = new Widget((Scene)this);
        this.addChild(this.connectionLayer);
        this.selectLayer = new LayerWidget((Scene)this);
        this.addChild(this.selectLayer);
        this.getInputBindings().setZoomActionModifiers(0);
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.2));
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((RectangularSelectDecorator)this, (LayerWidget)((LayerWidget)this.selectLayer), (RectangularSelectProvider)this));
        this.nodewidgets = new Hashtable();
        this.listeners = new LinkedList();
    }

    public void addInstructions(Instruction[] instructions) {
        this.calculationModel = new DiGraph();
        for (Instruction instruction : instructions) {
            this.addNode(instruction);
            this.calculationModel.addNode(new Node(instruction.getID()));
        }
        for (Instruction instruction : instructions) {
            for (Instruction x : instruction.getSuccessors()) {
                if (this.getEdges().contains(instruction.getID() + x.getID())) continue;
                this.addEdge(instruction.getID() + x.getID());
                this.setEdgeSource(instruction.getID() + x.getID(), instruction);
                this.setEdgeTarget(instruction.getID() + x.getID(), x);
                this.calculationModel.addEdge(new Edge(this.calculationModel.getNode(instruction.getID()), this.calculationModel.getNode(x.getID())));
            }
        }
        for (InstructionNodeWidget instructionNodeWidget : this.getNodeWidgets()) {
            Node n = this.calculationModel.getNode(instructionNodeWidget.getID());
            if (n == null) continue;
            Collection cycles = this.calculationModel.getCircularDependency(n);
            LinkedList<InstructionNodeWidget[]> intc = new LinkedList<InstructionNodeWidget[]>();
            for (Node[] nl : cycles) {
                InstructionNodeWidget[] wid = new InstructionNodeWidget[nl.length];
                for (int i = 0; i < nl.length; ++i) {
                    wid[i] = this.getNodeWidget(nl[i].ID);
                }
                intc.add(wid);
            }
            instructionNodeWidget.setCycles(intc);
        }
    }

    public void refreshAll() {
        Enumeration<InstructionNodeWidget> enu = this.nodewidgets.elements();
        while (enu.hasMoreElements()) {
            InstructionNodeWidget w = enu.nextElement();
            w.refresh();
        }
        for (Widget w : this.connectionLayer.getChildren()) {
            w.revalidate(true);
        }
        this.refreshClusterWidgets();
        this.refreshLayoutVertex();
    }

    protected void refreshLayoutVertex() {
        if (this.VertexToWidget != null) {
            for (Map.Entry<Vertex, InstructionNodeWidget> e : this.VertexToWidget.entrySet()) {
                if (!(e.getKey() instanceof GraphVertex)) continue;
                GraphVertex v = (GraphVertex)e.getKey();
                v.setDirty(true);
            }
        }
    }

    protected void refreshClusterWidgets() {
        if (this.clusters != null) {
            for (ClusterWidget c : this.clusters) {
                c.refresh();
            }
        }
    }

    public void centerOn(Point p) {
        Container o = this.getView().getParent();
        if (o instanceof JViewport) {
            JViewport v = (JViewport)o;
            Point upperLeft = this.convertViewToScene(v.getViewPosition());
            Point lowerRight = v.getViewPosition();
            lowerRight.translate(v.getExtentSize().width, v.getExtentSize().height);
            lowerRight = this.convertViewToScene(lowerRight);
            int x = p.x - (lowerRight.x - upperLeft.x) / 2;
            int y = p.y - (lowerRight.y - upperLeft.y) / 2;
            Point n = this.convertSceneToView(new Point(x, y));
            int maxX = v.getViewSize().width - v.getExtentSize().width;
            int maxY = v.getViewSize().height - v.getExtentSize().height;
            if (n.x < 0) {
                n.x = 0;
            }
            if (n.x > maxX) {
                n.x = maxX;
            }
            if (n.y < 0) {
                n.y = 0;
            }
            if (n.y > maxY) {
                n.y = maxY;
            }
            v.setViewPosition(n);
        }
    }

    public void edit(Widget widget) {
        if (widget instanceof InstructionNodeWidget) {
            this.fireDoubleClicked((InstructionNodeWidget)widget);
        }
        if (widget instanceof ClusterWidget) {
            try {
                int x = widget.getPreferredLocation().x + widget.getPreferredBounds().width / 2;
                int y = widget.getPreferredLocation().y + widget.getPreferredBounds().height / 2;
                this.centerOn(new Point(x, y));
                HashSet<Instruction> set = new HashSet<Instruction>();
                for (Widget w : ((ClusterWidget)widget).getWidgets()) {
                    if (!(w instanceof InstructionNodeWidget)) continue;
                    set.add(((InstructionNodeWidget)w).getInstruction());
                }
                this.setSelectedObjects(set);
                this.fireSelectionChanged();
                this.refreshAll();
                this.validate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean exportToGMLFile(File f) {
        Hashtable<Vertex, String> names = new Hashtable<Vertex, String>();
        Hashtable<Vertex, Color> colors = new Hashtable<Vertex, Color>();
        for (Vertex v : this.layoutGraph.getVertices()) {
            InstructionNodeWidget w = this.VertexToWidget.get(v);
            if (w == null) continue;
            names.put(v, this.VertexToWidget.get(v).getID());
            colors.put(v, InstructionNodeWidget.getColorByType(w.getInstruction().getInstructionType(), false));
        }
        GMLFileExport exp = new GMLFileExport(f, names, colors);
        return exp.export(this.layoutGraph);
    }

    protected void handleExpandInfluenceTree(Instruction i, boolean forward) {
        String desc = "(" + i.getID() + ")";
        desc = forward ? this.RELEASEINFTREE + desc : this.RELEASEPARENTINF + desc;
        ExpandNodeSwitchAttribute en = new ExpandNodeSwitchAttribute(true, desc, true, this);
        LinkedList<Instruction> list = new LinkedList<Instruction>();
        this.getNodeWidget(i.getID()).addNodeAttribute(en);
        list.add(i);
        if (forward) {
            for (Instruction inst : i.getSuccessors()) {
                this.rek_ExpandInfluenceTree(inst, en, list, forward);
            }
        } else {
            for (Instruction inst : i.getPredecessors()) {
                this.rek_ExpandInfluenceTree(inst, en, list, forward);
            }
        }
        this.refreshAll();
        this.validate();
        this.autoLayout();
    }

    private void rek_ExpandInfluenceTree(Instruction i, ISwitchAttribute a, LinkedList<Instruction> list, boolean forward) {
        if (list.contains(i)) {
            return;
        }
        list.add(i);
        ExpandStructureAttribute es = new ExpandStructureAttribute(a, this);
        this.getNodeWidget(i.getID()).addNodeAttribute(es);
        if (forward) {
            for (Instruction inst : i.getSuccessors()) {
                this.rek_ExpandInfluenceTree(inst, a, list, forward);
            }
        } else {
            for (Instruction inst : i.getPredecessors()) {
                this.rek_ExpandInfluenceTree(inst, a, list, forward);
            }
        }
    }

    protected void handleExpandNode(Instruction instruction) {
        HashSet<Instruction> selected = this.getSelectedObjects();
        if (selected == null || selected.size() == 0 || !selected.contains(instruction)) {
            selected = new HashSet<Instruction>();
            selected.add(instruction);
        }
        for (Instruction i : selected) {
            InstructionNodeWidget n = this.getNodeWidget(i.getID());
            SelfSwitchingExpandAttribute en = new SelfSwitchingExpandAttribute(this.RELEASENODE + "(" + i.getID() + ")", this);
            n.addNodeAttribute(en);
        }
        this.refreshAll();
        this.validate();
        this.autoLayout();
    }

    void handleExpandCycles(String id) {
        InstructionNodeWidget nw = this.nodewidgets.get(id);
        if (nw != null) {
            String desc = this.RELEASECYCLES + " (" + id + ")";
            ExpandNodeSwitchAttribute en = new ExpandNodeSwitchAttribute(true, desc, true, this);
            nw.addNodeAttribute(en);
            Collection<InstructionNodeWidget[]> c = nw.getCycleWidgets();
            LinkedList<InstructionNodeWidget> handled = new LinkedList<InstructionNodeWidget>();
            handled.add(nw);
            for (InstructionNodeWidget[] a : c) {
                for (InstructionNodeWidget w : a) {
                    if (handled.contains((Object)w)) continue;
                    handled.add(w);
                    ExpandStructureAttribute es = new ExpandStructureAttribute(en, this);
                    w.addNodeAttribute(es);
                }
            }
        }
        this.refreshAll();
        this.validate();
        this.autoLayout();
    }

    public void handleExpandCycle(String node, int cycleIndex) {
        InstructionNodeWidget nw = this.nodewidgets.get(node);
        if (nw != null) {
            String desc = this.RELEASESINGLECYCLE + " (" + node + "/" + cycleIndex + ")";
            ExpandNodeSwitchAttribute en = new ExpandNodeSwitchAttribute(true, desc, true, this);
            nw.addNodeAttribute(en);
            LinkedList<InstructionNodeWidget> handled = new LinkedList<InstructionNodeWidget>();
            handled.add(nw);
            int i = 0;
            for (InstructionNodeWidget[] a : nw.getCycleWidgets()) {
                if (i == cycleIndex) {
                    for (InstructionNodeWidget w : a) {
                        if (handled.contains((Object)w)) continue;
                        handled.add(w);
                        ExpandStructureAttribute es = new ExpandStructureAttribute(en, this);
                        w.addNodeAttribute(es);
                    }
                    break;
                }
                ++i;
            }
        }
        this.refreshAll();
        this.validate();
        this.autoLayout();
    }

    public void handleHideAllBut(Instruction instruction) {
        HashSet<Instruction> selected = this.getSelectedObjects();
        boolean deselect = false;
        if (selected.size() == 0) {
            selected = new HashSet<Instruction>();
            selected.add(instruction);
        } else if (!selected.contains(instruction)) {
            selected = new HashSet();
            selected.add(instruction);
        } else {
            deselect = true;
        }
        for (InstructionNodeWidget w : this.getNodeWidgets()) {
            if (selected != null && selected.contains(w.getInstruction()) || !w.isWidgetVisible()) continue;
            w.addNodeAttribute(new InvisibleAttribute());
        }
        if (deselect) {
            this.setSelectedObjects(new HashSet());
            this.fireSelectionChanged();
        }
        this.refreshAll();
        this.validate();
        this.autoLayout();
    }

    public void handleToggleVisibility(Instruction inst, boolean includeSelection) {
        HashSet<Instruction> selected = null;
        if (includeSelection) {
            selected = this.getSelectedObjects();
            if (selected.size() == 0) {
                selected = new HashSet();
                selected.add(inst);
            } else if (!selected.contains(inst)) {
                selected = new HashSet();
                selected.add(inst);
            }
        } else {
            selected = new HashSet<Instruction>();
            selected.add(inst);
        }
        boolean unselect = false;
        for (Instruction i : selected) {
            InstructionNodeWidget nw = this.getNodeWidget(i.getID());
            if (nw.isWidgetVisible()) {
                nw.addNodeAttribute(new InvisibleAttribute());
                unselect = true;
                continue;
            }
            nw.makeVisible();
            this.createCurrentLayoutGraph();
        }
        if (unselect) {
            selected = new HashSet();
            this.setSelectedObjects(selected);
            this.fireSelectionChanged();
        }
        this.refreshAll();
        this.validate();
        this.autoLayout();
    }

    public void handleMakeTreeVisible(Instruction inst, boolean forward) {
        HashSet<Instruction> selected = this.getSelectedObjects();
        LinkedList<Instruction> handled = new LinkedList<Instruction>();
        if (selected.size() == 0) {
            selected = new HashSet<Instruction>();
            selected.add(inst);
        } else if (!selected.contains(inst)) {
            selected = new HashSet();
            selected.add(inst);
        }
        for (Instruction i : selected) {
            InstructionNodeWidget nw = this.getNodeWidget(i.getID());
            nw.makeVisible();
            handled.add(i);
            if (forward) {
                for (Instruction x : i.getSuccessors()) {
                    this.recHandleMakeTreeVisible(x, forward, handled);
                }
                continue;
            }
            for (Instruction x : i.getPredecessors()) {
                this.recHandleMakeTreeVisible(x, forward, handled);
            }
        }
        this.createCurrentLayoutGraph();
        this.refreshAll();
        this.validate();
        this.autoLayout();
    }

    private void recHandleMakeTreeVisible(Instruction inst, boolean forward, LinkedList<Instruction> handled) {
        Vertex v;
        if (handled.contains(inst)) {
            return;
        }
        handled.add(inst);
        InstructionNodeWidget nw = this.getNodeWidget(inst.getID());
        nw.makeVisible();
        if (this.WidgetToVertex != null && (v = this.WidgetToVertex.get((Object)nw)) != null && v instanceof GraphVertex) {
            ((GraphVertex)v).setDirty(true);
        }
        if (forward) {
            for (Instruction x : inst.getSuccessors()) {
                this.recHandleMakeTreeVisible(x, forward, handled);
            }
        } else {
            for (Instruction x : inst.getPredecessors()) {
                this.recHandleMakeTreeVisible(x, forward, handled);
            }
        }
    }

    public void handleMakeCycleVisible(String node, int cycleIndex) {
        InstructionNodeWidget nw = this.nodewidgets.get(node);
        if (nw != null) {
            nw.makeVisible();
            int i = 0;
            for (InstructionNodeWidget[] a : nw.getCycleWidgets()) {
                if (i == cycleIndex || cycleIndex == -1) {
                    for (InstructionNodeWidget w : a) {
                        w.makeVisible();
                    }
                }
                ++i;
            }
        }
        this.createCurrentLayoutGraph();
        this.refreshAll();
        this.validate();
        this.autoLayout();
    }

    public void handleSetVisibilityNodeType(boolean visible, Instruction.InstructionType type) {
        for (InstructionNodeWidget w : this.nodewidgets.values()) {
            if (type != null && w.getInstruction().getInstructionType() != type) continue;
            if (visible) {
                w.makeVisible();
                continue;
            }
            if (!w.isWidgetVisible()) continue;
            w.addNodeAttribute(new InvisibleAttribute());
        }
        this.createCurrentLayoutGraph();
        this.fireUpdateNodeData();
    }

    void handleShowNodes(Instruction[] instruction) {
        for (Instruction i : instruction) {
            InstructionNodeWidget w = this.getNodeWidget(i.getID());
            if (w == null) continue;
            w.makeVisible();
        }
        this.createCurrentLayoutGraph();
        this.refreshAll();
        this.validate();
        this.autoLayout();
    }

    public void autoLayout() {
        if (this.autoLayout) {
            this.layout();
        }
    }

    public LayoutGraph getLayoutGraph() {
        return this.layoutGraph;
    }

    public Hashtable<Widget, Vertex> getWidgetToVertex() {
        return this.WidgetToVertex;
    }

    private void createCurrentLayoutGraph() {
        Hashtable<String, Vertex> idToVertex = new Hashtable<String, Vertex>();
        TreeSet<GraphLink> links = new TreeSet<GraphLink>();
        TreeSet<GraphVertex> verticles = new TreeSet<GraphVertex>();
        this.clusterToId = new Hashtable();
        this.VertexToWidget = new Hashtable();
        this.WidgetToVertex = new Hashtable();
        DiGraph model = this.calculationModel.clone();
        if (!this.layoutInvisibleNodes) {
            for (InstructionNodeWidget nw : this.getNodeWidgets()) {
                if (nw.isWidgetVisible()) continue;
                model.removeNode(model.getNode(nw.getID()));
            }
        }
        int i = 0;
        int j = 0;
        int ci = 0;
        for (DiGraph dg : model.getConnectedComponents()) {
            Hashtable<String, Cluster> idToCluster = new Hashtable<String, Cluster>();
            for (Edge e : dg.getEdges()) {
                Vertex v2;
                Cluster c;
                String block;
                Vertex v1;
                String nID1 = e.source.ID;
                String nID2 = e.destination.ID;
                InstructionNodeWidget nw1 = this.getNodeWidget(nID1);
                InstructionNodeWidget nw2 = this.getNodeWidget(nID2);
                if (idToVertex.containsKey(nID1)) {
                    v1 = (Vertex)idToVertex.get(nID1);
                } else {
                    block = nw1.getInstruction().getSourceBlock();
                    if (block == null) {
                        block = DEFAULTBLOCK;
                    }
                    if (this.highlightClustering && nw1.isPathHighlighted()) {
                        block = HIGHLIGHTBLOCK;
                    }
                    if (idToCluster.containsKey(block)) {
                        c = (Cluster)idToCluster.get(block);
                    } else {
                        c = new GraphCluster(ci++, null, null);
                        idToCluster.put(block, c);
                        this.clusterToId.put(c, block);
                    }
                    v1 = new GraphVertex(i++, c, nw1.getLocation(), nw1);
                    idToVertex.put(nID1, v1);
                    this.VertexToWidget.put(v1, nw1);
                    this.WidgetToVertex.put(nw1, v1);
                }
                if (idToVertex.containsKey(nID2)) {
                    v2 = (Vertex)idToVertex.get(nID2);
                } else {
                    block = nw2.getInstruction().getSourceBlock();
                    if (block == null) {
                        block = DEFAULTBLOCK;
                    }
                    if (this.highlightClustering && nw2.isPathHighlighted()) {
                        block = HIGHLIGHTBLOCK;
                    }
                    if (idToCluster.containsKey(block)) {
                        c = (Cluster)idToCluster.get(block);
                    } else {
                        c = new GraphCluster(ci++, null, null);
                        idToCluster.put(block, c);
                        this.clusterToId.put(c, block);
                    }
                    v2 = new GraphVertex(i++, c, nw2.getLocation(), nw2);
                    idToVertex.put(nID2, v2);
                    this.VertexToWidget.put(v2, nw2);
                    this.WidgetToVertex.put(nw2, v2);
                }
                GraphPort p1 = new GraphPort(v1);
                GraphPort p2 = new GraphPort(v2);
                Cluster source = v1.getCluster();
                Cluster target = v2.getCluster();
                source.getSuccessors().add(target);
                target.getPredecessors().add(source);
                links.add(new GraphLink(j++, p1, p2));
            }
        }
        for (Node n : model.getNodes()) {
            if (n.edges.size() != 0) continue;
            InstructionNodeWidget nw = this.getNodeWidget(n.ID);
            GraphCluster c = new GraphCluster(ci++, null, null);
            GraphVertex v = new GraphVertex(i++, c, nw.getLocation(), nw);
            verticles.add(v);
            this.VertexToWidget.put(v, nw);
            this.WidgetToVertex.put(nw, v);
            idToVertex.put(n.ID, v);
            String block = nw.getInstruction().getSourceBlock();
            if (block == null) {
                block = DEFAULTBLOCK;
            }
            if (this.highlightClustering && nw.isPathHighlighted()) {
                block = HIGHLIGHTBLOCK;
            }
            this.clusterToId.put(c, block);
        }
        this.layoutGraph = new LayoutGraph(links, verticles);
        for (Link l : this.layoutGraph.getLinks()) {
            ((GraphPort)l.getFrom()).setLayoutGraph(this.layoutGraph);
            ((GraphPort)l.getTo()).setLayoutGraph(this.layoutGraph);
        }
    }

    public void layout() {
        this.createCurrentLayoutGraph();
        this.removeClusterWidgets();
        this.layouter.setUseCurrentNodePositions(this.USECURRENTNODEPOSITIONS);
        this.layouter.doLayout(this.layoutGraph);
        if (this.layouter.isClusteringSupported()) {
            Hashtable clusters = new Hashtable();
            for (Object v : this.layoutGraph.getVertices()) {
                if (!clusters.containsKey(v.getCluster())) {
                    clusters.put(v.getCluster(), new LinkedList());
                }
                ((LinkedList)clusters.get(v.getCluster())).add((Widget)this.VertexToWidget.get(v));
            }
            LinkedList<ClusterWidget> widgets = new LinkedList<ClusterWidget>();
            for (Cluster c : clusters.keySet()) {
                LinkedList l = (LinkedList)clusters.get(c);
                String id = this.clusterToId.get(c);
                Color col = null;
                col = HIGHLIGHTBLOCK.equals(id) ? Color.RED : Color.BLUE;
                widgets.add(new ClusterWidget(id, l, (Scene)this, col));
            }
            this.setClustersWidgets(widgets);
        }
        if (this.locationAnimation && this.layouter.isAnimationSupported()) {
            SetLocationAnimator animator = new SetLocationAnimator(this, this.VertexToWidget);
            animator.animate();
        } else {
            for (Vertex v : this.layoutGraph.getVertices()) {
                InstructionNodeWidget nw = this.VertexToWidget.get(v);
                Point pos = v.getPosition();
                pos.translate(5, 5);
                nw.setPreferredLocation(pos);
                if (!(v instanceof GraphVertex)) continue;
                ((GraphVertex)v).setDirty(true);
            }
            this.refreshClusterWidgets();
        }
        this.validate();
    }

    public void setClustersWidgets(Collection<ClusterWidget> clusters) {
        this.removeClusterWidgets();
        if (clusters != null) {
            this.clusters = clusters;
            for (ClusterWidget w : clusters) {
                this.clusterLayer.addChild((Widget)w);
                w.setVisibility(this.clusterBordersVisible);
                w.refresh();
                for (Widget iw : w.getWidgets()) {
                    if (!(iw instanceof InstructionNodeWidget)) continue;
                    ((InstructionNodeWidget)iw).setClusterWidget(w);
                }
            }
        }
        this.fireUpdateNodeData();
    }

    public void removeClusterWidgets() {
        if (this.clusters != null) {
            for (ClusterWidget clusterWidget : this.clusters) {
                this.clusterLayer.removeChild((Widget)clusterWidget);
            }
            for (InstructionNodeWidget instructionNodeWidget : this.nodewidgets.values()) {
                instructionNodeWidget.setClusterWidget(null);
            }
        }
        this.clusters = null;
        this.fireUpdateNodeData();
    }

    public InstructionNodeWidget getNodeWidget(String i) {
        return this.nodewidgets.get(i);
    }

    public InstructionNodeWidget[] getNodeWidgets() {
        return this.nodewidgets.values().toArray(new InstructionNodeWidget[this.nodewidgets.size()]);
    }

    public void setExternalLayouter(ExternalGraphLayouter l) {
        this.layouter = l;
    }

    public ExternalGraphLayouter getExternalLayouter() {
        return this.layouter;
    }

    public void setInterClusterLinkGrayed(boolean b) {
        this.interCluserLinkGray = b;
    }

    public boolean isInterClusterLinkGrayed() {
        return this.interCluserLinkGray;
    }

    public void setAutoLayout(boolean b) {
        this.autoLayout = b;
        this.autoLayout();
    }

    public boolean isAutoLayout() {
        return this.autoLayout;
    }

    public void setLayoutInvisibleNodes(boolean b) {
        this.layoutInvisibleNodes = b;
    }

    public boolean isLayoutInvisibleNodes() {
        return this.layoutInvisibleNodes;
    }

    public void setNodeAnimation(boolean b) {
        this.locationAnimation = b;
    }

    public boolean isNodeAnimation() {
        return this.locationAnimation;
    }

    public DiGraph getCaluculationModel() {
        return this.calculationModel.clone();
    }

    public void setHighlightClustering(boolean b) {
        this.highlightClustering = b;
    }

    public boolean isHighlightClustering() {
        return this.highlightClustering;
    }

    public boolean isClusterBordersVisible() {
        return this.clusterBordersVisible;
    }

    public void setUseCurrentNodePositions(boolean b) {
        this.USECURRENTNODEPOSITIONS = b;
    }

    public boolean isUseCurrentNodePositions() {
        return this.USECURRENTNODEPOSITIONS;
    }

    public void setClusterBordersVisible(boolean b) {
        this.clusterBordersVisible = b;
        if (this.clusters != null) {
            for (ClusterWidget w : this.clusters) {
                w.setVisibility(b);
            }
        }
        this.refreshAll();
        this.validate();
    }

    public void addInstructionSceneListener(InstructionSceneListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeInstructionSceneListener(InstructionSceneListener l) {
        this.listeners.remove(l);
    }

    protected void fireDoubleClicked(InstructionNodeWidget w) {
        for (InstructionSceneListener l : this.listeners) {
            l.doubleClicked(w);
        }
    }

    protected void fireUpdateNodeData() {
        for (InstructionSceneListener l : this.listeners) {
            l.updateNodeData();
        }
    }

    protected void fireSelectionChanged() {
        for (InstructionSceneListener l : this.listeners) {
            HashSet<InstructionNodeWidget> w = new HashSet<InstructionNodeWidget>();
            for (Object o : this.getSelectedObjects()) {
                InstructionNodeWidget wi;
                if (!(o instanceof Instruction) || (wi = this.getNodeWidget(((Instruction)o).getID())) == null) continue;
                w.add(wi);
            }
            l.selectionChanged(w);
        }
    }

    public Widget createSelectionWidget() {
        Widget ret = new Widget((Scene)this);
        ret.setBorder(BorderFactory.createDashedBorder((Color)Color.BLACK, (int)10, (int)5, (boolean)true));
        return ret;
    }

    public void performSelection(Rectangle rectangle) {
        HashSet<Instruction> set = new HashSet<Instruction>();
        if (rectangle.width < 0) {
            rectangle.x += rectangle.width;
            rectangle.width *= -1;
        }
        if (rectangle.height < 0) {
            rectangle.y += rectangle.height;
            rectangle.height *= -1;
        }
        for (InstructionNodeWidget n : this.nodewidgets.values()) {
            if (!n.isWidgetVisible() || !rectangle.contains(n.getPreferredLocation())) continue;
            set.add(n.getInstruction());
        }
        this.setSelectedObjects(set);
        this.refreshAll();
        this.validate();
        this.fireSelectionChanged();
    }

    public Point locationSuggested(Widget widget, Point original, Point suggested) {
        return suggested;
    }

    public void setSingleSelectedWidget(String id, boolean centeron) {
        InstructionNodeWidget node = this.getNodeWidget(id);
        if (node != null && node.isWidgetVisible()) {
            this.setSelectedObjects(Collections.singleton(node.getInstruction()));
            this.refreshAll();
            this.validate();
            this.fireSelectionChanged();
            if (centeron) {
                this.centerOn(node.getPreferredLocation());
            }
        }
    }

    public boolean isAimingAllowed(Widget widget, Point point, boolean b) {
        return false;
    }

    public boolean isSelectionAllowed(Widget widget, Point point, boolean b) {
        Object object = this.findObject(widget);
        return object != null && (b || !this.getSelectedObjects().contains(object));
    }

    public void select(Widget widget, Point point, boolean b) {
        Object object = this.findObject(widget);
        if (object != null) {
            if (this.getSelectedObjects().contains(object)) {
                return;
            }
            this.userSelectionSuggested(Collections.singleton(object), b);
        } else {
            this.userSelectionSuggested(Collections.emptySet(), b);
        }
        this.fireSelectionChanged();
    }

    protected Widget attachNodeWidget(Instruction node) {
        InstructionNodeWidget widget = new InstructionNodeWidget(node, (Scene)this);
        WidgetAction.Chain actions = widget.getActions();
        actions.addAction(this.createObjectHoverAction());
        actions.addAction(ActionFactory.createSelectAction((SelectProvider)this));
        actions.addAction(this.moveAction);
        actions.addAction(ActionFactory.createEditAction((EditProvider)this));
        this.nodewidgets.put(node.getID(), widget);
        this.mainLayer.addChild((Widget)widget);
        return widget;
    }

    protected void attachEdgeSourceAnchor(String edge, Instruction oldSourceNode, Instruction sourceNode) {
        ConnectionWidget edgeWidget = (ConnectionWidget)this.findWidget(edge);
        Widget sourceNodeWidget = this.findWidget(sourceNode);
        Anchor sourceAnchor = AnchorFactory.createRectangularAnchor((Widget)sourceNodeWidget);
        edgeWidget.setSourceAnchor(sourceAnchor);
    }

    protected void attachEdgeTargetAnchor(String edge, Instruction oldTargetNode, Instruction targetNode) {
        ConnectionWidget edgeWidget = (ConnectionWidget)this.findWidget(edge);
        Widget targetNodeWidget = this.findWidget(targetNode);
        Anchor targetAnchor = AnchorFactory.createRectangularAnchor((Widget)targetNodeWidget);
        edgeWidget.setTargetAnchor(targetAnchor);
    }

    protected Widget attachEdgeWidget(String edge) {
        InstructionConnectionWidget widget = new InstructionConnectionWidget((Scene)this);
        widget.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        this.connectionLayer.addChild((Widget)widget);
        widget.setRouter(this.linkRouter);
        return widget;
    }

    private class MultiWidgetMovementProvider
    implements MoveProvider {
        private MoveProvider mp = ActionFactory.createDefaultMoveProvider();

        private MultiWidgetMovementProvider() {
        }

        public void movementStarted(Widget widget) {
            this.mp.movementStarted(widget);
        }

        public void movementFinished(Widget widget) {
            this.mp.movementFinished(widget);
        }

        public Point getOriginalLocation(Widget widget) {
            return widget.getPreferredLocation();
        }

        public void setNewLocation(Widget widget, Point point) {
            ClusterWidget cw;
            boolean r;
            Scene s = widget.getScene();
            if (s instanceof InstructionNodeGraphScene && !(r = ((InstructionNodeGraphScene)s).getExternalLayouter().isMovementSupported())) {
                return;
            }
            Point original = this.getOriginalLocation(widget);
            int dx = point.x - original.x;
            int dy = point.y - original.y;
            for (Object o : InstructionNodeGraphScene.this.getSelectedObjects()) {
                InstructionNodeWidget w;
                if (!(o instanceof Instruction) || (w = InstructionNodeGraphScene.this.getNodeWidget(((Instruction)o).getID())) == widget) continue;
                Point p = (Point)w.getPreferredLocation().clone();
                p.translate(dx, dy);
                Vertex v = (Vertex)InstructionNodeGraphScene.this.WidgetToVertex.get((Object)w);
                if (v != null) {
                    v.setPosition(p);
                }
                ((GraphVertex)v).setDirty(true);
                w.setPreferredLocation(p);
                w.refresh();
                ClusterWidget cw2 = w.getClusterWidget();
                if (cw2 == null) continue;
                cw2.refresh();
            }
            this.mp.setNewLocation(widget, point);
            Vertex v = (Vertex)InstructionNodeGraphScene.this.WidgetToVertex.get(widget);
            if (v != null) {
                v.setPosition(point);
            }
            ((GraphVertex)v).setDirty(true);
            if (widget instanceof InstructionNodeWidget && (cw = ((InstructionNodeWidget)widget).getClusterWidget()) != null) {
                cw.refresh();
            }
        }
    }
}

