/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.dataflow.graph;

import at.ssw.positionmanager.Vertex;
import at.ssw.positionmanager.impl.GraphVertex;
import at.ssw.visualizer.dataflow.graph.InstructionNodeGraphScene;
import at.ssw.visualizer.dataflow.graph.InstructionNodeWidget;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.api.visual.animator.Animator;

public class SetLocationAnimator
extends Animator {
    private LinkedList<InstructionNodeWidget> widgets = new LinkedList();
    private LinkedList<Point> startpoint = new LinkedList();
    private LinkedList<Point> targetpoint = new LinkedList();
    private InstructionNodeGraphScene scene;

    public SetLocationAnimator(InstructionNodeGraphScene scene, Hashtable<Vertex, InstructionNodeWidget> VertexToWidget) {
        super(scene.getSceneAnimator());
        if (VertexToWidget == null) {
            return;
        }
        this.scene = scene;
        for (Map.Entry<Vertex, InstructionNodeWidget> e : VertexToWidget.entrySet()) {
            Point p1 = e.getKey().getPosition();
            if (p1 == null) {
                p1 = new Point();
            } else {
                p1.translate(5, 5);
            }
            Point p2 = e.getValue().getPreferredLocation();
            if (p2 == null) {
                p2 = new Point();
            }
            e.getKey().setPosition(p2);
            if (p1.x != p2.x || p1.y != p2.y) {
                this.startpoint.add(p2);
                this.targetpoint.add(p1);
                this.widgets.add(e.getValue());
                continue;
            }
            Vertex v = e.getKey();
            if (!(v instanceof GraphVertex)) continue;
            ((GraphVertex)v).setDirty(true);
        }
    }

    public void animate() {
        this.start();
    }

    protected void tick(double d) {
        Iterator w = this.widgets.iterator();
        Iterator start = this.startpoint.iterator();
        Iterator target = this.targetpoint.iterator();
        while (w.hasNext()) {
            InstructionNodeWidget widget = (InstructionNodeWidget)((Object)w.next());
            Point p1 = (Point)start.next();
            Point p2 = (Point)target.next();
            Point p3 = d >= 1.0 ? p2 : new Point((int)((double)p1.x + d * (double)(p2.x - p1.x)), (int)((double)p1.y + d * (double)(p2.y - p1.y)));
            widget.setPreferredLocation(p3);
            Vertex v = this.scene.getWidgetToVertex().get((Object)widget);
            if (v != null) {
                v.setPosition(p3);
            }
            if (!(v instanceof GraphVertex)) continue;
            ((GraphVertex)v).setDirty(true);
        }
        this.scene.refreshClusterWidgets();
    }
}

