/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.dataflow.instructions;

import java.util.ArrayList;

public class Instruction {
    private String id;
    private String sourceBlock;
    private String instructionString;
    private ArrayList<Instruction> predecessors;
    private ArrayList<Instruction> successors;
    private InstructionType type;

    protected Instruction(String id) {
        this.id = id;
        this.predecessors = new ArrayList();
        this.successors = new ArrayList();
        this.instructionString = null;
        this.sourceBlock = null;
        this.type = InstructionType.UNKNOWN;
    }

    protected Instruction(String id, String instruction, String source, Instruction[] pre, Instruction[] succ, InstructionType t) {
        this.id = id;
        this.instructionString = instruction;
        this.predecessors = new ArrayList();
        this.successors = new ArrayList();
        this.sourceBlock = source;
        if (pre != null) {
            for (Instruction i : pre) {
                this.predecessors.add(i);
            }
        }
        if (succ != null) {
            for (Instruction i : succ) {
                this.successors.add(i);
            }
        }
        this.type = t;
    }

    public boolean equals(Object o) {
        if (o instanceof Instruction) {
            return ((Instruction)o).getID().equals(this.id);
        }
        return false;
    }

    public String getID() {
        return this.id;
    }

    protected void setInstructionString(String is) {
        this.instructionString = is;
    }

    public String getInstructionString() {
        return this.instructionString;
    }

    public String getSourceBlock() {
        return this.sourceBlock;
    }

    protected void setSourceBlock(String s) {
        this.sourceBlock = s;
    }

    protected void setInstructionType(InstructionType t) {
        this.type = t;
    }

    public InstructionType getInstructionType() {
        return this.type;
    }

    public Instruction[] getPredecessors() {
        Instruction[] ret = new Instruction[this.predecessors.size()];
        ret = this.predecessors.toArray(ret);
        return ret;
    }

    protected void addPredecessor(Instruction i) {
        this.predecessors.add(i);
    }

    protected void removePredecessor(Instruction i) {
        this.predecessors.remove(i);
    }

    public Instruction[] getSuccessors() {
        Instruction[] ret = new Instruction[this.successors.size()];
        ret = this.successors.toArray(ret);
        return ret;
    }

    protected void addSuccessors(Instruction i) {
        this.successors.add(i);
    }

    protected void removeSuccessors(Instruction i) {
        this.successors.remove(i);
    }

    public static enum InstructionType {
        UNKNOWN,
        CONSTANT,
        PHI,
        PARAMETER,
        OPERATION,
        CONTROLFLOW;

    }
}

