/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.dataflow.instructions;

import at.ssw.visualizer.dataflow.instructions.Instruction;
import java.util.Hashtable;
import java.util.LinkedList;

public class InstructionSet {
    private Hashtable<String, Instruction> instructions = new Hashtable();

    public Instruction getInstruction(String id) {
        if (this.instructions.containsKey(id)) {
            return this.instructions.get(id);
        }
        Instruction i = new Instruction(id);
        this.instructions.put(id, i);
        return i;
    }

    public boolean addLink(Instruction from, Instruction to) {
        if (from != null && to != null) {
            from.addSuccessors(to);
            to.addPredecessor(from);
            return true;
        }
        return false;
    }

    public Instruction[] getInstructions() {
        Instruction[] inst = new Instruction[this.instructions.size()];
        inst = this.instructions.values().toArray(inst);
        return inst;
    }

    public static Instruction[] filterInstructionType(Instruction[] iset, Instruction.InstructionType type) {
        LinkedList<Instruction> list = new LinkedList<Instruction>();
        for (Instruction i : iset) {
            if (i.getInstructionType() == type) continue;
            list.add(i);
        }
        Instruction[] ret = new Instruction[list.size()];
        return list.toArray(ret);
    }
}

