/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.dataflow.instructions;

import at.ssw.visualizer.dataflow.instructions.Instruction;
import at.ssw.visualizer.dataflow.instructions.InstructionSet;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.IRInstruction;
import at.ssw.visualizer.model.cfg.State;
import at.ssw.visualizer.model.cfg.StateEntry;
import java.util.ArrayList;
import java.util.List;

public class InstructionSetGenerator {
    private static String idStart = "ailfdv";
    private static char idBlock = (char)66;

    public static InstructionSet generateFromBlocks(List<BasicBlock> blocks) {
        if (blocks == null) {
            return null;
        }
        InstructionSet iset = new InstructionSet();
        for (BasicBlock b : blocks) {
            Instruction instr2;
            Instruction instr1;
            if (!b.hasHir()) continue;
            for (IRInstruction hi : b.getHirInstructions()) {
                instr1 = iset.getInstruction(hi.getValue("tid"));
                instr1.setInstructionString(hi.getValue("instruction"));
                instr1.setSourceBlock(b.getName());
                if (InstructionSetGenerator.containsBlockIdentifier(hi.getValue("instruction"))) {
                    instr1.setInstructionType(Instruction.InstructionType.CONTROLFLOW);
                } else if (InstructionSetGenerator.startsLikeConstant(hi.getValue("instruction"))) {
                    instr1.setInstructionType(Instruction.InstructionType.CONSTANT);
                } else {
                    instr1.setInstructionType(Instruction.InstructionType.OPERATION);
                }
                for (String s : InstructionSetGenerator.parseInstructionString(hi.getValue("instruction"))) {
                    instr2 = iset.getInstruction(s);
                    if (instr1 != instr2) {
                        iset.addLink(instr2, instr1);
                    }
                    instr1.setInstructionType(Instruction.InstructionType.OPERATION);
                }
            }
            for (State state : b.getStates()) {
                for (StateEntry stentry : state.getEntries()) {
                    instr1 = iset.getInstruction(stentry.getName());
                    if (instr1.getInstructionString() == null && !stentry.hasPhiOperands()) {
                        instr1.setInstructionString("");
                        instr1.setInstructionType(Instruction.InstructionType.PARAMETER);
                        instr1.setSourceBlock(b.getName());
                    }
                    if (!stentry.hasPhiOperands()) continue;
                    instr1.setSourceBlock(b.getName());
                    instr1.setInstructionType(Instruction.InstructionType.PHI);
                    String instrString = "Phi[";
                    for (String s : stentry.getPhiOperands()) {
                        instr2 = iset.getInstruction(s);
                        if (instr1 != instr2) {
                            iset.addLink(instr2, instr1);
                        }
                        instrString = instrString + s + ",";
                    }
                    instr1.setInstructionString(instrString.substring(0, instrString.length() - 1) + "]");
                }
            }
        }
        return iset;
    }

    private static boolean containsBlockIdentifier(String iString) {
        int pos = iString.indexOf(idBlock);
        return pos != -1 && iString.length() > pos + 1 && InstructionSetGenerator.isNumber(iString.charAt(pos + 1));
    }

    private static ArrayList<String> parseInstructionString(String iString) {
        ArrayList<String> list = new ArrayList<String>(2);
        if (iString != null) {
            int from = 0;
            int pos = 0;
            while (pos < iString.length()) {
                if (idStart.indexOf(iString.charAt(pos)) != -1) {
                    if (pos + 1 < iString.length() && InstructionSetGenerator.isNumber(iString.charAt(pos + 1)) && (pos == 0 || !InstructionSetGenerator.isAlphaNumeric(iString.charAt(pos - 1)))) {
                        from = pos++;
                        while (pos < iString.length() && InstructionSetGenerator.isNumber(iString.charAt(pos))) {
                            ++pos;
                        }
                        if (iString.length() != pos && InstructionSetGenerator.isAlphaNumeric(iString.charAt(pos))) continue;
                        list.add(iString.substring(from, pos));
                        continue;
                    }
                    ++pos;
                    continue;
                }
                ++pos;
            }
        }
        return list;
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphaNumeric(char c) {
        if (InstructionSetGenerator.isNumber(c)) {
            return true;
        }
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean startsLikeConstant(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (s.startsWith("<instance") || s.startsWith("Class") || s.startsWith("null") || InstructionSetGenerator.isNumber(s.charAt(0))) {
            return true;
        }
        if ((s.charAt(0) == '-' || s.charAt(0) == '+') && s.length() > 1) {
            return InstructionSetGenerator.isNumber(s.charAt(1));
        }
        return false;
    }
}

