/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.action;

import at.ssw.visualizer.cfg.action.AbstractCfgEditorAction;
import at.ssw.visualizer.cfg.editor.CfgEditorTopComponent;
import at.ssw.visualizer.cfg.graph.CfgScene;
import at.ssw.visualizer.cfg.graph.EdgeWidget;
import at.ssw.visualizer.cfg.model.CfgEdge;
import at.ssw.visualizer.cfg.model.CfgNode;
import org.openide.util.HelpCtx;

public class ShowEdgesAction
extends AbstractCfgEditorAction {
    public void performAction() {
        CfgEditorTopComponent tc = this.getEditor();
        if (tc != null) {
            tc.getCfgScene().setSelectedEdgesVisibility(true);
        }
    }

    public String getName() {
        return "Show edges";
    }

    protected String iconResource() {
        return "at/ssw/visualizer/cfg/icons/showedges.gif";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    public void selectionChanged(CfgScene scene) {
        for (CfgNode n : scene.getSelectedNodes()) {
            for (CfgEdge e : scene.findNodeEdges(n, true, true)) {
                EdgeWidget ew = (EdgeWidget)scene.findWidget(e);
                if (ew.isVisible()) continue;
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }
}

