/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.action;

import at.ssw.visualizer.cfg.action.AbstractCfgEditorAction;
import at.ssw.visualizer.cfg.editor.CfgEditorTopComponent;
import at.ssw.visualizer.cfg.graph.CfgScene;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.openide.util.HelpCtx;
import org.openide.util.actions.Presenter;

public class SwitchLoopClustersAction
extends AbstractCfgEditorAction
implements Presenter.Toolbar {
    public void performAction() {
        CfgEditorTopComponent tc = this.getEditor();
        if (tc != null) {
            CfgScene scene;
            boolean visible = (scene = tc.getCfgScene()).isLoopClusterVisible();
            scene.setLoopWidgets(!visible);
        }
    }

    public String getName() {
        return "Enable/Disable Loop Clusters";
    }

    protected String iconResource() {
        return "at/ssw/visualizer/cfg/icons/cluster.gif";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    public JComponent getToolbarPresenter() {
        return new ToolbarPresenter();
    }

    class ToolbarPresenter
    extends JToggleButton {
        private static final String TOOLTIP_ENABLE = "Enable LoopClusters";
        private static final String TOOLTIP_DISABLE = "Disable LoopClusters";

        public ToolbarPresenter() {
            super((Action)((Object)SwitchLoopClustersAction.this));
            this.setText(null);
            this.setToolTipText(TOOLTIP_DISABLE);
            this.setSelected(true);
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (ToolbarPresenter.this.isSelected()) {
                        ToolbarPresenter.this.setToolTipText(ToolbarPresenter.TOOLTIP_DISABLE);
                    } else {
                        ToolbarPresenter.this.setToolTipText(ToolbarPresenter.TOOLTIP_ENABLE);
                    }
                }
            });
        }
    }
}

