/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.graph;

import at.ssw.visualizer.cfg.graph.CfgScene;
import at.ssw.visualizer.cfg.model.CfgEdge;
import at.ssw.visualizer.cfg.preferences.CfgPreferences;
import at.ssw.visualizer.cfg.visual.SplineConnectionWidget;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.AnchorShapeFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class EdgeWidget
extends SplineConnectionWidget {
    private boolean visible = true;
    protected static final Stroke selectedStroke = new BasicStroke(3.0f, 1, 1);
    protected static final Stroke defaultStroke = new BasicStroke(1.5f, 1, 1);
    protected static final Stroke previewStroke = new BasicStroke(0.5f, 2, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);

    public EdgeWidget(CfgScene scene, CfgEdge edge) {
        super((Scene)scene);
        CfgPreferences prefs = CfgPreferences.getInstance();
        Color lineColor = edge.isBackEdge() ? prefs.getBackedgeColor() : (edge.isXhandler() ? prefs.getExceptionEdgeColor() : prefs.getEdgeColor());
        this.setLineColor(lineColor);
        AnchorShape as = edge.isReflexive() ? AnchorShapeFactory.createTriangleAnchorShape((int)6, (boolean)true, (boolean)false, (int)5) : AnchorShapeFactory.createTriangleAnchorShape((int)10, (boolean)true, (boolean)false, (int)9);
        this.setTargetAnchorShape(as);
        this.setToolTipText(edge.toString());
    }

    public CfgEdge getEdgeModel() {
        CfgScene scene = (CfgScene)this.getScene();
        return (CfgEdge)scene.findObject((Widget)this);
    }

    public void setEdgeVisible(boolean visible) {
        this.visible = visible;
        this.setVisible(visible);
        this.reroute();
        this.revalidate();
    }

    public boolean isEdgeVisible() {
        return this.visible;
    }

    public void notifyStateChanged(ObjectState oldState, ObjectState newState) {
        this.setForeground(this.getLineColor());
        if (newState.isHighlighted() && !oldState.isHighlighted()) {
            this.setStroke(previewStroke);
            this.setVisible(true);
        } else {
            if (newState.isSelected()) {
                this.setStroke(selectedStroke);
            } else {
                this.setStroke(defaultStroke);
            }
            if (this.isEdgeVisible()) {
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        }
    }

    public String toString() {
        return "EdgeWidget[" + this.getEdgeModel().toString() + "]";
    }
}

