/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.graph;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.widget.Widget;

public final class SymmetricAnchor
extends Anchor {
    private static final int OFFSET = 10;
    private boolean includeBorders;
    private int offx;
    private int offy;

    public SymmetricAnchor(Widget widget, boolean includeBorders, boolean source) {
        super(widget);
        this.includeBorders = includeBorders;
        if (source) {
            this.offx = 10;
            this.offy = 10;
        } else {
            this.offx = -10;
            this.offy = -10;
        }
    }

    public Anchor.Result compute(Anchor.Entry entry) {
        Anchor.Direction direction;
        float ddy;
        Point relatedLocation = this.getRelatedSceneLocation();
        Point oppositeLocation = this.getOppositeSceneLocation(entry);
        Widget widget = this.getRelatedWidget();
        Rectangle bounds = widget.getBounds();
        if (!this.includeBorders) {
            Insets insets = widget.getBorder().getInsets();
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
        }
        if ((bounds = widget.convertLocalToScene(bounds)).isEmpty() || relatedLocation.equals(oppositeLocation)) {
            return new Anchor.Result((Anchor)this, relatedLocation, Anchor.DIRECTION_ANY);
        }
        float dx = oppositeLocation.x - relatedLocation.x;
        float dy = oppositeLocation.y - relatedLocation.y;
        float ddx = Math.abs(dx) / (float)bounds.width;
        if (ddx >= (ddy = Math.abs(dy) / (float)bounds.height)) {
            if (dx >= 0.0f) {
                direction = Anchor.Direction.RIGHT;
                relatedLocation.y -= this.offy;
            } else {
                direction = Anchor.Direction.LEFT;
                relatedLocation.y += this.offy;
            }
        } else if (dy >= 0.0f) {
            direction = Anchor.Direction.BOTTOM;
            relatedLocation.x += this.offx;
        } else {
            direction = Anchor.Direction.TOP;
            relatedLocation.x -= this.offx;
        }
        float scale = 0.5f / Math.max(ddx, ddy);
        float ex = scale * dx;
        float ey = scale * dy;
        Point point = new Point(Math.round((float)relatedLocation.x + ex), Math.round((float)relatedLocation.y + ey));
        if (direction == Anchor.Direction.RIGHT) {
            int top = bounds.y;
            int bottom = bounds.y + bounds.height;
            if (point.y < top) {
                int cor = top - point.y;
                point.x -= cor;
                point.y += cor;
            } else if (point.y > bottom) {
                int cor = point.y - bottom;
                point.x -= cor;
                point.y -= cor;
            }
        } else if (direction == Anchor.Direction.LEFT) {
            int top = bounds.y;
            int bottom = bounds.y + bounds.height;
            if (point.y < top) {
                int cor = top - point.y;
                point.x += cor;
                point.y += cor;
            } else if (point.y > bottom) {
                int cor = bottom - point.y;
                point.x -= cor;
                point.y += cor;
            }
        } else if (direction == Anchor.Direction.BOTTOM) {
            int left = bounds.x;
            int right = bounds.x + bounds.width;
            if (point.x < left) {
                int cor = left - point.x;
                point.x += cor;
                point.y -= cor;
            } else if (point.x > right) {
                int cor = point.x - right;
                point.x -= cor;
                point.y -= cor;
            }
        } else if (direction == Anchor.Direction.TOP) {
            int left = bounds.x;
            int right = bounds.x + bounds.width;
            if (point.x < left) {
                int cor = left - point.x;
                point.x += cor;
                point.y += cor;
            } else if (point.x > right) {
                int cor = point.x - right;
                point.x -= cor;
                point.y += cor;
            }
        }
        return new Anchor.Result((Anchor)this, point, direction);
    }
}

