/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.graph.layout;

import at.ssw.visualizer.cfg.graph.CfgScene;
import at.ssw.visualizer.cfg.model.CfgEdge;
import at.ssw.visualizer.cfg.model.CfgNode;
import java.awt.Point;
import java.util.Collection;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;

public class HierarchicalNodeLayout
extends GraphLayout<CfgNode, CfgEdge> {
    private static final int TOP_BORDER = 20;
    private static final int LEFT_BORDER = 40;
    private CfgScene scene;

    public HierarchicalNodeLayout(CfgScene scene) {
        this.scene = scene;
    }

    protected void performGraphLayout(UniversalGraph<CfgNode, CfgEdge> ug) {
        DirectedGraph dg = new DirectedGraph();
        DirectedGraphLayout layout = new DirectedGraphLayout();
        NodeList nodeList = dg.nodes;
        EdgeList edgeList = dg.edges;
        for (CfgNode n : this.scene.getCfgEnv().getNodes()) {
            Widget nodeWidget = this.scene.findWidget(n);
            Node node = new Node((Object)n);
            node.width = nodeWidget.getBounds().width;
            node.height = nodeWidget.getBounds().height;
            nodeList.add((Object)node);
        }
        for (CfgEdge e : this.scene.getCfgEnv().getEdges()) {
            if (e.isBackEdge()) continue;
            Edge edge = new Edge((Object)e, nodeList.getNode(e.getSourceNode().getNodeIndex()), nodeList.getNode(e.getTargetNode().getNodeIndex()));
            edgeList.add((Object)edge);
        }
        layout.visit(dg);
        for (Object obj : dg.nodes) {
            Node n = (Node)obj;
            CfgNode cfgNode = (CfgNode)n.data;
            Point pos = new Point(n.x + 40, n.y + 20);
            Point scenepos = this.scene.convertLocalToScene(pos);
            this.setResolvedNodeLocation(ug, cfgNode, scenepos);
        }
    }

    protected void performNodesLayout(UniversalGraph<CfgNode, CfgEdge> ug, Collection<CfgNode> collection) {
    }
}

