/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.preferences;

import at.ssw.visualizer.cfg.preferences.ColorChooserButton;
import at.ssw.visualizer.cfg.preferences.FlagsSetting;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FlagsEditorPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    FlagListModel listModel;
    JList list;
    ColorChooserButton colorButton;
    JButton newButton;
    JButton removeButton;
    JButton upButton;
    JButton downButton;

    public FlagsEditorPanel(String flagString) {
        this.setLayout(new BoxLayout(this, 0));
        this.listModel = new FlagListModel(flagString);
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.add(new JScrollPane(this.list));
        this.add(Box.createHorizontalStrut(3));
        Box buttonBox = new Box(1);
        this.colorButton = new ColorChooserButton();
        buttonBox.add(this.colorButton);
        this.newButton = new JButton("New...");
        buttonBox.add(this.newButton);
        this.removeButton = new JButton("Remove");
        buttonBox.add(this.removeButton);
        this.upButton = new JButton("Up");
        buttonBox.add(this.upButton);
        this.downButton = new JButton("Down");
        buttonBox.add(this.downButton);
        buttonBox.add(Box.createVerticalGlue());
        this.add(buttonBox);
        FlagsEditorPanel.layoutButtonContainer(buttonBox);
        this.colorButton.setColorChooserEnabled(false);
        this.colorButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.selectionChanged(-1);
    }

    private static void layoutButtonContainer(JComponent buttonContainer) {
        int width = 0;
        int height = 0;
        for (int i = 0; i < buttonContainer.getComponentCount(); ++i) {
            Component c = buttonContainer.getComponent(i);
            if (!(c instanceof JButton)) continue;
            JButton b = (JButton)c;
            if (width < b.getPreferredSize().width) {
                width = b.getPreferredSize().width;
            }
            if (height >= b.getPreferredSize().height) continue;
            height = b.getPreferredSize().height;
        }
        Dimension commonButtonSize = new Dimension(width, height);
        for (int i = 0; i < buttonContainer.getComponentCount(); ++i) {
            Component c = buttonContainer.getComponent(i);
            if (!(c instanceof JButton)) continue;
            JButton b = (JButton)c;
            b.setMinimumSize(commonButtonSize);
            b.setPreferredSize(commonButtonSize);
            b.setMaximumSize(commonButtonSize);
        }
    }

    public String getFlagString() {
        return this.listModel.getFlagString();
    }

    public void setFlagString(String flagString) {
        this.listModel.setFlagString(flagString);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.colorButton) {
            this.changeColor();
        } else if (source == this.newButton) {
            String s = JOptionPane.showInputDialog(this, (Object)"Type in the flag which should fill the block with a specific color");
            if (s == null) {
                return;
            }
            s = s.replace('(', ' ');
            s = s.replace(';', ' ');
            int index = this.list.getSelectedIndex() + 1;
            this.listModel.insertElementAt(new FlagListItem(s, Color.WHITE), index);
        } else if (source == this.removeButton) {
            this.listModel.removeElementAt(this.list.getSelectedIndex());
        } else if (source == this.upButton) {
            int index = this.list.getSelectedIndex();
            if (index == 0) {
                return;
            }
            Object o = this.listModel.getElementAt(index);
            this.listModel.removeElementAt(index);
            this.listModel.insertElementAt(o, index - 1);
        } else if (source == this.downButton) {
            int index = this.list.getSelectedIndex();
            if (index >= this.listModel.size() - 1) {
                return;
            }
            Object o = this.listModel.getElementAt(index);
            this.listModel.removeElementAt(index);
            this.listModel.insertElementAt(o, index + 1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.selectionChanged(this.list.getSelectedIndex());
    }

    protected void selectionChanged(int index) {
        this.colorButton.setEnabled(index >= 0);
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(index > 0);
        this.downButton.setEnabled(index >= 0 && index < this.listModel.getSize() - 1);
        if (index >= 0) {
            FlagListItem item = (FlagListItem)this.listModel.elementAt(index);
            this.colorButton.setColor(item.getColor());
            this.list.setSelectedIndex(index);
        } else {
            this.colorButton.setColor(this.getBackground());
        }
    }

    protected void changeColor() {
        int selectedIndex = this.list.getSelectedIndex();
        FlagListItem item = (FlagListItem)this.listModel.elementAt(selectedIndex);
        Color c = JColorChooser.showDialog(this, "Choose color", item.getColor());
        if (c != null) {
            item.setColor(c);
            this.colorButton.setColor(c);
        }
    }

    class FlagListModel
    extends DefaultListModel {
        public FlagListModel(String flagString) {
            if (flagString != null) {
                this.setFlagString(flagString);
            }
        }

        public String getFlagString() {
            StringBuffer sb = new StringBuffer();
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                FlagListItem item = (FlagListItem)e.nextElement();
                sb.append(item.getFlagString());
                Color c = item.getColor();
                sb.append("(").append(c.getRed()).append(",").append(c.getGreen()).append(",").append(c.getBlue()).append(")");
                if (!e.hasMoreElements()) continue;
                sb.append(";");
            }
            return sb.toString();
        }

        public void setFlagString(String flagString) {
            this.clear();
            StringTokenizer st = new StringTokenizer(flagString, ";");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                String flag = s.split("\\(")[0];
                Color color = FlagsSetting.toColor(s);
                this.addElement(new FlagListItem(flag, color));
            }
        }
    }

    class FlagListItem {
        Color color;
        String flagString;

        public FlagListItem(String flagString, Color color) {
            this.flagString = flagString;
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public String getFlagString() {
            return this.flagString;
        }

        public void setColor(Color c) {
            this.color = c;
        }

        public String toString() {
            return this.flagString;
        }
    }
}

