/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.visual;

import at.ssw.visualizer.cfg.visual.WidgetCollisionCollector;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class PolylineRouterV2
implements Router {
    private static final int HEXPAND = 3;
    private static final int VEXPAND = 3;
    private static final int NUMBER_OF_ITERATIONS = 8;
    WidgetCollisionCollector collector;

    public PolylineRouterV2(WidgetCollisionCollector collector) {
        this.collector = collector;
    }

    public List<Point> routeConnection(ConnectionWidget widget) {
        Widget targetWidget;
        if (!widget.isVisible()) {
            return Collections.emptyList();
        }
        Anchor sourceAnchor = widget.getSourceAnchor();
        Anchor targetAnchor = widget.getTargetAnchor();
        if (sourceAnchor == null || targetAnchor == null) {
            return null;
        }
        Point start = sourceAnchor.compute(widget.getSourceAnchorEntry()).getAnchorSceneLocation();
        Point end = targetAnchor.compute(widget.getTargetAnchorEntry()).getAnchorSceneLocation();
        Widget sourceWidget = sourceAnchor.getRelatedWidget();
        if (sourceWidget == (targetWidget = targetAnchor.getRelatedWidget())) {
            return Collections.emptyList();
        }
        Point srcCenter = this.getSceneLocation(sourceWidget);
        Point tarCenter = this.getSceneLocation(targetWidget);
        ArrayList<Widget> widgetObstacles = new ArrayList<Widget>();
        if (this.collector != null) {
            this.collector.collectCollisions(widgetObstacles);
        }
        ArrayList<Rectangle> obstacles = new ArrayList<Rectangle>(widgetObstacles.size());
        this.collectObstacles(obstacles, widgetObstacles, widget);
        List<Point> controlPoints = this.optimize(obstacles, srcCenter, tarCenter);
        if (controlPoints.size() > 3) {
            Point rstart = this.computateAnchorPosition(sourceWidget, controlPoints.get(1));
            Point rend = this.computateAnchorPosition(targetWidget, controlPoints.get(controlPoints.size() - 2));
            controlPoints.set(0, rstart);
            controlPoints.set(controlPoints.size() - 1, rend);
            controlPoints = this.simplify(obstacles, controlPoints);
        } else if (controlPoints.size() >= 2) {
            controlPoints.set(0, start);
            controlPoints.set(controlPoints.size() - 1, end);
        }
        return controlPoints;
    }

    private int collectObstacles(List<Rectangle> colrects, List<Widget> colwidgets, ConnectionWidget cw) {
        int count = 0;
        Anchor sourceAnchor = cw.getSourceAnchor();
        Anchor targetAnchor = cw.getTargetAnchor();
        Widget sourceWidget = sourceAnchor.getRelatedWidget();
        Widget targetWidget = targetAnchor.getRelatedWidget();
        Point start = sourceAnchor.compute(cw.getSourceAnchorEntry()).getAnchorSceneLocation();
        Point end = targetAnchor.compute(cw.getTargetAnchorEntry()).getAnchorSceneLocation();
        for (Widget w : colwidgets) {
            if (w == sourceWidget || w == targetWidget) continue;
            Rectangle r = w.convertLocalToScene(w.getBounds());
            r.grow(3, 3);
            if (r.intersectsLine(start.x, start.y, end.x, end.y)) {
                ++count;
            }
            colrects.add(r);
        }
        return count;
    }

    private Point center(Rectangle bounds) {
        return new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    public Point getSceneLocation(Widget relatedWidget) {
        Rectangle bounds;
        if (relatedWidget != null && (bounds = relatedWidget.getBounds()) != null) {
            return this.center(relatedWidget.convertLocalToScene(bounds));
        }
        return null;
    }

    private Point computateAnchorPosition(Widget relatedWidget, Point controlPoint) {
        Rectangle bounds = relatedWidget.getBounds();
        Point relatedLocation = relatedWidget.getLocation();
        if (bounds.isEmpty() || relatedLocation.equals(controlPoint)) {
            return relatedLocation;
        }
        float dx = controlPoint.x - relatedLocation.x;
        float dy = controlPoint.y - relatedLocation.y;
        float ddx = Math.abs(dx) / (float)bounds.width;
        float ddy = Math.abs(dy) / (float)bounds.height;
        float scale = 0.5f / Math.max(ddx, ddy);
        Point point = new Point(Math.round((float)relatedLocation.x + scale * dx), Math.round((float)relatedLocation.y + scale * dy));
        return point;
    }

    private List<Point> simplify(List<Rectangle> obstacles, List<Point> list) {
        ArrayList<Point> result = new ArrayList<Point>(list.size());
        result.add(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            Point prev = list.get(i - 1);
            for (int j = i; j < list.size(); ++j) {
                Point cur = list.get(j);
                if (PolylineRouterV2.intersects(obstacles, prev, cur)) continue;
                i = j;
            }
            result.add(list.get(i));
        }
        return result;
    }

    private List<Point> optimize(List<Rectangle> nodeWidgets, Point start, Point end) {
        ArrayList<Point> list = new ArrayList<Point>();
        list.add(start);
        list.add(end);
        boolean progress = true;
        for (int j = 0; progress && j < 8; ++j) {
            progress = false;
            ArrayList<Point> newList = new ArrayList<Point>();
            for (int i = 0; i < list.size() - 1; ++i) {
                Point cur = (Point)list.get(i);
                Point next = (Point)list.get(i + 1);
                newList.add(cur);
                List<Point> intermediate = this.optimizeLine(nodeWidgets, cur, next);
                if (intermediate == null || intermediate.size() <= 0) continue;
                progress = true;
                newList.addAll(intermediate);
            }
            newList.add((Point)list.get(list.size() - 1));
            list = newList;
        }
        return list;
    }

    private List<Point> optimizeLine(List<Rectangle> obstacles, Point p1, Point p2) {
        Line2D.Double line = new Line2D.Double(p1, p2);
        boolean inbounds = false;
        Rectangle ibr = null;
        ArrayList<Point> sol = new ArrayList<Point>();
        Point interLeft = new Point();
        Point interRight = new Point();
        Point interBot = new Point();
        Point interTop = new Point();
        for (Rectangle r : obstacles) {
            if (!line.intersects(r)) continue;
            int w = r.width + 2;
            int h = r.height + 2;
            Point topLeft = r.getLocation();
            --topLeft.x;
            --topLeft.y;
            Point topRight = new Point(topLeft.x + w, topLeft.y);
            Point bottomLeft = new Point(topLeft.x, topLeft.y + h);
            Point bottomRight = new Point(topRight.x, bottomLeft.y);
            boolean leftIntersection = this.findIntersectionPoint(p1, p2, topLeft, bottomLeft, interLeft);
            boolean rightIntersection = this.findIntersectionPoint(p1, p2, topRight, bottomRight, interRight);
            boolean bottomIntersection = this.findIntersectionPoint(p1, p2, bottomLeft, bottomRight, interBot);
            boolean topIntersection = this.findIntersectionPoint(p1, p2, topLeft, topRight, interTop);
            if (leftIntersection) {
                if (topIntersection) {
                    sol.add(topLeft);
                } else if (bottomIntersection) {
                    sol.add(bottomLeft);
                } else if (rightIntersection) {
                    double distbl;
                    double disttl = topLeft.distance(p1);
                    if (disttl > (distbl = bottomLeft.distance(p1))) {
                        double distbr = bottomRight.distance(p1);
                        if (distbl < distbr) {
                            sol.add(bottomLeft);
                            sol.add(bottomRight);
                        } else {
                            sol.add(bottomRight);
                            sol.add(bottomLeft);
                        }
                    } else {
                        double disttr = topRight.distance(p1);
                        if (disttl < disttr) {
                            sol.add(topLeft);
                            sol.add(topRight);
                        } else {
                            sol.add(topRight);
                            sol.add(topLeft);
                        }
                    }
                } else {
                    inbounds = true;
                }
            } else if (rightIntersection) {
                if (topIntersection) {
                    sol.add(topRight);
                } else if (bottomIntersection) {
                    sol.add(bottomRight);
                } else {
                    inbounds = true;
                }
            } else if (topIntersection && bottomIntersection) {
                double distbot;
                double disttop = interTop.distance(p1);
                if (disttop < (distbot = interBot.distance(p1))) {
                    double distright;
                    double distleft = interTop.distance(topLeft);
                    if (distleft < (distright = interTop.distance(topRight))) {
                        sol.add(topLeft);
                        sol.add(bottomLeft);
                    } else {
                        sol.add(topRight);
                        sol.add(bottomRight);
                    }
                } else {
                    double distright;
                    double distleft = interBot.distance(bottomLeft);
                    if (distleft < (distright = interBot.distance(bottomRight))) {
                        sol.add(bottomLeft);
                        sol.add(topLeft);
                    } else {
                        sol.add(bottomRight);
                        sol.add(topRight);
                    }
                }
            } else {
                inbounds = true;
            }
            if (sol.size() > 0) {
                assert (!inbounds);
                return sol;
            }
            assert (inbounds);
            assert (sol.size() == 0);
            ibr = r;
            break;
        }
        if (inbounds || ibr != null) {
            assert (inbounds);
            assert (ibr != null);
        }
        return null;
    }

    private static boolean intersects(List<Rectangle> obstacles, Point p0, Point p1) {
        for (Rectangle r : obstacles) {
            if (!r.intersectsLine(p0.x, p0.y, p1.x, p1.y)) continue;
            return true;
        }
        return false;
    }

    private boolean findIntersectionPoint(Point p0, Point p1, Point p2, Point p3, Point pI) {
        float q = (p0.y - p2.y) * (p3.x - p2.x) - (p0.x - p2.x) * (p3.y - p2.y);
        float d = (p1.x - p0.x) * (p3.y - p2.y) - (p1.y - p0.y) * (p3.x - p2.x);
        if (d == 0.0f) {
            return false;
        }
        float r = q / d;
        q = (p0.y - p2.y) * (p1.x - p0.x) - (p0.x - p2.x) * (p1.y - p0.y);
        float s = q / d;
        if (r < 0.0f || r > 1.0f || s < 0.0f || s > 1.0f) {
            return false;
        }
        pI.x = p0.x + (int)(0.5f + r * (float)(p1.x - p0.x));
        pI.y = p0.y + (int)(0.5f + r * (float)(p1.y - p0.y));
        return true;
    }
}

