/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.visual;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class SplineConnectionWidget
extends ConnectionWidget {
    private static final double ENDPOINT_DEVIATION = 3.0;
    private static final double HIT_DISTANCE_SQUARE = 4.0;
    private GraphScene scene = null;
    private Point2D[] bezierPoints = null;

    public SplineConnectionWidget(Scene scene) {
        super(scene);
        if (scene instanceof GraphScene) {
            this.scene = (GraphScene)scene;
        }
    }

    private boolean isReflexive() {
        return this.getSourceAnchor().getRelatedWidget() == this.getTargetAnchor().getRelatedWidget();
    }

    protected Rectangle calculateClientArea() {
        Rectangle bounds = null;
        if (this.getControlPoints().size() > 2) {
            this.bezierPoints = this.createBezierPoints(this.getControlPoints());
        }
        if (this.bezierPoints != null) {
            RectangularShape bounds2D = null;
            for (int i = 0; i < this.bezierPoints.length; ++i) {
                Point2D point = this.bezierPoints[i];
                if (bounds2D == null) {
                    bounds2D = new Rectangle2D.Double(point.getX(), point.getY(), 0.0, 0.0);
                    continue;
                }
                ((Rectangle2D)bounds2D).add(point);
            }
            bounds = bounds2D.getBounds();
            bounds.grow(2, 2);
        } else if (this.getControlPoints().size() > 0) {
            for (Point p : this.getControlPoints()) {
                if (bounds == null) {
                    bounds = new Rectangle(p);
                    continue;
                }
                bounds.add(p);
            }
            bounds.grow(5, 5);
        } else if (this.isReflexive()) {
            Widget related = this.getTargetAnchor().getRelatedWidget();
            bounds = related.convertLocalToScene(related.getBounds());
            bounds.grow(10, 10);
        }
        if (bounds == null) {
            bounds = super.calculateClientArea();
        }
        return bounds;
    }

    protected void paintWidget() {
        List contrPoints = this.getControlPoints();
        int listSize = contrPoints.size();
        Graphics2D gr = this.getGraphics();
        if (listSize <= 2) {
            this.bezierPoints = null;
            if (this.isReflexive()) {
                this.drawReflexive(gr);
            } else {
                super.paintWidget();
            }
            return;
        }
        GeneralPath curvePath = new GeneralPath();
        double lastControlPointRotation = 0.0;
        Point2D[] bezPoints = this.createBezierPoints(contrPoints);
        curvePath.moveTo(bezPoints[0].getX(), bezPoints[0].getY());
        for (int i = 1; i < bezPoints.length - 5; i += 3) {
            curvePath.curveTo(bezPoints[i].getX(), bezPoints[i].getY(), bezPoints[i + 1].getX(), bezPoints[i + 1].getY(), bezPoints[i + 2].getX(), bezPoints[i + 2].getY());
        }
        GeneralPath lastseg = this.subdivide2D(bezPoints[bezPoints.length - 4], bezPoints[bezPoints.length - 3], bezPoints[bezPoints.length - 2], bezPoints[bezPoints.length - 1]);
        if (lastseg != null) {
            curvePath.append(lastseg, true);
        }
        Point2D cur = curvePath.getCurrentPoint();
        Point lastControlPoint = (Point)contrPoints.get(listSize - 1);
        lastControlPointRotation = Math.atan2(cur.getY() - (double)lastControlPoint.y, cur.getX() - (double)lastControlPoint.x);
        gr.setStroke(this.getStroke());
        gr.setColor(this.getLineColor());
        gr.draw(curvePath);
        AffineTransform previousTransform = gr.getTransform();
        gr.translate(lastControlPoint.x, lastControlPoint.y);
        gr.rotate(lastControlPointRotation);
        AnchorShape targetAnchorShape = this.getTargetAnchorShape();
        targetAnchorShape.paint(gr, false);
        gr.setTransform(previousTransform);
        if (this.isPaintControlPoints()) {
            int last = listSize - 1;
            for (int index = 0; index <= last; ++index) {
                Point point = (Point)contrPoints.get(index);
                previousTransform = gr.getTransform();
                gr.translate(point.x, point.y);
                if (index == 0 || index == last) {
                    this.getEndPointShape().paint(gr);
                } else {
                    this.getControlPointShape().paint(gr);
                }
                gr.setTransform(previousTransform);
            }
        }
    }

    private void drawReflexive(Graphics2D gr) {
        Widget related = this.getTargetAnchor().getRelatedWidget();
        int position = this.edgeBalance(related);
        Rectangle bounds = related.convertLocalToScene(related.getBounds());
        gr.setColor(this.getLineColor());
        Point first = new Point();
        Point last = new Point();
        double centerX = bounds.getCenterX();
        first.x = (int)(centerX + (double)(bounds.width / 4));
        first.y = bounds.y + bounds.height;
        last.x = first.x;
        last.y = bounds.y;
        gr.setStroke(this.getStroke());
        double cutDistance = this.getTargetAnchorShape().getCutDistance();
        double anchorAngle = -1.0471975511965976;
        double cutX = Math.abs(Math.cos(anchorAngle) * cutDistance);
        double cutY = Math.abs(Math.sin(anchorAngle) * cutDistance);
        int ydiff = first.y - last.y;
        int endy = -ydiff;
        double height = bounds.getHeight();
        double cy = height / 4.0;
        double cx = bounds.getWidth() / 5.0;
        double dcx = cx * 2.0;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0f, 0.0f);
        gp.quadTo(0.0, cy, cx, cy);
        gp.quadTo(dcx, cy, dcx, -height / 2.0);
        gp.quadTo(dcx, (double)endy - cy, cy, -(cy + (double)ydiff));
        gp.quadTo(cutX * 1.5, (double)endy - cy, cutX, (double)endy - cutY);
        AffineTransform af = new AffineTransform();
        AnchorShape anchorShape = this.getTargetAnchorShape();
        if (position < 0) {
            first.x = (int)(centerX - (double)(bounds.width / 4));
            af.translate(first.x, first.y);
            af.scale(-1.0, 1.0);
            last.x = first.x;
        } else {
            af.translate(first.x, first.y);
        }
        Shape s = gp.createTransformedShape(af);
        gr.draw(s);
        if (last != null) {
            AffineTransform previousTransform = gr.getTransform();
            gr.translate(last.x, last.y);
            if (position < 0) {
                gr.rotate(Math.PI - anchorAngle);
            } else {
                gr.rotate(anchorAngle);
            }
            anchorShape.paint(gr, false);
            gr.setTransform(previousTransform);
        }
    }

    private int edgeBalance(Widget nodeWidget) {
        if (this.scene == null) {
            return 1;
        }
        Point nodeLocation = nodeWidget.getLocation();
        int left = 0;
        int right = 0;
        Object node = this.scene.findObject(nodeWidget);
        for (Object e : this.scene.findNodeEdges(node, true, true)) {
            Point location;
            ConnectionWidget cw = (ConnectionWidget)this.scene.findWidget(e);
            if (cw == this) continue;
            Widget targetNodeWidget = cw.getTargetAnchor().getRelatedWidget();
            if (targetNodeWidget == nodeWidget) {
                Widget sourceNodeWidget = cw.getSourceAnchor().getRelatedWidget();
                location = sourceNodeWidget.getLocation();
            } else {
                location = targetNodeWidget.getLocation();
            }
            if (location.x < nodeLocation.x) {
                ++left;
                continue;
            }
            ++right;
        }
        if (left < right) {
            return -1;
        }
        return 1;
    }

    private Point2D[] createBezierPoints(List<Point> list) {
        int i;
        if (list.size() < 3) {
            return null;
        }
        int lastIdx = list.size() - 1;
        double[] uis = new double[list.size()];
        uis[0] = 0.0;
        uis[1] = list.get(1).distance(list.get(0));
        for (i = 1; i < uis.length; ++i) {
            Point cur = list.get(i);
            Point prev = list.get(i - 1);
            uis[i] = uis[i - 1] + cur.distance(prev);
        }
        i = 1;
        while (i < uis.length) {
            int n = i++;
            uis[n] = uis[n] / uis[lastIdx];
        }
        double[] delta = new double[uis.length - 1];
        for (int i2 = 0; i2 < delta.length; ++i2) {
            double ui = uis[i2];
            double uin = uis[i2 + 1];
            delta[i2] = uin - ui;
        }
        Point2D[] tangents = new Point2D[list.size()];
        for (int i3 = 1; i3 < list.size() - 1; ++i3) {
            Point xBefore = list.get(i3 - 1);
            Point xAfter = list.get(i3 + 1);
            Point2D.Double tangent = new Point2D.Double(xAfter.x - xBefore.x, xAfter.y - xBefore.y);
            tangents[i3] = tangent;
        }
        Point2D[] bezPoints = new Point2D[(list.size() - 1) * 2 + list.size()];
        for (int i4 = 1; i4 < list.size() - 1; ++i4) {
            Point b3i = list.get(i4);
            Point2D b3ib = SplineConnectionWidget.b3iBefore(b3i, delta[i4 - 1], delta[i4], tangents[i4]);
            Point2D b3ia = SplineConnectionWidget.b3iAfter(b3i, delta[i4 - 1], delta[i4], tangents[i4]);
            bezPoints[3 * i4] = b3i;
            bezPoints[3 * i4 - 1] = b3ib;
            bezPoints[3 * i4 + 1] = b3ia;
        }
        bezPoints[0] = list.get(0);
        bezPoints[bezPoints.length - 1] = list.get(list.size() - 1);
        Point p0 = list.get(0);
        Point p1 = list.get(1);
        Point p2 = list.get(2);
        Point pL_2 = list.get(lastIdx - 2);
        Point pL_1 = list.get(lastIdx - 1);
        Point pL = list.get(lastIdx);
        Point2D m1 = SplineConnectionWidget.besselTangent(delta[0], delta[1], p0, p1, p2);
        Point2D m0 = SplineConnectionWidget.besselEndTangent(p0, p1, delta[0], m1);
        Point2D mLb = SplineConnectionWidget.besselTangent(delta[delta.length - 2], delta[delta.length - 1], pL_2, pL_1, pL);
        Point2D mL = SplineConnectionWidget.besselEndTangent(pL_1, pL, delta[delta.length - 1], mLb);
        Point2D scaleM0 = SplineConnectionWidget.scale(SplineConnectionWidget.normalize(m0), p0.distance(p1));
        Point2D scaleML = SplineConnectionWidget.scale(SplineConnectionWidget.normalize(mL), pL.distance(pL_1));
        Point2D b30a = SplineConnectionWidget.b3iAfter(p0, delta[0], delta[0], scaleM0);
        Point2D b33b = SplineConnectionWidget.b3iBefore(pL, delta[delta.length - 1], delta[delta.length - 1], scaleML);
        bezPoints[1] = b30a;
        bezPoints[bezPoints.length - 2] = b33b;
        return bezPoints;
    }

    private static Point2D besselTangent(double delta_ib, double delta_i, Point2D p0, Point2D p1, Point2D p2) {
        double alpha_i = delta_ib / (delta_ib + delta_i);
        double x = (1.0 - alpha_i) / delta_ib * (p1.getX() - p0.getX()) + alpha_i / delta_i * (p2.getX() - p1.getX());
        double y = (1.0 - alpha_i) / delta_ib * (p1.getY() - p0.getY()) + alpha_i / delta_i * (p2.getY() - p1.getY());
        return new Point2D.Double(x, y);
    }

    private static Point2D besselEndTangent(Point2D p0, Point2D p1, double delta_u, Point2D m) {
        double x = 2.0 * ((p1.getX() - p0.getX()) / delta_u) - m.getX();
        double y = 2.0 * ((p1.getY() - p0.getY()) / delta_u) - m.getY();
        return new Point2D.Double(x, y);
    }

    private static Point2D b3iBefore(Point2D b3i, double delta_ib, double delta_i, Point2D li) {
        double x = b3i.getX() - delta_ib / (3.0 * (delta_ib + delta_i)) * li.getX();
        double y = b3i.getY() - delta_ib / (3.0 * (delta_ib + delta_i)) * li.getY();
        return new Point2D.Double(x, y);
    }

    private static Point2D b3iAfter(Point2D b3i, double delta_ib, double delta_i, Point2D li) {
        double x = b3i.getX() + delta_i / (3.0 * (delta_ib + delta_i)) * li.getX();
        double y = b3i.getY() + delta_i / (3.0 * (delta_ib + delta_i)) * li.getY();
        return new Point2D.Double(x, y);
    }

    private static double norm(Point2D v) {
        return Math.sqrt(v.getX() * v.getX() + v.getY() * v.getY());
    }

    private static Point2D normalize(Point2D v) {
        double norm = SplineConnectionWidget.norm(v);
        if (norm == 0.0) {
            return new Point2D.Double(v.getX(), v.getY());
        }
        return new Point2D.Double(v.getX() / norm, v.getY() / norm);
    }

    private static Point2D scale(Point2D v, double length) {
        Point2D tmp = SplineConnectionWidget.normalize(v);
        return new Point2D.Double(tmp.getX() * length, tmp.getY() * length);
    }

    private GeneralPath subdivide2D(Point2D b0, Point2D b1, Point2D b2, Point2D b3) {
        double minDistance;
        double cutDistance = this.getTargetAnchorShape().getCutDistance();
        if (cutDistance > (minDistance = cutDistance - 3.0) && minDistance > 0.0) {
            GeneralPath path = new GeneralPath();
            path.moveTo(b0.getX(), b0.getY());
            CubicCurve2D.Double curve = new CubicCurve2D.Double(b0.getX(), b0.getY(), b1.getX(), b1.getY(), b2.getX(), b2.getY(), b3.getX(), b3.getY());
            CubicCurve2D.Double right = new CubicCurve2D.Double();
            CubicCurve2D.Double left = new CubicCurve2D.Double();
            curve.subdivide(left, right);
            double distance = b3.distance(((CubicCurve2D)left).getP2());
            while (distance > cutDistance) {
                path.append(left, true);
                right.subdivide(left, right);
                distance = b3.distance(((CubicCurve2D)left).getP2());
                while (distance < minDistance) {
                    left.subdivide(left, right);
                    distance = b3.distance(((CubicCurve2D)left).getP2());
                }
            }
            path.append(left, true);
            return path;
        }
        return null;
    }

    public boolean isHitAt(Point localLocation) {
        if (!this.isVisible() || !this.getBounds().contains(localLocation)) {
            return false;
        }
        List controlPoints = this.getControlPoints();
        if (controlPoints.size() <= 2) {
            if (this.isReflexive()) {
                return true;
            }
            return super.isHitAt(localLocation);
        }
        if (this.bezierPoints != null) {
            for (int i = 0; i < this.bezierPoints.length - 1; i += 3) {
                Point2D b0 = this.bezierPoints[i];
                Point2D b1 = this.bezierPoints[i + 1];
                Point2D b2 = this.bezierPoints[i + 2];
                Point2D b3 = this.bezierPoints[i + 3];
                CubicCurve2D.Double left = new CubicCurve2D.Double(b0.getX(), b0.getY(), b1.getX(), b1.getY(), b2.getX(), b2.getY(), b3.getX(), b3.getY());
                Rectangle2D bounds = left.getBounds2D();
                while (bounds.contains(localLocation)) {
                    Point2D.Double test = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                    if (test.distance(localLocation) < 4.0) {
                        return true;
                    }
                    CubicCurve2D.Double right = new CubicCurve2D.Double();
                    left.subdivide(left, right);
                    Rectangle2D lb2d = left.getBounds2D();
                    Rectangle2D rb2d = right.getBounds2D();
                    if (lb2d.contains(localLocation)) {
                        bounds = lb2d;
                        continue;
                    }
                    if (rb2d.contains(localLocation)) {
                        left = right;
                        bounds = rb2d;
                        continue;
                    }
                    return false;
                }
            }
        }
        return false;
    }
}

