/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.modelimpl.bc;

import at.ssw.visualizer.model.bc.Bytecodes;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.modelimpl.cfg.BasicBlockImpl;
import java.util.Arrays;

public class BytecodesImpl
implements Bytecodes {
    private ControlFlowGraph controlFlowGraph;
    private String bytecodeString;
    private String[] bytecodes;
    private String epilogue;

    public BytecodesImpl(ControlFlowGraph controlFlowGraph, String bytecodeString) {
        this.controlFlowGraph = controlFlowGraph;
        this.bytecodeString = bytecodeString;
    }

    @Override
    public void parseBytecodes() {
        int lnr;
        String[] lines = this.bytecodeString.split("\n");
        boolean inPrologue = true;
        String[] result = new String[lines.length * 3];
        int lastBci = -1;
        for (lnr = 0; lnr < lines.length; ++lnr) {
            int bci;
            int space1;
            int end;
            String line = lines[lnr];
            if ((line = line.trim()).startsWith("[") && (end = line.indexOf(93)) != -1) {
                line = line.substring(end + 1, line.length());
            }
            if ((space1 = (line = line.trim()).indexOf(32)) <= 0) {
                if (!inPrologue) break;
                continue;
            }
            Object bciStr = line.substring(0, space1);
            if (((String)bciStr).endsWith(":")) {
                bciStr = ((String)bciStr).substring(0, ((String)bciStr).length() - 1);
            }
            try {
                bci = Integer.parseInt((String)bciStr);
            }
            catch (NumberFormatException ex) {
                if (!inPrologue) break;
                continue;
            }
            String opcode = line.substring(space1 + 1);
            String params = "";
            int space2 = opcode.indexOf(32);
            if (space2 > 0) {
                params = opcode.substring(space2 + 1).trim();
                opcode = opcode.substring(0, space2);
            }
            String tail = "";
            int space3 = params.indexOf(124);
            if (space3 >= 0) {
                tail = params.substring(space3);
                params = params.substring(0, space3);
            }
            String printLine = (String)bciStr + ":" + "    ".substring(Math.min(((String)bciStr).length(), 3)) + opcode + "              ".substring(Math.min(opcode.length(), 13)) + params + "        ".substring(Math.min(params.length(), 8)) + tail;
            if (bci >= result.length) {
                result = Arrays.copyOf(result, Math.max(bci + 1, result.length * 2));
            }
            result[bci] = printLine;
            inPrologue = false;
            lastBci = Math.max(lastBci, bci);
        }
        StringBuilder epilogueBuilder = new StringBuilder();
        while (lnr < lines.length) {
            epilogueBuilder.append(lines[lnr]).append("\n");
            ++lnr;
        }
        this.epilogue = epilogueBuilder.toString();
        this.bytecodes = Arrays.copyOf(result, lastBci + 1);
        BasicBlockImpl[] blocks = new BasicBlockImpl[this.bytecodes.length];
        for (BasicBlock b : this.controlFlowGraph.getBasicBlocks()) {
            if (!(b instanceof BasicBlockImpl)) continue;
            BasicBlockImpl block = (BasicBlockImpl)b;
            if (block.getToBci() != -1) {
                return;
            }
            if (block.getFromBci() < 0 || block.getFromBci() >= blocks.length) continue;
            blocks[block.getFromBci()] = block;
        }
        int curToBci = -1;
        for (int i = blocks.length - 1; i >= 0; --i) {
            if (this.bytecodes[i] != null && curToBci == -1) {
                curToBci = i;
            }
            if (blocks[i] == null) continue;
            blocks[i].setToBci(curToBci);
            curToBci = -1;
        }
    }

    @Override
    public ControlFlowGraph getControlFlowGraph() {
        return this.controlFlowGraph;
    }

    @Override
    public String getBytecodes(int fromBCI, int toBCI) {
        if (fromBCI < 0) {
            return "";
        }
        toBCI = Math.min(toBCI, this.bytecodes.length);
        StringBuilder sb = new StringBuilder();
        for (int i = fromBCI; i < toBCI; ++i) {
            if (this.bytecodes[i] == null) continue;
            sb.append(this.bytecodes[i]).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getEpilogue() {
        return this.epilogue;
    }

    public String toString() {
        return "Bytecodes " + this.getControlFlowGraph().getName();
    }
}

