/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.parser;

import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.IRInstruction;
import at.ssw.visualizer.model.cfg.State;
import at.ssw.visualizer.modelimpl.cfg.BasicBlockImpl;
import at.ssw.visualizer.modelimpl.cfg.ControlFlowGraphImpl;
import at.ssw.visualizer.parser.BBHelper;
import at.ssw.visualizer.parser.CompilationHelper;
import at.ssw.visualizer.parser.Parser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CFGHelper {
    protected String shortName;
    protected String name;
    protected int id;
    protected int parentId;
    private Map<String, BBHelper> helpers = new HashMap<String, BBHelper>();
    private List<BBHelper> helpersList = new ArrayList<BBHelper>();
    protected List<ControlFlowGraphImpl> elements = new ArrayList<ControlFlowGraphImpl>();
    protected ControlFlowGraphImpl resolved;

    public void add(BBHelper helper) {
        this.helpers.put(helper.name, helper);
        this.helpersList.add(helper);
    }

    public ControlFlowGraphImpl resolve(CompilationHelper lastComp, Parser parser) {
        for (BBHelper helper : this.helpersList) {
            for (String predecessorName : helper.predecessors) {
                BBHelper predecessor = this.helpers.get(predecessorName);
                if (predecessor == null) continue;
                helper.defPredecessorsList.add(predecessor.basicBlock);
            }
            for (String successorName : helper.successors) {
                BBHelper successor = this.helpers.get(successorName);
                if (successor == null) continue;
                helper.successorsList.add(successor.basicBlock);
                successor.calcPredecessorsList.add(helper.basicBlock);
            }
            for (String xhandlerName : helper.xhandlers) {
                BBHelper xhandler = this.helpers.get(xhandlerName);
                if (xhandler == null) continue;
                helper.xhandlersList.add(xhandler.basicBlock);
                xhandler.calcPredecessorsList.add(helper.basicBlock);
            }
        }
        BasicBlockImpl[] basicBlocks = new BasicBlockImpl[this.helpersList.size()];
        int idx = 0;
        for (BBHelper helper : this.helpersList) {
            List<BasicBlock> predecessorsList;
            basicBlocks[idx++] = helper.basicBlock;
            if (helper.defPredecessorsList.size() > 0) {
                if (helper.defPredecessorsList.size() != helper.calcPredecessorsList.size()) {
                    parser.SemErr("Defined and calculated predecessors size different: " + helper.name);
                } else {
                    for (BasicBlock block : helper.defPredecessorsList) {
                        if (helper.calcPredecessorsList.remove(block)) continue;
                        parser.SemErr("Defined and calculated predecessors not matching: " + helper.name);
                    }
                    if (helper.calcPredecessorsList.size() > 0) {
                        parser.SemErr("Defined and calculated predecessors not matching: " + helper.name);
                    }
                }
                predecessorsList = helper.defPredecessorsList;
            } else {
                predecessorsList = helper.calcPredecessorsList;
            }
            BasicBlock[] predecessors = predecessorsList.toArray(new BasicBlock[predecessorsList.size()]);
            BasicBlock[] successors = helper.successorsList.toArray(new BasicBlock[helper.successorsList.size()]);
            BasicBlock[] xhandlers = helper.xhandlersList.toArray(new BasicBlock[helper.xhandlersList.size()]);
            BasicBlockImpl dominator = null;
            if (this.helpers.get(helper.dominator) != null) {
                dominator = this.helpers.get((Object)helper.dominator).basicBlock;
            }
            State[] states = null;
            if (helper.states.size() > 0) {
                states = helper.states.toArray(new State[helper.states.size()]);
            }
            IRInstruction[] hirInstructions = null;
            if (helper.hirInstructions.size() > 0) {
                hirInstructions = helper.hirInstructions.toArray(new IRInstruction[helper.hirInstructions.size()]);
            }
            IRInstruction[] lirOperations = null;
            if (helper.lirOperations.size() > 0) {
                lirOperations = helper.lirOperations.toArray(new IRInstruction[helper.lirOperations.size()]);
                if (helper.firstLirId == 0) {
                    try {
                        helper.firstLirId = Integer.parseInt(lirOperations[0].getValue("nr"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (helper.lastLirId == 0) {
                    try {
                        helper.lastLirId = Integer.parseInt(lirOperations[lirOperations.length - 1].getValue("nr"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            helper.basicBlock.setValues(helper.name, helper.fromBci, helper.toBci, predecessors, successors, xhandlers, helper.flags, dominator, helper.loopIndex, helper.loopDepth, helper.firstLirId, helper.lastLirId, helper.probability, states, hirInstructions, lirOperations);
        }
        this.resolved = new ControlFlowGraphImpl(this.shortName, this.name, basicBlocks);
        if (this.parentId == 0) {
            lastComp.elements.add(this.resolved);
        } else {
            CFGHelper parent = lastComp.idToCFG.get(this.parentId);
            if (parent != null) {
                parent.elements.add(this.resolved);
            } else {
                parser.SemErr("Undefined compilation id: " + this.parentId);
            }
        }
        if (this.id != 0) {
            lastComp.idToCFG.put(this.id, this);
        }
        return this.resolved;
    }
}

