/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.parser;

import java.util.ArrayList;

class Errors {
    public String errMsgFormat = "-- line {0} col {1}: {2}";
    public ArrayList<String> errors = new ArrayList();

    Errors() {
    }

    protected void printMsg(int line, int column, String msg) {
        StringBuffer b = new StringBuffer(this.errMsgFormat);
        int pos = b.indexOf("{0}");
        if (pos >= 0) {
            b.delete(pos, pos + 3);
            b.insert(pos, line);
        }
        if ((pos = b.indexOf("{1}")) >= 0) {
            b.delete(pos, pos + 3);
            b.insert(pos, column);
        }
        if ((pos = b.indexOf("{2}")) >= 0) {
            b.replace(pos, pos + 3, msg);
        }
        this.printMsg(b.toString());
    }

    protected void printMsg(String msg) {
        if (this.errors.size() < 10) {
            this.errors.add(msg);
        }
    }

    public void SynErr(int line, int col, int n) {
        String s;
        switch (n) {
            case 0: {
                s = "EOF expected";
                break;
            }
            case 1: {
                s = "ident expected";
                break;
            }
            case 2: {
                s = "\"begin_compilation\" expected";
                break;
            }
            case 3: {
                s = "\"name\" expected";
                break;
            }
            case 4: {
                s = "\"method\" expected";
                break;
            }
            case 5: {
                s = "\"date\" expected";
                break;
            }
            case 6: {
                s = "\"end_compilation\" expected";
                break;
            }
            case 7: {
                s = "\"begin_cfg\" expected";
                break;
            }
            case 8: {
                s = "\"id\" expected";
                break;
            }
            case 9: {
                s = "\"caller_id\" expected";
                break;
            }
            case 10: {
                s = "\"end_cfg\" expected";
                break;
            }
            case 11: {
                s = "\"begin_block\" expected";
                break;
            }
            case 12: {
                s = "\"from_bci\" expected";
                break;
            }
            case 13: {
                s = "\"to_bci\" expected";
                break;
            }
            case 14: {
                s = "\"predecessors\" expected";
                break;
            }
            case 15: {
                s = "\"successors\" expected";
                break;
            }
            case 16: {
                s = "\"xhandlers\" expected";
                break;
            }
            case 17: {
                s = "\"flags\" expected";
                break;
            }
            case 18: {
                s = "\"dominator\" expected";
                break;
            }
            case 19: {
                s = "\"loop_index\" expected";
                break;
            }
            case 20: {
                s = "\"loop_depth\" expected";
                break;
            }
            case 21: {
                s = "\"first_lir_id\" expected";
                break;
            }
            case 22: {
                s = "\"last_lir_id\" expected";
                break;
            }
            case 23: {
                s = "\"probability\" expected";
                break;
            }
            case 24: {
                s = "\"end_block\" expected";
                break;
            }
            case 25: {
                s = "\"begin_states\" expected";
                break;
            }
            case 26: {
                s = "\"begin_stack\" expected";
                break;
            }
            case 27: {
                s = "\"end_stack\" expected";
                break;
            }
            case 28: {
                s = "\"begin_locks\" expected";
                break;
            }
            case 29: {
                s = "\"end_locks\" expected";
                break;
            }
            case 30: {
                s = "\"begin_locals\" expected";
                break;
            }
            case 31: {
                s = "\"end_locals\" expected";
                break;
            }
            case 32: {
                s = "\"end_states\" expected";
                break;
            }
            case 33: {
                s = "\"size\" expected";
                break;
            }
            case 34: {
                s = "\"[\" expected";
                break;
            }
            case 35: {
                s = "\"]\" expected";
                break;
            }
            case 36: {
                s = "\"begin_HIR\" expected";
                break;
            }
            case 37: {
                s = "\"end_HIR\" expected";
                break;
            }
            case 38: {
                s = "\".\" expected";
                break;
            }
            case 39: {
                s = "\"begin_LIR\" expected";
                break;
            }
            case 40: {
                s = "\"end_LIR\" expected";
                break;
            }
            case 41: {
                s = "\"begin_IR\" expected";
                break;
            }
            case 42: {
                s = "\"HIR\" expected";
                break;
            }
            case 43: {
                s = "\"LIR\" expected";
                break;
            }
            case 44: {
                s = "\"end_IR\" expected";
                break;
            }
            case 45: {
                s = "\"<|@\" expected";
                break;
            }
            case 46: {
                s = "\"begin_intervals\" expected";
                break;
            }
            case 47: {
                s = "\"end_intervals\" expected";
                break;
            }
            case 48: {
                s = "\",\" expected";
                break;
            }
            case 49: {
                s = "\"begin_nmethod\" expected";
                break;
            }
            case 50: {
                s = "\"end_nmethod\" expected";
                break;
            }
            case 51: {
                s = "\"begin_bytecodes\" expected";
                break;
            }
            case 52: {
                s = "\"end_bytecodes\" expected";
                break;
            }
            case 53: {
                s = "\"\\\"\" expected";
                break;
            }
            case 54: {
                s = "??? expected";
                break;
            }
            case 55: {
                s = "invalid IR";
                break;
            }
            default: {
                s = "error " + n;
            }
        }
        this.printMsg(line, col, s);
    }

    public void SemErr(int line, int col, String s) {
        this.printMsg(line, col, s);
    }

    public void SemErr(String s) {
        this.printMsg(s);
    }

    public void Warning(int line, int col, String s) {
        this.printMsg(line, col, s);
    }

    public void Warning(String s) {
        this.printMsg(s);
    }
}

