/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.parser;

import at.ssw.visualizer.parser.Buffer;
import at.ssw.visualizer.parser.FatalError;
import at.ssw.visualizer.parser.StartStates;
import at.ssw.visualizer.parser.Token;
import at.ssw.visualizer.parser.UTF8Buffer;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;

public class Scanner {
    static final char EOL = '\n';
    static final int eofSym = 0;
    static final int maxT = 54;
    static final int noSym = 54;
    public Buffer buffer;
    Token t;
    int ch;
    long pos;
    long charPos;
    int col;
    int line;
    int oldEols;
    static final StartStates start;
    static final Map<String, Integer> literals;
    static int maxLiteral;
    static boolean[] literalFirstChar;
    Token tokens;
    Token pt;
    char[] tval = new char[16];
    int tlen;

    public Scanner(String fileName, ProgressHandle progressHandle) {
        this.buffer = new Buffer(fileName, progressHandle);
        this.Init();
    }

    public Scanner(InputStream s) {
        this.buffer = new Buffer(s);
        this.Init();
    }

    void Init() {
        this.pos = -1L;
        this.line = 1;
        this.col = 0;
        this.charPos = -1L;
        this.oldEols = 0;
        this.NextCh();
        if (this.ch == 239) {
            this.NextCh();
            int ch1 = this.ch;
            this.NextCh();
            int ch2 = this.ch;
            if (ch1 != 187 || ch2 != 191) {
                throw new FatalError("Illegal byte order mark at start of file");
            }
            this.buffer = new UTF8Buffer(this.buffer);
            this.col = 0;
            this.charPos = -1L;
            this.NextCh();
        }
        this.pt = this.tokens = new Token();
    }

    void NextCh() {
        if (this.oldEols > 0) {
            this.ch = 10;
            --this.oldEols;
        } else {
            this.pos = this.buffer.getPos();
            this.ch = this.buffer.Read();
            ++this.col;
            ++this.charPos;
            if (this.ch == 13 && this.buffer.Peek() != 10) {
                this.ch = 10;
            }
            if (this.ch == 10) {
                ++this.line;
                this.col = 0;
            }
        }
    }

    void AddCh() {
        if (this.tlen >= this.tval.length) {
            char[] newBuf = new char[2 * this.tval.length];
            System.arraycopy(this.tval, 0, newBuf, 0, this.tval.length);
            this.tval = newBuf;
        }
        if (this.ch != 65536) {
            this.tval[this.tlen++] = (char)this.ch;
            this.NextCh();
        }
    }

    void CheckLiteral() {
        String val = this.t.val;
        Integer kind = literals.get(val);
        if (kind != null) {
            this.t.kind = kind;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    Token NextToken() {
        while (this.ch == 32 || this.ch == 10 || this.ch == 13) {
            this.NextCh();
        }
        int recKind = 54;
        long recEnd = this.pos;
        this.t = new Token();
        this.t.pos = this.pos;
        this.t.col = this.col;
        this.t.line = this.line;
        this.t.charPos = this.charPos;
        int state = start.state(this.ch);
        this.tlen = 0;
        this.AddCh();
        block14: while (true) {
            switch (state) {
                case -1: {
                    this.t.kind = 0;
                    break block14;
                }
                case 0: {
                    if (recKind != 54) {
                        this.tlen = Math.toIntExact(recEnd - this.t.pos);
                        this.SetScannerBehindT();
                    }
                    this.t.kind = recKind;
                    break block14;
                }
                case 1: {
                    recEnd = this.pos;
                    recKind = 1;
                    if (!(this.ch == 42 || this.ch == 45 || this.ch >= 48 && this.ch <= 58 || this.ch >= 65 && this.ch <= 90 || this.ch == 95 || this.ch >= 97 && this.ch <= 122 || this.ch == 124)) {
                        this.t.kind = 1;
                        this.t.val = new String(this.tval, 0, this.tlen);
                        this.CheckLiteral();
                        return this.t;
                    }
                    this.AddCh();
                    state = 1;
                    break;
                }
                case 2: {
                    this.t.kind = 34;
                    break block14;
                }
                case 3: {
                    this.t.kind = 35;
                    break block14;
                }
                case 4: {
                    this.t.kind = 38;
                    break block14;
                }
                case 5: {
                    if (this.ch == 124) {
                        this.AddCh();
                        state = 6;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 6: {
                    if (this.ch == 64) {
                        this.AddCh();
                        state = 7;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 7: {
                    this.t.kind = 45;
                    break block14;
                }
                case 8: {
                    this.t.kind = 48;
                    break block14;
                }
                case 9: {
                    this.t.kind = 53;
                    break block14;
                }
            }
        }
        this.t.val = new String(this.tval, 0, this.tlen);
        return this.t;
    }

    private void SetScannerBehindT() {
        this.buffer.setPos(this.t.pos);
        this.NextCh();
        this.line = this.t.line;
        this.col = this.t.col;
        this.charPos = this.t.charPos;
        for (int i = 0; i < this.tlen; ++i) {
            this.NextCh();
        }
    }

    public Token Scan() {
        if (this.tokens.next == null) {
            return this.NextToken();
        }
        this.pt = this.tokens = this.tokens.next;
        return this.tokens;
    }

    public Token Peek() {
        do {
            if (this.pt.next == null) {
                this.pt.next = this.NextToken();
            }
            this.pt = this.pt.next;
        } while (this.pt.kind > 54);
        return this.pt;
    }

    public void ResetPeek() {
        this.pt = this.tokens;
    }

    static {
        int i;
        start = new StartStates();
        literals = new HashMap<String, Integer>();
        for (i = 42; i <= 42; ++i) {
            start.set(i, 1);
        }
        for (i = 45; i <= 45; ++i) {
            start.set(i, 1);
        }
        for (i = 48; i <= 58; ++i) {
            start.set(i, 1);
        }
        for (i = 65; i <= 90; ++i) {
            start.set(i, 1);
        }
        for (i = 95; i <= 95; ++i) {
            start.set(i, 1);
        }
        for (i = 97; i <= 122; ++i) {
            start.set(i, 1);
        }
        for (i = 124; i <= 124; ++i) {
            start.set(i, 1);
        }
        start.set(91, 2);
        start.set(93, 3);
        start.set(46, 4);
        start.set(60, 5);
        start.set(44, 8);
        start.set(34, 9);
        start.set(65536, -1);
        literals.put("begin_compilation", 2);
        literals.put("name", 3);
        literals.put("method", 4);
        literals.put("date", 5);
        literals.put("end_compilation", 6);
        literals.put("begin_cfg", 7);
        literals.put("id", 8);
        literals.put("caller_id", 9);
        literals.put("end_cfg", 10);
        literals.put("begin_block", 11);
        literals.put("from_bci", 12);
        literals.put("to_bci", 13);
        literals.put("predecessors", 14);
        literals.put("successors", 15);
        literals.put("xhandlers", 16);
        literals.put("flags", 17);
        literals.put("dominator", 18);
        literals.put("loop_index", 19);
        literals.put("loop_depth", 20);
        literals.put("first_lir_id", 21);
        literals.put("last_lir_id", 22);
        literals.put("probability", 23);
        literals.put("end_block", 24);
        literals.put("begin_states", 25);
        literals.put("begin_stack", 26);
        literals.put("end_stack", 27);
        literals.put("begin_locks", 28);
        literals.put("end_locks", 29);
        literals.put("begin_locals", 30);
        literals.put("end_locals", 31);
        literals.put("end_states", 32);
        literals.put("size", 33);
        literals.put("begin_HIR", 36);
        literals.put("end_HIR", 37);
        literals.put("begin_LIR", 39);
        literals.put("end_LIR", 40);
        literals.put("begin_IR", 41);
        literals.put("HIR", 42);
        literals.put("LIR", 43);
        literals.put("end_IR", 44);
        literals.put("begin_intervals", 46);
        literals.put("end_intervals", 47);
        literals.put("begin_nmethod", 49);
        literals.put("end_nmethod", 50);
        literals.put("begin_bytecodes", 51);
        literals.put("end_bytecodes", 52);
        literalFirstChar = new boolean[0];
        for (String literal : literals.keySet()) {
            maxLiteral = Math.max(literal.length(), maxLiteral);
            char c = literal.charAt(0);
            if (c >= literalFirstChar.length) {
                literalFirstChar = Arrays.copyOf(literalFirstChar, c + '\u0001');
            }
            Scanner.literalFirstChar[c] = true;
        }
        maxLiteral = 0;
        literalFirstChar = null;
    }
}

