/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.compilation.view;

import at.ssw.visualizer.model.Compilation;
import at.ssw.visualizer.model.CompilationElement;
import at.ssw.visualizer.model.CompilationModel;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

public class CompilationModelNode
extends AbstractNode {
    protected Image ImageFolder = ImageUtilities.loadImage((String)"at/ssw/visualizer/compilation/view/icons/folder.gif");
    protected Image ImageCfg = ImageUtilities.loadImage((String)"at/ssw/visualizer/compilation/view/icons/cfg.gif");
    protected Image ImageIntervals = ImageUtilities.loadImage((String)"at/ssw/visualizer/compilation/view/icons/intervals.gif");
    protected boolean sortCompilations;
    protected boolean filterCfg;
    protected boolean shortNames;

    public CompilationModelNode(CompilationModel model) {
        super(Children.LEAF);
        this.setChildren((Children)new CompilationModelChildren(model));
    }

    public void doRefresh(boolean sortCompilations, boolean filterCfg, boolean shortNames) {
        this.sortCompilations = sortCompilations;
        this.filterCfg = filterCfg;
        this.shortNames = shortNames;
        ((CompilationModelChildren)this.getChildren()).doRefresh();
    }

    public Action[] getActions(boolean context) {
        return new Action[0];
    }

    class CompilationModelChildren
    extends Children.Keys<Compilation> {
        private CompilationModel model;
        private ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                CompilationModelChildren.this.addNotify();
            }
        };

        public CompilationModelChildren(CompilationModel model) {
            this.model = model;
            model.addChangedListener(this.changeListener);
        }

        public void doRefresh() {
            this.addNotify();
            for (Node n : this.getNodes()) {
                ((CompilationNode)n).doRefresh();
            }
        }

        protected void addNotify() {
            Object[] compilations = this.model.getCompilations().toArray(new Compilation[0]);
            if (CompilationModelNode.this.sortCompilations) {
                Arrays.sort(compilations, new Comparator<Compilation>(){

                    @Override
                    public int compare(Compilation o1, Compilation o2) {
                        if (CompilationModelNode.this.shortNames) {
                            return o1.getShortName().compareToIgnoreCase(o2.getShortName());
                        }
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
            }
            this.setKeys(compilations);
        }

        protected Node[] createNodes(Compilation key) {
            return new Node[]{new CompilationNode(key)};
        }
    }

    class CompilationElementChildren
    extends Children.Keys<CompilationElement> {
        private CompilationElement compilation;

        public CompilationElementChildren(CompilationElement compilation) {
            this.compilation = compilation;
        }

        public void doRefresh() {
            this.addNotify();
            for (Node n : this.getNodes()) {
                ((CompilationElementNode)n).doRefresh();
            }
        }

        protected void addNotify() {
            ArrayList<CompilationElement> elements = new ArrayList<CompilationElement>();
            for (CompilationElement element : this.compilation.getElements()) {
                if (CompilationModelNode.this.filterCfg && element.getCompilation() == element.getParent() && element instanceof ControlFlowGraph && !((ControlFlowGraph)element).hasHir() && !((ControlFlowGraph)element).hasLir() && ((ControlFlowGraph)element).getNativeMethod() == null) continue;
                elements.add(element);
            }
            this.setKeys(elements);
        }

        protected Node[] createNodes(CompilationElement key) {
            return new Node[]{new CompilationElementNode(key)};
        }
    }

    class CompilationNode
    extends CompilationElementNode {
        public CompilationNode(Compilation compilation) {
            super((CompilationElement)compilation);
        }

        @Override
        public Image getIcon(int type) {
            return CompilationModelNode.this.ImageFolder;
        }

        @Override
        public Action[] getActions(boolean context) {
            return Lookups.forPath((String)"at-ssw-visualizer-actions-compilation").lookupAll(Action.class).toArray(new Action[0]);
        }

        @Override
        public Action getPreferredAction() {
            return null;
        }
    }

    class CompilationElementNode
    extends AbstractNode {
        private CompilationElement element;

        public CompilationElementNode(CompilationElement element) {
            super((Children)(element.getElements().size() > 0 ? new CompilationElementChildren(element) : Children.LEAF), Lookups.singleton((Object)element));
            this.element = element;
        }

        public void doRefresh() {
            this.fireNameChange(null, null);
            if (this.getChildren() instanceof CompilationElementChildren) {
                ((CompilationElementChildren)this.getChildren()).doRefresh();
            }
        }

        public String getName() {
            if (CompilationModelNode.this.shortNames) {
                return this.element.getShortName();
            }
            return this.element.getName();
        }

        public String getShortDescription() {
            return this.element.getName();
        }

        public Image getIcon(int type) {
            return this.element instanceof ControlFlowGraph ? CompilationModelNode.this.ImageCfg : CompilationModelNode.this.ImageIntervals;
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            String path = this.element instanceof ControlFlowGraph ? "at-ssw-visualizer-actions-cfg" : "at-ssw-visualizer-actions-intervals";
            return Lookups.forPath((String)path).lookupAll(Action.class).toArray(new Action[0]);
        }

        public Action getPreferredAction() {
            for (Action action : this.getActions(false)) {
                if (!action.isEnabled()) continue;
                return action;
            }
            return null;
        }
    }
}

