/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.texteditor.highlight;

import at.ssw.visualizer.texteditor.model.Scanner;
import at.ssw.visualizer.texteditor.model.Text;
import at.ssw.visualizer.texteditor.model.TextRegion;
import java.util.EventListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.TokenID;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public class HighlightsContainer
extends AbstractHighlightsContainer {
    private static final String HIGHLIGHT_COLORING = "at-ssw-visualizer-highlight";
    protected final JTextComponent component;
    protected final Document document;
    protected final AttributeSet highlightColoring;
    protected final Scanner scanner;
    protected TextRegion[] curRegions = null;
    private final CaretListener caretListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent event) {
            TextRegion[] newRegions = HighlightsContainer.this.findRegions();
            if (newRegions != HighlightsContainer.this.curRegions) {
                HighlightsContainer.this.curRegions = newRegions;
                HighlightsContainer.this.fireHighlightsChange(0, HighlightsContainer.this.document.getLength());
            }
        }
    };

    protected HighlightsContainer(JTextComponent component, Document document) {
        this.document = document;
        this.component = component;
        component.addCaretListener((CaretListener)WeakListeners.create(CaretListener.class, (EventListener)this.caretListener, (Object)component));
        Text t = (Text)document.getProperty(Text.class);
        MimePath mimePath = MimePath.parse((String)t.getMimeType());
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)mimePath).lookup(FontColorSettings.class);
        AttributeSet highlight = fcs.getFontColors(HIGHLIGHT_COLORING);
        this.highlightColoring = highlight != null ? highlight : SimpleAttributeSet.EMPTY;
        this.scanner = t.getScanner();
        this.scanner.setText(document);
        this.curRegions = this.findRegions();
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        return new RegionSequence();
    }

    protected TextRegion[] findRegions() {
        Text text = (Text)this.document.getProperty(Text.class);
        Caret caret = this.component.getCaret();
        if (text == null || caret == null) {
            return null;
        }
        this.scanner.findTokenBegin(caret.getDot());
        TokenID token = this.scanner.nextToken();
        if (token.getNumericID() < 0) {
            return null;
        }
        return text.getHighlighting(this.scanner.getTokenString());
    }

    protected class RegionSequence
    implements HighlightsSequence {
        private int idx = -1;

        protected RegionSequence() {
        }

        public boolean moveNext() {
            ++this.idx;
            return HighlightsContainer.this.curRegions != null && this.idx < HighlightsContainer.this.curRegions.length;
        }

        public int getStartOffset() {
            return HighlightsContainer.this.curRegions[this.idx].getStart();
        }

        public int getEndOffset() {
            return HighlightsContainer.this.curRegions[this.idx].getEnd();
        }

        public AttributeSet getAttributes() {
            return HighlightsContainer.this.highlightColoring;
        }
    }

    public static final class HighlightsLayerFactory
    implements org.netbeans.spi.editor.highlighting.HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            Text t = (Text)context.getDocument().getProperty(Text.class);
            if (t == null) {
                return new HighlightsLayer[0];
            }
            return new HighlightsLayer[]{HighlightsLayer.create((String)"at-ssw-visualizer-highlighting", (ZOrder)ZOrder.SHOW_OFF_RACK, (boolean)true, (org.netbeans.spi.editor.highlighting.HighlightsContainer)new HighlightsContainer(context.getComponent(), context.getDocument()))};
        }
    }
}

