/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.texteditor.view;

import at.ssw.visualizer.core.selection.Selection;
import at.ssw.visualizer.core.selection.SelectionManager;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.texteditor.EditorKit;
import java.awt.BorderLayout;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.windows.TopComponent;

public abstract class AbstractTextViewTopComponent
extends TopComponent {
    protected ControlFlowGraph curCFG;
    protected BasicBlock[] curBlocks;
    private JEditorPane editorPane;
    private ChangeListener selectionChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            AbstractTextViewTopComponent.this.updateContent();
        }
    };

    public AbstractTextViewTopComponent(EditorKit kit) {
        this.editorPane = new JEditorPane();
        this.editorPane.setEditorKit((javax.swing.text.EditorKit)((Object)kit));
        this.editorPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(this.editorPane);
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.add(scrollPane);
    }

    protected void componentShowing() {
        super.componentShowing();
        SelectionManager.getDefault().addChangeListener(this.selectionChangeListener);
        this.updateContent();
    }

    protected void componentHidden() {
        super.componentHidden();
        SelectionManager.getDefault().removeChangeListener(this.selectionChangeListener);
        this.curCFG = null;
        this.curBlocks = null;
    }

    protected void updateContent() {
        Selection selection = SelectionManager.getDefault().getCurSelection();
        ControlFlowGraph newCFG = (ControlFlowGraph)selection.get(ControlFlowGraph.class);
        Object[] newBlocks = (BasicBlock[])selection.get(BasicBlock[].class);
        if (newCFG == null || newBlocks == null || newBlocks.length == 0) {
            this.editorPane.setText("No block selected\n");
        } else if (this.curCFG != newCFG || !Arrays.equals(this.curBlocks, newBlocks)) {
            this.editorPane.setText(this.getContent(newCFG, (BasicBlock[])newBlocks));
        }
        this.curCFG = newCFG;
        this.curBlocks = newBlocks;
    }

    protected abstract String getContent(ControlFlowGraph var1, BasicBlock[] var2);
}

