/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.fx;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.scene.web.WebEngine;
import org.netbeans.html.boot.fx.FXInspect;

final class WatchDir
implements Runnable {
    private final Path dir;
    private final WatchKey key;
    private final WatchService ws;
    private final Thread watcher;
    private final WebEngine engine;

    WatchDir(WebEngine eng) throws URISyntaxException, IOException {
        URI loc = new URI(eng.getLocation());
        if (loc.getFragment() != null) {
            loc = new URI(loc.getScheme(), loc.getHost(), loc.getPath(), null);
        }
        this.dir = Paths.get(loc).getParent();
        this.engine = eng;
        this.ws = this.dir.getFileSystem().newWatchService();
        this.key = this.dir.register(this.ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.watcher = new Thread((Runnable)this, "Watching files in " + this.dir);
        this.watcher.setDaemon(true);
        this.watcher.setPriority(1);
        this.watcher.start();
    }

    public void close() throws IOException {
        this.key.cancel();
        this.ws.close();
        this.watcher.interrupt();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (Platform.isFxApplicationThread()) {
            this.engine.reload();
            return;
        }
        try {
            while (this.key.isValid()) {
                try {
                    WatchKey changed = this.ws.take();
                    if (changed != this.key || changed.pollEvents().isEmpty()) {
                    }
                }
                catch (ClosedWatchServiceException ex) {}
                continue;
                Platform.runLater((Runnable)this);
                if (!this.key.reset()) return;
            }
            return;
        }
        catch (InterruptedException ex) {
            FXInspect.LOG.log(Level.SEVERE, null, ex);
        }
    }
}

