/*
 * Decompiled with CFR 0.152.
 */
package capstone;

import capstone.Arm;
import capstone.Arm64;
import capstone.M680x;
import capstone.Mips;
import capstone.Ppc;
import capstone.Sparc;
import capstone.Systemz;
import capstone.X86;
import capstone.Xcore;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.List;

public class Capstone {
    public static final int CS_API_MAJOR = 5;
    public static final int CS_API_MINOR = 0;
    public static final int CS_ARCH_ARM = 0;
    public static final int CS_ARCH_ARM64 = 1;
    public static final int CS_ARCH_MIPS = 2;
    public static final int CS_ARCH_X86 = 3;
    public static final int CS_ARCH_PPC = 4;
    public static final int CS_ARCH_SPARC = 5;
    public static final int CS_ARCH_SYSZ = 6;
    public static final int CS_ARCH_XCORE = 7;
    public static final int CS_ARCH_M68K = 8;
    public static final int CS_ARCH_TMS320C64X = 9;
    public static final int CS_ARCH_M680X = 10;
    public static final int CS_ARCH_MAX = 11;
    public static final int CS_ARCH_ALL = 65535;
    public static final int CS_MODE_LITTLE_ENDIAN = 0;
    public static final int CS_MODE_ARM = 0;
    public static final int CS_MODE_16 = 2;
    public static final int CS_MODE_32 = 4;
    public static final int CS_MODE_64 = 8;
    public static final int CS_MODE_THUMB = 16;
    public static final int CS_MODE_MCLASS = 32;
    public static final int CS_MODE_V8 = 64;
    public static final int CS_MODE_MICRO = 16;
    public static final int CS_MODE_MIPS3 = 32;
    public static final int CS_MODE_MIPS32R6 = 64;
    public static final int CS_MODE_MIPS2 = 128;
    public static final int CS_MODE_BIG_ENDIAN = Integer.MIN_VALUE;
    public static final int CS_MODE_V9 = 16;
    public static final int CS_MODE_MIPS32 = 4;
    public static final int CS_MODE_MIPS64 = 8;
    public static final int CS_MODE_QPX = 16;
    public static final int CS_MODE_M680X_6301 = 2;
    public static final int CS_MODE_M680X_6309 = 4;
    public static final int CS_MODE_M680X_6800 = 8;
    public static final int CS_MODE_M680X_6801 = 16;
    public static final int CS_MODE_M680X_6805 = 32;
    public static final int CS_MODE_M680X_6808 = 64;
    public static final int CS_MODE_M680X_6809 = 128;
    public static final int CS_MODE_M680X_6811 = 256;
    public static final int CS_MODE_M680X_CPU12 = 512;
    public static final int CS_MODE_M680X_HCS08 = 1024;
    public static final int CS_ERR_OK = 0;
    public static final int CS_ERR_MEM = 1;
    public static final int CS_ERR_ARCH = 2;
    public static final int CS_ERR_HANDLE = 3;
    public static final int CS_ERR_CSH = 4;
    public static final int CS_ERR_MODE = 5;
    public static final int CS_ERR_OPTION = 6;
    public static final int CS_ERR_DETAIL = 7;
    public static final int CS_ERR_MEMSETUP = 8;
    public static final int CS_ERR_VERSION = 9;
    public static final int CS_ERR_DIET = 10;
    public static final int CS_ERR_SKIPDATA = 11;
    public static final int CS_ERR_X86_ATT = 12;
    public static final int CS_ERR_X86_INTEL = 13;
    public static final int CS_OPT_SYNTAX = 1;
    public static final int CS_OPT_DETAIL = 2;
    public static final int CS_OPT_MODE = 3;
    public static final int CS_OPT_OFF = 0;
    public static final int CS_OPT_SYNTAX_INTEL = 1;
    public static final int CS_OPT_SYNTAX_ATT = 2;
    public static final int CS_OPT_ON = 3;
    public static final int CS_OPT_SYNTAX_NOREGNAME = 3;
    public static final int CS_OP_INVALID = 0;
    public static final int CS_OP_REG = 1;
    public static final int CS_OP_IMM = 2;
    public static final int CS_OP_MEM = 3;
    public static final int CS_OP_FP = 4;
    public static final int CS_AC_INVALID = 0;
    public static final int CS_AC_READ = 1;
    public static final int CS_AC_WRITE = 2;
    public static final int CS_GRP_INVALID = 0;
    public static final int CS_GRP_JUMP = 1;
    public static final int CS_GRP_CALL = 2;
    public static final int CS_GRP_RET = 3;
    public static final int CS_GRP_INT = 4;
    public static final int CS_GRP_IRET = 5;
    public static final int CS_GRP_PRIVILEGE = 6;
    public static final int CS_SUPPORT_DIET = 65536;
    public static final int CS_SUPPORT_X86_REDUCE = 65537;
    private static final CsInsn[] EMPTY_INSN = new CsInsn[0];
    protected NativeStruct ns;
    private CS cs = (CS)Native.loadLibrary((String)"capstone", CS.class);
    public int arch;
    public int mode;
    private int syntax;
    private int detail;
    private boolean diet;

    private CsInsn[] fromArrayRaw(_cs_insn[] _cs_insnArray) {
        CsInsn[] csInsnArray = new CsInsn[_cs_insnArray.length];
        for (int i = 0; i < _cs_insnArray.length; ++i) {
            csInsnArray[i] = new CsInsn(_cs_insnArray[i], this.arch, this.ns.csh, this.cs, this.diet);
        }
        return csInsnArray;
    }

    public Capstone(int n, int n2) {
        int n3 = this.cs.cs_version(null, null);
        int n4 = 1280;
        if (n3 != n4) {
            throw new RuntimeException("Different API version between core " + n3 + " & binding " + n4 + " (CS_ERR_VERSION)");
        }
        this.arch = n;
        this.mode = n2;
        this.ns = new NativeStruct();
        this.ns.handleRef = new PointerByReference();
        if (this.cs.cs_open(n, n2, this.ns.handleRef) != 0) {
            throw new RuntimeException("ERROR: Wrong arch or mode");
        }
        this.ns.csh = this.ns.handleRef.getValue();
        this.detail = 0;
        this.diet = this.cs.cs_support(65536);
    }

    public int version() {
        return this.cs.cs_version(null, null);
    }

    public void setSyntax(int n) {
        if (this.cs.cs_option(this.ns.csh, 1, new NativeLong((long)n)) != 0) {
            throw new RuntimeException("ERROR: Failed to set assembly syntax");
        }
        this.syntax = n;
    }

    public void setDetail(int n) {
        if (this.cs.cs_option(this.ns.csh, 2, new NativeLong((long)n)) != 0) {
            throw new RuntimeException("ERROR: Failed to set detail option");
        }
        this.detail = n;
    }

    public void setMode(int n) {
        if (this.cs.cs_option(this.ns.csh, 3, new NativeLong((long)n)) != 0) {
            throw new RuntimeException("ERROR: Failed to set mode option");
        }
        this.mode = n;
    }

    protected void finalize() {
    }

    public int close() {
        return this.cs.cs_close(this.ns.handleRef);
    }

    public CsInsn[] disasm(byte[] byArray, long l) {
        return this.disasm(byArray, l, 0L);
    }

    public CsInsn[] disasm(byte[] byArray, long l, long l2) {
        PointerByReference pointerByReference = new PointerByReference();
        NativeLong nativeLong = this.cs.cs_disasm(this.ns.csh, byArray, new NativeLong((long)byArray.length), l, new NativeLong(l2), pointerByReference);
        if (0 == nativeLong.intValue()) {
            return EMPTY_INSN;
        }
        Pointer pointer = pointerByReference.getValue();
        _cs_insn _cs_insn2 = new _cs_insn(pointer);
        CsInsn[] csInsnArray = this.fromArrayRaw((_cs_insn[])_cs_insn2.toArray(nativeLong.intValue()));
        return csInsnArray;
    }

    public String strerror(int n) {
        return this.cs.cs_strerror(n);
    }

    protected class NativeStruct {
        private Pointer csh;
        private PointerByReference handleRef;

        protected NativeStruct() {
        }
    }

    private static interface CS
    extends Library {
        public int cs_open(int var1, int var2, PointerByReference var3);

        public NativeLong cs_disasm(Pointer var1, byte[] var2, NativeLong var3, long var4, NativeLong var6, PointerByReference var7);

        public void cs_free(Pointer var1, NativeLong var2);

        public int cs_close(PointerByReference var1);

        public int cs_option(Pointer var1, int var2, NativeLong var3);

        public String cs_reg_name(Pointer var1, int var2);

        public int cs_op_count(Pointer var1, Pointer var2, int var3);

        public int cs_op_index(Pointer var1, Pointer var2, int var3, int var4);

        public String cs_insn_name(Pointer var1, int var2);

        public String cs_group_name(Pointer var1, int var2);

        public byte cs_insn_group(Pointer var1, Pointer var2, int var3);

        public byte cs_reg_read(Pointer var1, Pointer var2, int var3);

        public byte cs_reg_write(Pointer var1, Pointer var2, int var3);

        public int cs_errno(Pointer var1);

        public int cs_version(IntByReference var1, IntByReference var2);

        public boolean cs_support(int var1);

        public String cs_strerror(int var1);

        public int cs_regs_access(Pointer var1, Pointer var2, Pointer var3, ByteByReference var4, Pointer var5, ByteByReference var6);
    }

    public static class CsRegsAccess {
        public short[] regsRead;
        public short[] regsWrite;

        public CsRegsAccess(short[] sArray, short[] sArray2) {
            this.regsRead = sArray;
            this.regsWrite = sArray2;
        }
    }

    public static class CsInsn {
        private Pointer csh;
        private CS cs;
        private _cs_insn raw;
        private int arch;
        public int id;
        public long address;
        public short size;
        public byte[] bytes;
        public String mnemonic;
        public String opStr;
        public short[] regsRead;
        public short[] regsWrite;
        public byte[] groups;
        public OpInfo operands;

        public CsInsn(_cs_insn _cs_insn2, int n, Pointer pointer, CS cS, boolean bl) {
            int n2;
            this.id = _cs_insn2.id;
            this.address = _cs_insn2.address;
            this.size = _cs_insn2.size;
            if (!bl) {
                n2 = 0;
                while (_cs_insn2.mnemonic[n2++] != 0) {
                }
                int n3 = 0;
                while (_cs_insn2.op_str[n3++] != 0) {
                }
                this.mnemonic = new String(_cs_insn2.mnemonic, 0, n2 - 1);
                this.opStr = new String(_cs_insn2.op_str, 0, n3 - 1);
                this.bytes = Arrays.copyOf(_cs_insn2.bytes, (int)_cs_insn2.size);
            }
            this.cs = cS;
            this.arch = n;
            this.raw = _cs_insn2;
            this.csh = pointer;
            if (_cs_insn2.cs_detail != null) {
                if (!bl) {
                    this.regsRead = new short[_cs_insn2.cs_detail.regs_read_count];
                    for (n2 = 0; n2 < this.regsRead.length; ++n2) {
                        this.regsRead[n2] = _cs_insn2.cs_detail.regs_read[n2];
                    }
                    this.regsWrite = new short[_cs_insn2.cs_detail.regs_write_count];
                    for (n2 = 0; n2 < this.regsWrite.length; ++n2) {
                        this.regsWrite[n2] = _cs_insn2.cs_detail.regs_write[n2];
                    }
                    this.groups = new byte[_cs_insn2.cs_detail.groups_count];
                    for (n2 = 0; n2 < this.groups.length; ++n2) {
                        this.groups[n2] = _cs_insn2.cs_detail.groups[n2];
                    }
                }
                this.operands = this.getOptInfo(_cs_insn2.cs_detail);
            }
        }

        private OpInfo getOptInfo(_cs_detail _cs_detail2) {
            OpInfo opInfo = null;
            switch (this.arch) {
                case 0: {
                    _cs_detail2.arch.setType(Arm.UnionOpInfo.class);
                    _cs_detail2.arch.read();
                    opInfo = new Arm.OpInfo(_cs_detail2.arch.arm);
                    break;
                }
                case 1: {
                    _cs_detail2.arch.setType(Arm64.UnionOpInfo.class);
                    _cs_detail2.arch.read();
                    opInfo = new Arm64.OpInfo(_cs_detail2.arch.arm64);
                    break;
                }
                case 2: {
                    _cs_detail2.arch.setType(Mips.UnionOpInfo.class);
                    _cs_detail2.arch.read();
                    opInfo = new Mips.OpInfo(_cs_detail2.arch.mips);
                    break;
                }
                case 3: {
                    _cs_detail2.arch.setType(X86.UnionOpInfo.class);
                    _cs_detail2.arch.read();
                    opInfo = new X86.OpInfo(_cs_detail2.arch.x86);
                    break;
                }
                case 5: {
                    _cs_detail2.arch.setType(Sparc.UnionOpInfo.class);
                    _cs_detail2.arch.read();
                    opInfo = new Sparc.OpInfo(_cs_detail2.arch.sparc);
                    break;
                }
                case 6: {
                    _cs_detail2.arch.setType(Systemz.UnionOpInfo.class);
                    _cs_detail2.arch.read();
                    opInfo = new Systemz.OpInfo(_cs_detail2.arch.sysz);
                    break;
                }
                case 4: {
                    _cs_detail2.arch.setType(Ppc.UnionOpInfo.class);
                    _cs_detail2.arch.read();
                    opInfo = new Ppc.OpInfo(_cs_detail2.arch.ppc);
                    break;
                }
                case 7: {
                    _cs_detail2.arch.setType(Xcore.UnionOpInfo.class);
                    _cs_detail2.arch.read();
                    opInfo = new Xcore.OpInfo(_cs_detail2.arch.xcore);
                    break;
                }
                case 10: {
                    _cs_detail2.arch.setType(M680x.UnionOpInfo.class);
                    _cs_detail2.arch.read();
                    opInfo = new M680x.OpInfo(_cs_detail2.arch.m680x);
                    break;
                }
            }
            return opInfo;
        }

        public int opCount(int n) {
            return this.cs.cs_op_count(this.csh, this.raw.getPointer(), n);
        }

        public int opIndex(int n, int n2) {
            return this.cs.cs_op_index(this.csh, this.raw.getPointer(), n, n2);
        }

        public boolean regRead(int n) {
            return this.cs.cs_reg_read(this.csh, this.raw.getPointer(), n) != 0;
        }

        public boolean regWrite(int n) {
            return this.cs.cs_reg_write(this.csh, this.raw.getPointer(), n) != 0;
        }

        public int errno() {
            return this.cs.cs_errno(this.csh);
        }

        public String regName(int n) {
            return this.cs.cs_reg_name(this.csh, n);
        }

        public String insnName() {
            return this.cs.cs_insn_name(this.csh, this.id);
        }

        public String groupName(int n) {
            return this.cs.cs_group_name(this.csh, n);
        }

        public boolean group(int n) {
            return this.cs.cs_insn_group(this.csh, this.raw.getPointer(), n) != 0;
        }

        public CsRegsAccess regsAccess() {
            Memory memory = new Memory(128L);
            ByteByReference byteByReference = new ByteByReference();
            Memory memory2 = new Memory(128L);
            ByteByReference byteByReference2 = new ByteByReference();
            int n = this.cs.cs_regs_access(this.csh, this.raw.getPointer(), (Pointer)memory, byteByReference, (Pointer)memory2, byteByReference2);
            if (n != 0) {
                return null;
            }
            byte by = byteByReference.getValue();
            byte by2 = byteByReference2.getValue();
            short[] sArray = new short[by];
            memory.read(0L, sArray, 0, (int)by);
            short[] sArray2 = new short[by2];
            memory2.read(0L, sArray2, 0, (int)by2);
            return new CsRegsAccess(sArray, sArray2);
        }
    }

    protected static class _cs_detail
    extends Structure {
        public short[] regs_read = new short[16];
        public byte regs_read_count;
        public short[] regs_write = new short[20];
        public byte regs_write_count;
        public byte[] groups = new byte[8];
        public byte groups_count;
        public UnionArch arch;

        protected _cs_detail() {
        }

        public List getFieldOrder() {
            return Arrays.asList("regs_read", "regs_read_count", "regs_write", "regs_write_count", "groups", "groups_count", "arch");
        }

        public static class ByReference
        extends _cs_detail
        implements Structure.ByReference {
        }
    }

    protected static class _cs_insn
    extends Structure {
        public int id;
        public long address;
        public short size;
        public byte[] bytes = new byte[24];
        public byte[] mnemonic = new byte[32];
        public byte[] op_str = new byte[160];
        public _cs_detail.ByReference cs_detail;

        public _cs_insn() {
            Arrays.fill(this.mnemonic, (byte)0);
            Arrays.fill(this.op_str, (byte)0);
        }

        public _cs_insn(Pointer pointer) {
            this();
            this.useMemory(pointer);
            this.read();
        }

        public List getFieldOrder() {
            return Arrays.asList("id", "address", "size", "bytes", "mnemonic", "op_str", "cs_detail");
        }
    }

    public static class UnionArch
    extends Union {
        public Arm.UnionOpInfo arm;
        public Arm64.UnionOpInfo arm64;
        public X86.UnionOpInfo x86;
        public Mips.UnionOpInfo mips;
        public Ppc.UnionOpInfo ppc;
        public Sparc.UnionOpInfo sparc;
        public Systemz.UnionOpInfo sysz;
        public Xcore.UnionOpInfo xcore;
        public M680x.UnionOpInfo m680x;

        public static class ByValue
        extends UnionArch
        implements Structure.ByValue {
        }
    }

    protected static abstract class UnionOpInfo
    extends Structure {
        protected UnionOpInfo() {
        }
    }

    protected static abstract class OpInfo {
        protected OpInfo() {
        }
    }
}

