/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.dataflow.layout;

import at.ssw.positionmanager.LayoutGraph;
import at.ssw.positionmanager.Link;
import at.ssw.positionmanager.Port;
import at.ssw.positionmanager.Vertex;
import java.awt.Point;
import java.util.LinkedList;

public class RoutingHelper {
    private static final int BORDERINSETCORRECT = 0;
    private static final int SEPERATETWINLINES = 5;

    public static void doRouting(LayoutGraph graph) {
        if (graph == null) {
            return;
        }
        for (Link l : graph.getLinks()) {
            boolean twin = false;
            Vertex from = l.getFrom().getVertex();
            Vertex to = l.getTo().getVertex();
            if (!from.isDirty() && !to.isDirty()) continue;
            for (Port p : graph.getInputPorts(from)) {
                for (Link l2 : graph.getPortLinks(p)) {
                    if (l2.getFrom().getVertex() != l.getTo().getVertex()) continue;
                    twin = true;
                }
            }
            RoutingHelper.routeLink(l, twin);
        }
    }

    private static void routeLink(Link l, boolean hasTwin) {
        Vertex v1 = l.getFrom().getVertex();
        Vertex v2 = l.getTo().getVertex();
        Point p1 = (Point)v1.getPosition().clone();
        Point p2 = (Point)v2.getPosition().clone();
        p1.translate(0 + v1.getSize().width / 2, 0 + v1.getSize().height / 2);
        p2.translate(0 + v2.getSize().width / 2, 0 + v2.getSize().height / 2);
        if (p1.x == p2.x) {
            int shift = 0;
            if (p1.y > p2.y) {
                if (hasTwin) {
                    shift = 5;
                }
                p1.translate(shift, -v1.getSize().height / 2);
                p2.translate(shift, v2.getSize().height / 2);
            } else {
                if (hasTwin) {
                    shift = -5;
                }
                p1.translate(shift, v1.getSize().height / 2);
                p2.translate(shift, -v2.getSize().height / 2);
            }
        } else {
            Vertex v3;
            Point p3;
            double k = (double)(p1.y - p2.y) / (double)(p1.x - p2.x);
            double gk = Math.atan(k);
            double twdx = 0.0;
            double twdy = 0.0;
            boolean swap = false;
            if (hasTwin) {
                twdx = Math.abs(Math.sin(gk) * 5.0);
                twdy = Math.abs(Math.cos(gk) * 5.0);
            }
            if (p1.x <= p2.x) {
                swap = true;
                p3 = p1;
                p1 = p2;
                p2 = p3;
                v3 = v1;
                v1 = v2;
                v2 = v3;
                twdx *= -1.0;
                twdy *= -1.0;
            }
            if (p1.y > p2.y) {
                p1.translate((int)twdx, -((int)twdy));
                p2.translate((int)twdx, -((int)twdy));
                double x = (double)v2.getSize().height / 2.0 / Math.tan(gk);
                if (Math.abs(x) <= (double)(v2.getSize().width / 2)) {
                    p2.translate((int)x, v2.getSize().height / 2);
                } else {
                    x = Math.tan(gk) * (double)v2.getSize().width / 2.0;
                    p2.translate(v2.getSize().width / 2, (int)x);
                }
                x = Math.tan(1.5707963267948966 - gk) * (double)v1.getSize().height / 2.0;
                if (Math.abs(x) <= (double)(v1.getSize().width / 2)) {
                    p1.translate(-((int)x), -v1.getSize().height / 2);
                } else {
                    x = (double)v1.getSize().width / 2.0 / Math.tan(1.5707963267948966 - gk);
                    p1.translate(-v1.getSize().width / 2, -((int)x));
                }
            } else {
                p1.translate((int)(-twdx), (int)(-twdy));
                p2.translate((int)(-twdx), (int)(-twdy));
                double x = (double)v1.getSize().height / 2.0 / Math.tan(gk);
                if (Math.abs(x) <= (double)(v1.getSize().width / 2)) {
                    p1.translate((int)x, v1.getSize().height / 2);
                } else {
                    x = Math.tan(gk) * (double)v1.getSize().width / 2.0;
                    p1.translate(-v1.getSize().width / 2, -((int)x));
                }
                x = Math.tan(1.5707963267948966 - gk) * (double)v2.getSize().height / 2.0;
                if (Math.abs(x) <= (double)(v2.getSize().width / 2)) {
                    p2.translate(-((int)x), -v2.getSize().height / 2);
                } else {
                    x = (double)v2.getSize().width / 2.0 / Math.tan(1.5707963267948966 - gk);
                    p2.translate(v2.getSize().width / 2, (int)x);
                }
            }
            if (swap) {
                p3 = p1;
                p1 = p2;
                p2 = p3;
                v3 = v1;
                v1 = v2;
                v2 = v3;
            }
        }
        LinkedList<Point> cp = new LinkedList<Point>();
        cp.add(p1);
        cp.add(p2);
        l.setControlPoints(cp);
    }
}

