/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.dataflow.options;

import at.ssw.dataflow.options.Validator;

public class DoubleStringValidator
implements Validator {
    private double min;
    private double max;
    String error = null;

    public DoubleStringValidator(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public DoubleStringValidator() {
        this(Double.MIN_VALUE, Double.MAX_VALUE);
    }

    @Override
    public boolean validate(Object option) {
        try {
            if (!(option instanceof String)) {
                this.error = "Option is not a string";
                return false;
            }
            double x = Double.parseDouble((String)option);
            if (x >= this.min && x <= this.max) {
                this.error = null;
                return true;
            }
            this.error = "Value not within intervall: [" + this.min + "," + this.max + "]";
            return false;
        }
        catch (Exception e) {
            this.error = "No double value.";
            return false;
        }
    }

    @Override
    public String getLastErrorMessage() {
        return this.error;
    }
}

