/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.dataflow.options;

import at.ssw.dataflow.options.OptionProvider;
import at.ssw.dataflow.options.Validator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class OptionEditor
extends JDialog {
    private OptionProvider provider;
    private static final String DEFAULTTITEL = "Options";
    private static final String BUTCLOSE = "Close";

    public OptionEditor(OptionProvider provider) {
        this.getContentPane().setLayout(new BorderLayout());
        this.provider = provider;
        this.setSize(300, 300);
        this.setLocationRelativeTo(null);
        this.setTitle(DEFAULTTITEL);
        this.setModal(true);
        JTable tab = new JTable();
        JLabel errorLabel = new JLabel();
        errorLabel.setHorizontalAlignment(0);
        errorLabel.setForeground(Color.RED);
        tab.setModel(new Model(provider, errorLabel));
        tab.setColumnSelectionAllowed(true);
        JScrollPane sp = new JScrollPane(tab);
        this.getContentPane().add((Component)sp, "Center");
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(2, 1));
        p.add(errorLabel);
        JButton b = new JButton(BUTCLOSE);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionEditor.this.OnClose();
            }
        });
        p.add(b);
        this.getContentPane().add((Component)p, "South");
    }

    public void OnClose() {
        this.setVisible(false);
    }

    protected class Model
    extends AbstractTableModel {
        private OptionProvider provider;
        private final String[] TableHeader = new String[]{"Option", "Value"};
        private JLabel error;

        public Model(OptionProvider provider, JLabel error) {
            this.provider = provider;
            this.error = error;
        }

        @Override
        public int getRowCount() {
            return this.provider.getOptionKeys().length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int col) {
            return this.TableHeader[col];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String key = this.provider.getOptionKeys()[rowIndex];
            if (columnIndex == 0) {
                return key;
            }
            if (columnIndex == 1) {
                return this.provider.getOption(key);
            }
            return null;
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            if (col == 0) {
                return;
            }
            String key = this.provider.getOptionKeys()[row];
            Validator v = this.provider.getOptionValidator(key);
            if (v.validate(o)) {
                this.error.setText("");
                this.provider.setOption(key, o);
            } else {
                this.error.setText(v.getLastErrorMessage());
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }
    }
}

