/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.graphanalyzer.positioning;

import at.ssw.graphanalyzer.positioning.ClusterIngoingConnection;
import at.ssw.graphanalyzer.positioning.ClusterNode;
import at.ssw.graphanalyzer.positioning.InterClusterConnection;
import at.ssw.positionmanager.Cluster;
import at.ssw.positionmanager.Port;
import at.ssw.positionmanager.Vertex;
import java.awt.Dimension;
import java.awt.Point;

public class ClusterInputSlotNode
implements Vertex {
    private final int SIZE = 0;
    private Point position;
    private Port inputSlot;
    private Port outputSlot;
    private ClusterNode blockNode;
    private InterClusterConnection interBlockConnection;
    private Cluster cluster;
    private boolean dirty;
    private ClusterIngoingConnection conn;
    private String id;

    public void setIngoingConnection(ClusterIngoingConnection c) {
        this.conn = c;
    }

    public ClusterIngoingConnection getIngoingConnection() {
        return this.conn;
    }

    public String toString() {
        return this.id;
    }

    public ClusterInputSlotNode(ClusterNode n, String id) {
        this.blockNode = n;
        this.id = id;
        n.addSubNode(this);
        final ClusterInputSlotNode thisNode = this;
        final ClusterNode thisBlockNode = this.blockNode;
        this.outputSlot = new Port(){

            public Point getRelativePosition() {
                return new Point(0, 0);
            }

            public Vertex getVertex() {
                return thisNode;
            }

            public String toString() {
                return "OutPort of " + thisNode.toString();
            }
        };
        this.inputSlot = new Port(){

            public Point getRelativePosition() {
                Point p = new Point(thisNode.getPosition());
                Point blockPos = thisBlockNode.getPosition();
                p.x -= blockPos.x;
                p.y -= blockPos.y;
                return p;
            }

            public Vertex getVertex() {
                return thisBlockNode;
            }

            public String toString() {
                return "InPort of " + thisNode.toString();
            }
        };
    }

    public Port getInputSlot() {
        return this.inputSlot;
    }

    public InterClusterConnection getInterBlockConnection() {
        return this.interBlockConnection;
    }

    public Port getOutputSlot() {
        return this.outputSlot;
    }

    public Dimension getSize() {
        return new Dimension(0, 0);
    }

    public void setPosition(Point p) {
        this.position = p;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setInterBlockConnection(InterClusterConnection interBlockConnection) {
        this.interBlockConnection = interBlockConnection;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isRoot() {
        return true;
    }

    public int compareTo(Vertex o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean isExpanded() {
        return false;
    }

    public boolean isFixed() {
        return false;
    }

    public boolean isMarked() {
        return false;
    }
}

