/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.graphanalyzer.positioning;

import at.ssw.graphanalyzer.positioning.Edge;
import at.ssw.graphanalyzer.positioning.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

public class Graph<N, E> {
    private Hashtable<Object, Node<N, E>> nodes = new Hashtable();
    private Hashtable<Object, Edge<N, E>> edges = new Hashtable();
    private List<Node<N, E>> nodeList = new ArrayList<Node<N, E>>();
    private List<Edge<N, E>> edgeList = new ArrayList<Edge<N, E>>();

    public Node<N, E> createNode(N data, Object key) {
        Node n = new Node(this, data);
        assert (key == null || !this.nodes.containsKey(key));
        if (key != null) {
            this.nodes.put(key, n);
        }
        this.nodeList.add(n);
        return n;
    }

    public Edge<N, E> createEdge(Node<N, E> source, Node<N, E> dest, E data, Object key) {
        Edge<N, E> e = new Edge<N, E>(this, source, dest, data);
        source.addOutEdge(e);
        dest.addInEdge(e);
        if (key != null) {
            this.edges.put(key, e);
        }
        this.edgeList.add(e);
        return e;
    }

    public Node<N, E> getNode(Object key) {
        return this.nodes.get(key);
    }

    public Edge<N, E> getEdge(Object key) {
        return this.edges.get(key);
    }

    public Collection<Edge<N, E>> getEdges() {
        return Collections.unmodifiableCollection(this.edges.values());
    }

    public Collection<Node<N, E>> getNodes() {
        return Collections.unmodifiableList(this.nodeList);
    }

    public void removeEdge(Edge<N, E> e, Object key) {
        assert (key == null || this.edges.containsKey(key));
        if (key != null) {
            this.edges.remove(key);
        }
        this.edgeList.remove(e);
        e.getSource().removeOutEdge(e);
        e.getDest().removeInEdge(e);
    }

    public List<Node<N, E>> getNodesWithInDegree(int x) {
        return this.getNodesWithInDegree(x, true);
    }

    public List<Node<N, E>> getNodesWithInDegree(int x, boolean countSelfLoops) {
        ArrayList<Node<N, Node<N, E>>> result = new ArrayList<Node<N, Node<N, E>>>();
        for (Node<N, E> n : this.getNodes()) {
            if (n.getInDegree(countSelfLoops) != x) continue;
            result.add(n);
        }
        return result;
    }

    private void markReachable(Node<N, E> startingNode) {
        ArrayList<Node<N, Node<N, E>>> arr = new ArrayList<Node<N, Node<N, E>>>();
        arr.add(startingNode);
        for (Node<N, E> n : this.getNodes()) {
            n.setReachable(false);
        }
        this.traverseDFS(arr, new DFSTraversalVisitor(){

            @Override
            public void visitNode(Node<N, E> n) {
                n.setReachable(true);
            }
        });
    }

    public void traverseBFS(Node<N, E> startingNode, BFSTraversalVisitor tv, boolean longestPath) {
        if (longestPath) {
            this.markReachable(startingNode);
        }
        for (Node<N, E> n : this.getNodes()) {
            n.setVisited(false);
            n.setActive(false);
        }
        LinkedList queue = new LinkedList();
        queue.add(startingNode);
        startingNode.setVisited(true);
        int layer = 0;
        Node<N, E> lastOfLayer = startingNode;
        Node lastAdded = null;
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            tv.visitNode(current, layer);
            current.setActive(false);
            for (Edge e : current.getOutEdges()) {
                if (e.getDest().isVisited()) continue;
                boolean allow = true;
                if (longestPath) {
                    for (Node pred : e.getDest().getPredecessors()) {
                        if (pred.isVisited() && !pred.isActive() || !pred.isReachable()) continue;
                        allow = false;
                        break;
                    }
                }
                if (!allow) continue;
                queue.offer(e.getDest());
                lastAdded = e.getDest();
                e.getDest().setVisited(true);
                e.getDest().setActive(true);
            }
            if (current != lastOfLayer || queue.isEmpty()) continue;
            lastOfLayer = lastAdded;
            ++layer;
        }
    }

    public void traverseDFS(DFSTraversalVisitor tv) {
        this.traverseDFS(this.getNodes(), tv);
    }

    public void traverseDFS(Collection<Node<N, E>> startingNodes, DFSTraversalVisitor tv) {
        for (Node<N, E> n : this.getNodes()) {
            n.setVisited(false);
            n.setActive(false);
        }
        boolean result = false;
        for (Node<N, E> n : startingNodes) {
            this.traverse(tv, n);
        }
    }

    private void traverse(DFSTraversalVisitor tv, Node<N, E> n) {
        if (!n.isVisited()) {
            n.setVisited(true);
            n.setActive(true);
            tv.visitNode(n);
            for (Edge<N, E> e : n.getOutEdges()) {
                Node<N, E> next = e.getDest();
                if (next.isActive()) {
                    tv.visitEdge(e, true);
                    continue;
                }
                if (!tv.visitEdge(e, false)) continue;
                this.traverse(tv, next);
            }
            n.setActive(false);
        }
    }

    public boolean hasCycles() {
        for (Node<N, E> n : this.getNodes()) {
            n.setVisited(false);
            n.setActive(false);
        }
        boolean result = false;
        for (Node<N, E> n : this.getNodes()) {
            if (result |= this.checkCycles(n)) break;
        }
        return result;
    }

    private boolean checkCycles(Node<N, E> n) {
        if (n.isActive()) {
            return true;
        }
        if (!n.isVisited()) {
            n.setVisited(true);
            n.setActive(true);
            for (Node<N, E> succ : n.getSuccessors()) {
                if (!this.checkCycles(succ)) continue;
                return true;
            }
            n.setActive(false);
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Nodes: ");
        for (Node<N, E> node : this.getNodes()) {
            s.append(node.toString());
            s.append("\n");
        }
        s.append("Edges: ");
        for (Edge edge : this.getEdges()) {
            s.append(edge.toString());
            s.append("\n");
        }
        return s.toString();
    }

    public class DFSTraversalVisitor {
        public void visitNode(Node<N, E> n) {
        }

        public boolean visitEdge(Edge<N, E> e, boolean backEdge) {
            return true;
        }
    }

    public class BFSTraversalVisitor {
        public void visitNode(Node<N, E> n, int depth) {
        }
    }
}

