/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.graphanalyzer.positioning;

import at.ssw.graphanalyzer.positioning.Edge;
import at.ssw.graphanalyzer.positioning.Graph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Node<N, E> {
    private N data;
    private List<Edge<N, E>> inEdges;
    private List<Edge<N, E>> outEdges;
    private boolean visited;
    private boolean active;
    private boolean reachable;
    private Graph<N, E> graph;

    protected boolean isVisited() {
        return this.visited;
    }

    protected void setVisited(boolean b) {
        this.visited = b;
    }

    protected boolean isReachable() {
        return this.reachable;
    }

    protected void setReachable(boolean b) {
        this.reachable = b;
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean b) {
        this.active = b;
    }

    public int getInDegree() {
        return this.getInDegree(true);
    }

    public int getInDegree(boolean countSelfLoops) {
        if (countSelfLoops) {
            return this.inEdges.size();
        }
        int cnt = 0;
        for (Edge<N, E> e : this.inEdges) {
            if (e.getSource() == this) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getOutDegree() {
        return this.outEdges.size();
    }

    protected Node(Graph<N, E> graph, N data) {
        this.setData(data);
        this.graph = graph;
        this.inEdges = new ArrayList<Edge<N, E>>();
        this.outEdges = new ArrayList<Edge<N, E>>();
    }

    protected void addInEdge(Edge<N, E> e) {
        assert (!this.inEdges.contains(e));
        this.inEdges.add(e);
    }

    protected void addOutEdge(Edge<N, E> e) {
        assert (!this.outEdges.contains(e));
        this.outEdges.add(e);
    }

    protected void removeInEdge(Edge<N, E> e) {
        assert (this.inEdges.contains(e));
        this.inEdges.remove(e);
    }

    protected void removeOutEdge(Edge<N, E> e) {
        assert (this.outEdges.contains(e));
        this.outEdges.remove(e);
    }

    public List<Edge<N, E>> getInEdges() {
        return Collections.unmodifiableList(this.inEdges);
    }

    public List<Edge<N, E>> getOutEdges() {
        return Collections.unmodifiableList(this.outEdges);
    }

    public List<Node<N, E>> getSuccessors() {
        ArrayList<Node<N, Node<N, E>>> succ = new ArrayList<Node<N, Node<N, E>>>();
        for (Edge<N, E> e : this.getOutEdges()) {
            Node<N, E> n = e.getDest();
            if (succ.contains(n)) continue;
            succ.add(n);
        }
        return succ;
    }

    public List<Node<N, E>> getPredecessors() {
        ArrayList<Node<N, Node<N, E>>> pred = new ArrayList<Node<N, Node<N, E>>>();
        for (Edge<N, E> e : this.getInEdges()) {
            Node<N, E> n = e.getSource();
            if (pred.contains(n)) continue;
            pred.add(n);
        }
        return pred;
    }

    public N getData() {
        return this.data;
    }

    public void setData(N d) {
        this.data = d;
    }

    public String toString() {
        return "Node: " + this.data;
    }
}

