/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.interval;

import at.ssw.visualizer.interval.IntervalEditorTopComponent;
import at.ssw.visualizer.interval.ViewSettings;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.model.cfg.IRInstruction;
import at.ssw.visualizer.model.interval.ChildInterval;
import at.ssw.visualizer.model.interval.Interval;
import at.ssw.visualizer.model.interval.IntervalList;
import at.ssw.visualizer.model.interval.Range;
import at.ssw.visualizer.model.interval.UsePosition;
import at.ssw.visualizer.texteditor.model.HoverParser;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;

public class IntervalCanvas
extends JViewport {
    private IntervalEditorTopComponent editor;
    private IntervalList intervals;
    private ViewSettings viewSettings;
    private ViewData viewData = new ViewData();
    private PlaceHolder placeholder = new PlaceHolder();
    private MouseMotionListener mouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            IntervalCanvas.this.calcSelection(e.getX(), e.getY());
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            IntervalCanvas.this.calcSelection(e.getX(), e.getY());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            IntervalCanvas.this.calcSelection(-1, -1);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            IntervalCanvas.this.editor.updateCanvasSelection();
        }
    };
    private ComponentListener componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            IntervalCanvas.this.calcViewData();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            IntervalCanvas.this.calcViewData();
        }
    };

    public IntervalCanvas(IntervalEditorTopComponent editor, ViewSettings viewSettings, IntervalList intervals) {
        this.editor = editor;
        this.intervals = intervals;
        this.viewSettings = viewSettings;
        this.setView(this.placeholder);
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("TextPane.background"));
        this.setFocusable(true);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
        this.addComponentListener(this.componentListener);
    }

    public IntervalList getIntervals() {
        return this.intervals;
    }

    public BasicBlock getSelectedBlock() {
        return this.viewData.selectedBlock;
    }

    public ChildInterval getSelectedInterval() {
        return this.viewData.selectedChild;
    }

    public void ensureColumnVisible(int column) {
        if (column < this.viewData.offsetCol) {
            this.setViewPosition(new Point(column * this.viewSettings.colWidth, this.getViewPosition().y));
        } else if (column >= this.viewData.offsetCol + this.viewData.sizeCol - 4) {
            this.setViewPosition(new Point((column - this.viewData.sizeCol + 4) * this.viewSettings.colWidth, this.getViewPosition().y));
        }
    }

    public void ensureRowVisible(int row) {
        if (row < this.viewData.offsetRow) {
            this.setViewPosition(new Point(this.getViewPosition().x, row * this.viewSettings.rowHeight));
        } else if (row >= this.viewData.offsetRow + this.viewData.sizeRow - 1) {
            this.setViewPosition(new Point(this.getViewPosition().x, (row - this.viewData.sizeRow + 1) * this.viewSettings.rowHeight));
        }
    }

    public void calcViewData() {
        Graphics gc = this.getGraphics();
        if (gc == null) {
            return;
        }
        Dimension ca = this.getExtentSize();
        this.viewData.totalRow = this.intervals.getIntervals().size();
        this.viewData.totalCol = this.intervals.getNumLIROperations();
        gc.setFont(this.viewSettings.textFont);
        FontMetrics fm = gc.getFontMetrics();
        this.viewData.fontHeight = fm.getHeight();
        this.viewData.fontAscent = fm.getAscent();
        this.viewData.offsetX = fm.stringWidth("v" + this.viewData.totalRow + "|a") + 15;
        this.viewData.offsetY = this.viewData.fontHeight * 2;
        this.placeholder.setPreferredSize(new Dimension(this.viewData.offsetX + (this.viewData.totalCol + 2) * this.viewSettings.colWidth + 2 + this.viewSettings.thickLineWidth, this.viewData.offsetY + (this.viewData.totalRow + 1) * this.viewSettings.rowHeight + 2));
        this.placeholder.setSize(this.placeholder.getPreferredSize());
        this.viewData.offsetCol = this.getViewPosition().x / this.viewSettings.colWidth / 2 * 2;
        this.viewData.offsetRow = this.getViewPosition().y / this.viewSettings.rowHeight;
        this.viewData.sizeCol = Math.min((ca.width - this.viewData.offsetX - 3) / this.viewSettings.colWidth / 2 * 2, this.viewData.totalCol - this.viewData.offsetCol);
        this.viewData.sizeRow = Math.min((ca.height - this.viewData.offsetY - 3) / this.viewSettings.rowHeight, this.viewData.totalRow - this.viewData.offsetRow);
        this.viewData.sizeX = this.viewData.sizeCol * this.viewSettings.colWidth;
        this.viewData.sizeY = this.viewData.sizeRow * this.viewSettings.rowHeight;
        this.calcSelection();
        this.repaint();
    }

    public void calcSelection(int mouseX, int mouseY) {
        this.viewData.mouseX = mouseX;
        this.viewData.mouseY = mouseY;
        this.calcSelection();
    }

    public void calcSelection() {
        int newRow;
        int newCol;
        if (this.viewData.mouseX != -1 && this.viewData.mouseY != -1) {
            newCol = (this.viewData.mouseX - this.viewData.offsetX + 2 + this.viewSettings.colWidth * 2) / this.viewSettings.colWidth / 2 * 2 + this.viewData.offsetCol - 2;
            newRow = (this.viewData.mouseY - this.viewData.offsetY + 2 + this.viewSettings.rowHeight) / this.viewSettings.rowHeight + this.viewData.offsetRow - 1;
        } else {
            newCol = -1;
            newRow = -1;
        }
        if (newCol < this.viewData.offsetCol || newCol >= this.viewData.offsetCol + this.viewData.sizeCol) {
            newCol = -1;
        }
        if (newRow < this.viewData.offsetRow || newRow >= this.viewData.offsetRow + this.viewData.sizeRow) {
            newRow = -1;
        }
        if (this.viewData.selectedCol != newCol || this.viewData.selectedRow != newRow) {
            this.viewData.selectedCol = newCol;
            this.viewData.selectedRow = newRow;
            if (newRow != -1) {
                this.viewData.selectedInterval = (Interval)this.intervals.getIntervals().get(newRow);
                this.viewData.selectedChild = this.getChildByLirId(this.viewData.selectedInterval, newCol);
            } else {
                this.viewData.selectedInterval = null;
                this.viewData.selectedChild = null;
            }
            if (newCol != -1) {
                this.viewData.selectedBlock = this.getBlockByLirId(this.intervals.getControlFlowGraph(), newCol);
                this.viewData.selectedOperation = this.getOperationByLirId(this.viewData.selectedBlock, newCol);
            } else {
                this.viewData.selectedBlock = null;
                this.viewData.selectedOperation = null;
            }
            this.repaint();
            this.updateStatusLine();
        }
    }

    private BasicBlock getBlockByLirId(ControlFlowGraph cfg, int lirId) {
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            if (basicBlock.getFirstLirId() > lirId || lirId > basicBlock.getLastLirId()) continue;
            return basicBlock;
        }
        return null;
    }

    private IRInstruction getOperationByLirId(BasicBlock block, int lirId) {
        if (block == null) {
            return null;
        }
        for (IRInstruction operation : block.getLirOperations()) {
            try {
                if (Integer.parseInt(operation.getValue("nr")) != lirId) continue;
                return operation;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return null;
    }

    public ChildInterval getChildByLirId(Interval interval, int lirId) {
        if (interval == null) {
            return null;
        }
        List children = interval.getChildren();
        for (ChildInterval child : children) {
            for (Range range : child.getRanges()) {
                if (range.getFrom() > lirId || range.getTo() < lirId) continue;
                return child;
            }
        }
        return (ChildInterval)children.get(0);
    }

    private void updateStatusLine() {
        BasicBlock block;
        IRInstruction operation;
        String intervalText = "";
        String instructionText = "";
        String blockText = "";
        ChildInterval child = this.viewData.selectedChild;
        if (child != null) {
            intervalText = child.getRegNum() + "  " + child.getType() + "  " + child.getOperand();
        }
        if ((operation = this.viewData.selectedOperation) != null) {
            for (String name : operation.getNames()) {
                instructionText = instructionText + HoverParser.firstLine((String)operation.getValue(name)) + "  ";
            }
        }
        if ((block = this.viewData.selectedBlock) != null) {
            blockText = block.getLoopDepth() > 0 ? block.getName() + " (loop " + block.getLoopIndex() + " depth " + block.getLoopDepth() + ")" : block.getName();
        }
        this.editor.setIntervalStatusText(intervalText);
        this.editor.setInstructionStatusText(instructionText);
        this.editor.setBlockStatusText(blockText);
    }

    private int gridStart(int start, int grid) {
        return grid - 1 - (start + grid - 1) % grid;
    }

    private void drawXGrid(Graphics gc, int grid, Color color) {
        gc.setColor(color);
        int y1 = this.viewData.offsetY;
        int y2 = this.viewData.offsetY + this.viewData.sizeY;
        for (int i = this.gridStart(this.viewData.offsetCol, grid); i < this.viewData.sizeCol; i += grid) {
            int x = this.viewData.offsetX + i * this.viewSettings.colWidth;
            gc.drawLine(x, y1, x, y2);
        }
    }

    private void drawXText(Graphics gc, int grid, Color color) {
        gc.setColor(color);
        int y = 0;
        for (int i = this.gridStart(this.viewData.offsetCol, grid); i < this.viewData.sizeCol; i += grid) {
            int x = this.viewData.offsetX + i * this.viewSettings.colWidth + this.viewSettings.thickLineWidth + 2;
            gc.drawString(String.valueOf(this.viewData.offsetCol + i), x, this.viewData.fontAscent + y);
        }
    }

    private void drawYGrid(Graphics gc, int grid, Color color) {
        gc.setColor(color);
        int x1 = this.viewData.offsetX;
        int x2 = this.viewData.offsetX + this.viewData.sizeX;
        for (int i = this.gridStart(this.viewData.offsetRow, grid); i < this.viewData.sizeRow; i += grid) {
            int y = this.viewData.offsetY + i * this.viewSettings.rowHeight;
            gc.drawLine(x1, y, x2, y);
        }
    }

    private void drawYText(Graphics gc, int grid, Color color) {
        gc.setColor(color);
        int x = 5;
        for (int i = this.gridStart(this.viewData.offsetRow, grid); i < this.viewData.sizeRow; i += grid) {
            Interval interval = (Interval)this.intervals.getIntervals().get(i + this.viewData.offsetRow);
            if (interval == null) continue;
            int y = this.viewData.offsetY + i * this.viewSettings.rowHeight;
            gc.drawString(String.valueOf(interval.getRegNum()), x, this.viewData.fontAscent + y);
        }
    }

    private void drawBorder(Graphics gc) {
        gc.setColor(this.viewSettings.darkGridColor);
        gc.drawRect(this.viewData.offsetX, this.viewData.offsetY, this.viewData.sizeX, this.viewData.sizeY);
    }

    private void drawBlocks(Graphics gc) {
        int y1 = this.viewData.fontHeight;
        int y2 = this.viewData.offsetY + this.viewData.sizeY;
        for (BasicBlock basicBlock : this.intervals.getControlFlowGraph().getBasicBlocks()) {
            if (basicBlock.getFirstLirId() < this.viewData.offsetCol || basicBlock.getFirstLirId() > this.viewData.offsetCol + this.viewData.sizeCol) continue;
            int x = this.viewData.colToX(basicBlock.getFirstLirId());
            gc.setColor(this.viewSettings.darkGridColor);
            gc.fillRect(x, y1, this.viewSettings.thickLineWidth, y2 - y1);
            if (basicBlock.getFirstLirId() >= this.viewData.offsetCol + this.viewData.sizeCol) continue;
            String text = basicBlock.getName();
            if (basicBlock.getLoopDepth() > 0) {
                text = text + " (" + basicBlock.getLoopDepth() + ")";
            }
            gc.setColor(this.getBackground());
            Rectangle2D stringBounds = gc.getFontMetrics().getStringBounds(text, gc);
            gc.fillRect(x + this.viewSettings.thickLineWidth + 2, y1, (int)stringBounds.getWidth(), (int)stringBounds.getHeight());
            gc.setColor(this.viewSettings.textColor);
            gc.drawString(text, x + this.viewSettings.thickLineWidth + 2, this.viewData.fontAscent + y1);
        }
        gc.setColor(this.viewSettings.darkGridColor);
        if (this.intervals.getNumLIROperations() <= this.viewData.offsetCol + this.viewData.sizeCol) {
            int x = this.viewData.colToX(this.intervals.getNumLIROperations());
            gc.fillRect(x, y1, this.viewSettings.thickLineWidth, y2 - y1);
        }
    }

    public void drawInterval(Graphics gc, ChildInterval interval, int barY, int barHeight, int textY) {
        gc.setColor(this.viewSettings.getIntervalColor(interval));
        int textX = -1;
        for (Range range : interval.getRanges()) {
            if (range.getTo() <= this.viewData.offsetCol || range.getFrom() >= this.viewData.offsetCol + this.viewData.sizeCol) continue;
            int x1 = Math.max(this.viewData.colToX(range.getFrom()) + this.viewSettings.thickLineWidth, this.viewData.offsetX);
            int x2 = Math.min(this.viewData.colToX(range.getTo()), this.viewData.offsetX + this.viewData.sizeX);
            gc.fillRect(x1, barY, x2 - x1, barHeight);
            if (textX != -1) continue;
            textX = x1;
        }
        for (UsePosition usePosition : interval.getUsePositions()) {
            if (usePosition.getPosition() < this.viewData.offsetCol || usePosition.getPosition() >= this.viewData.offsetCol + this.viewData.sizeCol) continue;
            gc.setColor(this.viewSettings.getUsePosColor(usePosition));
            int x = this.viewData.colToX(usePosition.getPosition());
            gc.fillRect(x, barY, this.viewSettings.thickLineWidth, barHeight);
        }
        gc.setColor(this.viewSettings.textColor);
        if (this.viewSettings.showIntervalText && textX != -1) {
            textX = Math.max(textX, this.viewData.offsetX + this.viewSettings.thickLineWidth);
            String text = String.valueOf(interval.getRegNum()) + " " + interval.getOperand();
            gc.drawString(text, textX + 1, this.viewData.fontAscent + textY);
        }
    }

    public void drawIntervals(Graphics gc) {
        gc.setColor(this.viewSettings.textColor);
        int barHeight = this.viewSettings.rowHeight - this.viewSettings.barSeparation * 2 - 1;
        for (int i = 0; i < this.viewData.sizeRow; ++i) {
            Interval interval = (Interval)this.intervals.getIntervals().get(i + this.viewData.offsetRow);
            int textY = this.viewData.offsetY + i * this.viewSettings.rowHeight;
            int barY = textY + 1 + this.viewSettings.barSeparation;
            for (ChildInterval child : interval.getChildren()) {
                this.drawInterval(gc, child, barY, barHeight, textY);
            }
        }
    }

    private void drawSelection(Graphics gc) {
        gc.setColor(Color.RED);
        Dimension ca = this.getExtentSize();
        if (this.viewData.selectedCol != -1) {
            int x = this.viewData.colToX(this.viewData.selectedCol);
            gc.fillRect(x, 0, 3, ca.height);
        }
        if (this.viewData.selectedRow != -1) {
            int y = this.viewData.rowToY(this.viewData.selectedRow);
            gc.fillRect(0, y - 1, ca.width, 3);
        }
    }

    public void drawAll(Graphics gc) {
        gc.setColor(this.getBackground());
        gc.fillRect(0, 0, this.getWidth(), this.getHeight());
        gc.setFont(this.viewSettings.textFont);
        if (this.viewSettings.lightGridX > 0) {
            this.drawXGrid(gc, this.viewSettings.lightGridX, this.viewSettings.lightGridColor);
        }
        if (this.viewSettings.lightGridY > 0) {
            this.drawYGrid(gc, this.viewSettings.lightGridY, this.viewSettings.lightGridColor);
        }
        if (this.viewSettings.darkGridX > 0) {
            this.drawXGrid(gc, this.viewSettings.darkGridX, this.viewSettings.darkGridColor);
        }
        if (this.viewSettings.darkGridY > 0) {
            this.drawYGrid(gc, this.viewSettings.darkGridY, this.viewSettings.darkGridColor);
        }
        if (this.viewSettings.textGridX > 0) {
            this.drawXText(gc, this.viewSettings.textGridX, this.viewSettings.textColor);
        }
        if (this.viewSettings.textGridY > 0) {
            this.drawYText(gc, this.viewSettings.textGridY, this.viewSettings.textColor);
        }
        this.drawBorder(gc);
        this.drawBlocks(gc);
        this.drawIntervals(gc);
        this.drawSelection(gc);
    }

    @Override
    public void paint(Graphics g) {
        g.clearRect(0, 0, this.getSize().width, this.getSize().height);
        this.drawAll(g);
    }

    @Override
    protected void fireStateChanged() {
        this.calcViewData();
        super.fireStateChanged();
    }

    class ViewData {
        public int offsetCol;
        public int offsetRow;
        public int sizeCol;
        public int sizeRow;
        public int totalRow;
        public int totalCol;
        public int fontHeight;
        public int fontAscent;
        public int mouseX;
        public int mouseY;
        public int selectedCol;
        public int selectedRow;
        public int offsetX;
        public int offsetY;
        public int sizeX;
        public int sizeY;
        public Interval selectedInterval;
        public ChildInterval selectedChild;
        public BasicBlock selectedBlock;
        public IRInstruction selectedOperation;

        ViewData() {
        }

        public int colToX(int col) {
            return (col - this.offsetCol) * ((IntervalCanvas)IntervalCanvas.this).viewSettings.colWidth + this.offsetX;
        }

        public int rowToY(int row) {
            return (row - this.offsetRow) * ((IntervalCanvas)IntervalCanvas.this).viewSettings.rowHeight + this.offsetY;
        }
    }

    class PlaceHolder
    extends JComponent
    implements Scrollable {
        public PlaceHolder() {
            this.setEnabled(false);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            switch (orientation) {
                case 0: {
                    return 2 * ((IntervalCanvas)IntervalCanvas.this).viewSettings.colWidth;
                }
                case 1: {
                    return ((IntervalCanvas)IntervalCanvas.this).viewSettings.rowHeight;
                }
            }
            throw new RuntimeException("illegal orientation");
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            switch (orientation) {
                case 0: {
                    return ((IntervalCanvas)IntervalCanvas.this).viewSettings.colWidth * ((IntervalCanvas)IntervalCanvas.this).viewData.sizeCol * 3 / 8;
                }
                case 1: {
                    return ((IntervalCanvas)IntervalCanvas.this).viewSettings.rowHeight * ((IntervalCanvas)IntervalCanvas.this).viewData.sizeRow * 3 / 4;
                }
            }
            throw new RuntimeException("illegal orientation");
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

