/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.interval;

import at.ssw.visualizer.model.interval.ChildInterval;
import at.ssw.visualizer.model.interval.UsePosition;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class ViewSettings {
    public static final int SMALL = 0;
    public static final int MEDIUM = 1;
    public static final int LARGE = 2;
    private final int[] _colWidth = new int[]{2, 4, 8};
    private final int[] _lightGridX = new int[]{-1, 10, 2};
    private final int[] _darkGridX = new int[]{-1, -1, 10};
    private final int[] _textGridX = new int[]{40, 20, 10};
    private final int[] _thickLineWidth = new int[]{2, 2, 3};
    private final int[] _rowHeight = new int[]{3, 6, 14};
    private final int[] _lightGridY = new int[]{8, 4, 1};
    private final int[] _darkGridY = new int[]{-1, -1, 10};
    private final int[] _textGridY = new int[]{8, 4, 1};
    private final int[] _barSeparation = new int[]{0, 0, 1};
    private final boolean[][] _showIntervalText = new boolean[][]{{false, false, false}, {false, false, false}, {false, true, true}};
    private static final Color DEFAULT_INT_COLOR = new Color(255, 255, 102);
    public int hsize;
    public int vsize;
    public int colWidth;
    public int rowHeight;
    public int barSeparation;
    public int thickLineWidth;
    public int lightGridX;
    public int darkGridX;
    public int textGridX;
    public int lightGridY;
    public int darkGridY;
    public int textGridY;
    boolean showIntervalText;
    public Color lightGridColor = Color.GRAY;
    public Color darkGridColor = Color.DARK_GRAY;
    public Color blockGridColor = Color.DARK_GRAY;
    public Color textColor = Color.BLACK;
    public Font textFont;
    private Color usePosColorL = new Color(192, 64, 64);
    private Color usePosColorS = new Color(255, 0, 192);
    private Color usePosColorM = new Color(255, 0, 0);
    private Color usePosColorOther = new Color(0, 255, 255);
    private Map<String, Color> typeIntervalColors;
    private Color stackIntervalColor = new Color(255, 192, 64);

    public ViewSettings() {
        this.typeIntervalColors = new HashMap<String, Color>();
        this.typeIntervalColors.put("fixed", new Color(128, 128, 128));
        this.typeIntervalColors.put("object", new Color(192, 64, 255));
        this.typeIntervalColors.put("int", new Color(64, 192, 255));
        this.typeIntervalColors.put("long", new Color(0, 128, 255));
        this.typeIntervalColors.put("float", new Color(192, 255, 64));
        this.typeIntervalColors.put("double", new Color(128, 255, 0));
        this.typeIntervalColors.put("byte", new Color(192, 64, 255));
        this.typeIntervalColors.put("word", new Color(192, 64, 255));
        this.typeIntervalColors.put("dword", new Color(64, 192, 255));
        this.typeIntervalColors.put("qword", new Color(0, 128, 255));
        this.typeIntervalColors.put("single", new Color(192, 255, 64));
        this.typeIntervalColors.put("double", new Color(128, 255, 0));
        this.textFont = new Font("Dialog", 0, 11);
    }

    public void setHorizontalSize(int hsize) {
        this.hsize = hsize;
        this.update();
    }

    public void setVerticalSize(int vsize) {
        this.vsize = vsize;
        this.update();
    }

    private void update() {
        this.colWidth = this._colWidth[this.hsize];
        this.rowHeight = this._rowHeight[this.vsize];
        this.lightGridX = this._lightGridX[this.hsize];
        this.darkGridX = this._darkGridX[this.hsize];
        this.textGridX = this._textGridX[this.hsize];
        this.lightGridY = this._lightGridY[this.vsize];
        this.darkGridY = this._darkGridY[this.vsize];
        this.textGridY = this._textGridY[this.vsize];
        this.thickLineWidth = this._thickLineWidth[this.hsize];
        this.barSeparation = this._barSeparation[this.vsize];
        this.showIntervalText = this._showIntervalText[this.vsize][this.hsize];
    }

    public Color getIntervalColor(ChildInterval child) {
        if (child.getOperand().contains("stack")) {
            return this.stackIntervalColor;
        }
        String typeName = child.getType().toLowerCase();
        Color color = this.typeIntervalColors.get(typeName);
        if (color == null) {
            return DEFAULT_INT_COLOR;
        }
        return color;
    }

    public Color getUsePosColor(UsePosition usePos) {
        switch (usePos.getKind()) {
            case 'L': {
                return this.usePosColorL;
            }
            case 'S': {
                return this.usePosColorS;
            }
            case 'M': {
                return this.usePosColorM;
            }
        }
        return this.usePosColorOther;
    }
}

