/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.graphhelper;

import at.ssw.visualizer.graphhelper.DiGraph;
import at.ssw.visualizer.graphhelper.Edge;
import java.util.LinkedList;

public class Block {
    LinkedList<Integer> Latt = new LinkedList();
    LinkedList<Integer> Ratt = new LinkedList();
    LinkedList<Edge> Lseg = new LinkedList();
    LinkedList<Edge> Rseg = new LinkedList();

    public Block(Edge e, LinkedList<Integer> A) {
        this.Lseg.add(e);
        this.Latt = new LinkedList<Integer>(A);
        A.clear();
    }

    public void flip() {
        LinkedList<Integer> ha = this.Ratt;
        this.Ratt = this.Latt;
        this.Latt = ha;
        LinkedList<Edge> he = this.Rseg;
        this.Rseg = this.Lseg;
        this.Lseg = he;
    }

    public Integer headOfLatt() {
        return this.Latt.getFirst();
    }

    public boolean emptyLatt() {
        return this.Latt.isEmpty();
    }

    public Integer headOfRatt() {
        return this.Ratt.getFirst();
    }

    public boolean emptyRatt() {
        return this.Ratt.isEmpty();
    }

    public boolean leftInterlace(LinkedList<Block> S) {
        assert (!this.Latt.isEmpty());
        return !S.isEmpty() && !S.getFirst().emptyLatt() && this.Latt.getLast() < S.getFirst().headOfLatt();
    }

    public boolean rightInterlace(LinkedList<Block> S) {
        assert (!this.Latt.isEmpty());
        return !S.isEmpty() && !S.getFirst().emptyRatt() && this.Latt.getLast() < S.getFirst().headOfRatt();
    }

    public void combine(Block Bprime) {
        this.Latt.addAll(Bprime.Latt);
        this.Ratt.addAll(Bprime.Ratt);
        this.Lseg.addAll(Bprime.Lseg);
        this.Rseg.addAll(Bprime.Rseg);
    }

    public boolean clean(int dfsNumW) {
        while (!this.Latt.isEmpty() && this.Latt.getFirst() == dfsNumW) {
            this.Latt.removeFirst();
        }
        while (!this.Ratt.isEmpty() && this.Ratt.getFirst() == dfsNumW) {
            this.Ratt.removeFirst();
        }
        if (!this.Latt.isEmpty() || !this.Ratt.isEmpty()) {
            return false;
        }
        for (Edge e : this.Lseg) {
            ((DiGraph.PlanarityEdgePayload)e.data).alpha = 1;
        }
        for (Edge e : this.Rseg) {
            ((DiGraph.PlanarityEdgePayload)e.data).alpha = 2;
        }
        return true;
    }

    public void addToAtt(LinkedList<Integer> Att, int dfsnumW0) {
        if (!this.Ratt.isEmpty() && this.headOfRatt() > dfsnumW0) {
            this.flip();
        }
        Att.addAll(this.Latt);
        this.Latt.clear();
        Att.addAll(this.Ratt);
        this.Ratt.clear();
        for (Edge e : this.Lseg) {
            ((DiGraph.PlanarityEdgePayload)e.data).alpha = 1;
        }
        for (Edge e : this.Rseg) {
            ((DiGraph.PlanarityEdgePayload)e.data).alpha = 2;
        }
    }
}

