/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.graphhelper;

import at.ssw.visualizer.graphhelper.DiGraph;
import at.ssw.visualizer.graphhelper.Edge;
import at.ssw.visualizer.graphhelper.Node;
import java.util.Collection;
import java.util.LinkedList;

public class Embedding {
    private DiGraph graph;
    private LinkedList<Face> faces = new LinkedList();
    private Face infinityFace = null;

    public Embedding(DiGraph dg) {
        this.graph = dg;
        this.graph.breakBiDirection();
        Collection<Edge> edges = dg.getEdges();
        for (Edge e : edges) {
            e.data = new EdgePayload();
        }
        for (Edge e : edges) {
            EdgePayload payload;
            Face p;
            EdgePayload ep = (EdgePayload)e.data;
            if (ep.left == null) {
                p = new Face();
                this.createFace(e, e, p, true, true);
                for (Edge ed : p.edges) {
                    payload = (EdgePayload)ed.data;
                    if (payload.left == null) {
                        payload.left = p;
                        continue;
                    }
                    payload.right = p;
                }
                this.faces.add(p);
            }
            if (ep.right != null) continue;
            p = new Face();
            this.createFace(e, e, p, true, false);
            if (ep.left.equals(p)) {
                p = new Face();
                this.createFace(e, e, p, true, true);
            }
            for (Edge ed : p.edges) {
                payload = (EdgePayload)ed.data;
                if (payload.left == null) {
                    payload.left = p;
                    continue;
                }
                payload.right = p;
            }
            this.faces.add(p);
        }
        int max = 0;
        for (Face p : this.faces) {
            if (p.edges.size() <= max) continue;
            max = p.edges.size();
            this.infinityFace = p;
        }
    }

    private void createFace(Edge first, Edge e, Face p, boolean forward, boolean left) {
        Edge next;
        p.edges.add(e);
        Node n = forward ? e.destination : e.source;
        if (left) {
            int index = n.edges.indexOf(e);
            if (++index >= n.edges.size()) {
                index = 0;
            }
            next = n.edges.get(index);
        } else {
            int index = n.edges.indexOf(e);
            if (--index < 0) {
                index = n.edges.size() - 1;
            }
            next = n.edges.get(index);
        }
        boolean bl = forward = next.source == n;
        if (next == first) {
            Node no = forward ? next.destination : next.source;
            if (no.edges.size() == 1) {
                p.edges.add(next);
            }
            return;
        }
        this.createFace(first, next, p, forward, left);
    }

    public DiGraph getGraph() {
        return this.graph;
    }

    public LinkedList<Face> getFaces() {
        return this.faces;
    }

    public Face getInfinityFace() {
        return this.infinityFace;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n" + this.graph.toString() + "\n");
        int i = 0;
        for (Face p : this.faces) {
            buf.append(i + ": " + p.toString() + "\n");
            ++i;
        }
        buf.append("\n");
        for (Node n : this.graph.getNodes()) {
            buf.append(n.ID + " ");
            for (Edge e : n.edges) {
                buf.append("(" + e.source.ID + "," + e.destination.ID + ") ");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    void addFaceEdge(Face face, Node from, Node to) {
        if (face == null || from == null || to == null) {
            return;
        }
        assert (this.faces.contains(face));
        assert (face.getNodes().contains(from));
        assert (face.getNodes().contains(to));
        Edge lFrom = null;
        Edge rFrom = null;
        for (Edge e : face.edges) {
            if (e.source != from && e.destination != from) continue;
            if (lFrom == null) {
                lFrom = e;
                continue;
            }
            rFrom = e;
            break;
        }
        if (face.edges.indexOf(lFrom) > face.edges.indexOf(rFrom)) {
            Edge t = rFrom;
            rFrom = lFrom;
            lFrom = t;
        }
        LinkedList<Edge> rightPart = new LinkedList<Edge>();
        int index = face.edges.indexOf(rFrom);
        while (true) {
            Edge e = face.edges.get(index);
            rightPart.add(e);
            if (e.destination == to || e.source == to) break;
            index = (index + 1) % face.edges.size();
        }
        int prevIndex = index;
        LinkedList<Edge> leftPart = new LinkedList<Edge>();
        index = face.edges.indexOf(lFrom);
        while (index != prevIndex) {
            Edge e = face.edges.get(index);
            leftPart.add(e);
            if (--index >= 0) continue;
            index = face.edges.size() - 1;
        }
        Edge newedge = new Edge(from, to);
        this.graph.addEdge(newedge);
        leftPart.add(newedge);
        rightPart.add(newedge);
        face.edges = leftPart;
        Face newface = new Face();
        newface.edges = rightPart;
        this.faces.add(newface);
    }

    public class Face {
        public LinkedList<Edge> edges = new LinkedList();

        public boolean equals(Object o) {
            if (!(o instanceof Face)) {
                return false;
            }
            Face p = (Face)o;
            if (this.edges.size() != p.edges.size()) {
                return false;
            }
            for (Edge e : p.edges) {
                if (this.edges.contains(e)) continue;
                return false;
            }
            return true;
        }

        public Collection<Node> getNodes() {
            LinkedList<Node> n = new LinkedList<Node>();
            for (Edge e : this.edges) {
                n.add(e.source);
                n.add(e.destination);
            }
            return n;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (Edge e : this.edges) {
                buf.append("(" + e.source.ID + "," + e.destination.ID + "), ");
            }
            return buf.substring(0, buf.length() - 2);
        }
    }

    public class EdgePayload {
        public Face left = null;
        public Face right = null;
    }
}

