/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.core.selection;

import at.ssw.visualizer.core.selection.SelectionManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Selection {
    private Map<Class, Object> elements;
    private List<ChangeListener> listeners;
    private Timer eventTimer;
    private ActionListener eventTimerListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            Selection.this.doFireChangeEvent();
        }
    };

    public Selection() {
        this.elements = new HashMap<Class, Object>();
        this.listeners = new ArrayList<ChangeListener>();
        this.eventTimer = new Timer(100, this.eventTimerListener);
        this.eventTimer.setRepeats(false);
    }

    private void doPut(Class<?> clazz, Object element) {
        this.elements.put(clazz, element);
        for (Class<?> i : clazz.getInterfaces()) {
            this.doPut(i, element);
        }
    }

    public void put(Object element) {
        this.doPut(element.getClass(), element);
        this.fireChangeEvent();
        SelectionManager.getDefault().fireChangeEvent();
    }

    public <T> T get(Class<T> clazz) {
        return (T)this.elements.get(clazz);
    }

    protected void doFireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners.toArray(new ChangeListener[this.listeners.size()])) {
            listener.stateChanged(event);
        }
    }

    protected void fireChangeEvent() {
        this.eventTimer.restart();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }
}

