/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.bc.modelimpl;

import at.ssw.visualizer.bc.model.BytecodeModel;
import at.ssw.visualizer.bc.modelimpl.BytecodesParser;
import at.ssw.visualizer.model.CompilationElement;
import at.ssw.visualizer.model.bc.Bytecodes;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;

public class BytecodeModelImpl
implements BytecodeModel {
    private String[] classPaths;
    private Map<ControlFlowGraph, Bytecodes> loadedBytecodes;
    private static final String BLOCK_LIST_PREFIX = "BlockListBuilder ";

    public BytecodeModelImpl() {
        this.loadClassPaths();
        this.loadedBytecodes = Collections.synchronizedMap(new WeakHashMap());
    }

    private ControlFlowGraph getBlockListCFG(ControlFlowGraph cfg) {
        if (cfg.getBytecodes() != null) {
            return cfg;
        }
        if (cfg.getName().startsWith(BLOCK_LIST_PREFIX)) {
            return cfg;
        }
        ControlFlowGraph result = null;
        for (CompilationElement ce : cfg.getCompilation().getElements()) {
            if (!(ce instanceof ControlFlowGraph) || !ce.getName().startsWith(BLOCK_LIST_PREFIX)) continue;
            if (result == null) {
                result = (ControlFlowGraph)ce;
                if (result.getElements().size() <= 0) continue;
                return null;
            }
            return null;
        }
        return result;
    }

    private String getMethodName(ControlFlowGraph cfg) {
        assert (cfg.getName().startsWith(BLOCK_LIST_PREFIX));
        return cfg.getName().substring(BLOCK_LIST_PREFIX.length());
    }

    @Override
    public boolean hasBytecodes(ControlFlowGraph cfg) {
        return this.getBlockListCFG(cfg) != null;
    }

    @Override
    public String noBytecodesMsg(ControlFlowGraph cfg) {
        StringBuilder result = new StringBuilder();
        result.append("No bytecodes available for ").append(cfg.getCompilation().getName()).append(" - ").append(cfg.getName());
        if (!this.hasBytecodes(cfg)) {
            result.append("\nThe compiler inlined methods during compilation, so there is no single method to take the bytecodes from.");
        } else {
            result.append("\nThe method is not present in the classpath. Configure the claspath using Tools->Options.");
        }
        return result.toString();
    }

    @Override
    public Bytecodes getBytecodes(ControlFlowGraph cfg) {
        Bytecodes result = this.loadedBytecodes.get(cfg);
        if (result != null) {
            return result;
        }
        if ((cfg = this.getBlockListCFG(cfg)) == null) {
            return null;
        }
        if (cfg.getBytecodes() != null) {
            return cfg.getBytecodes();
        }
        String methodName = this.getMethodName(cfg);
        List<Bytecodes> mbcs = BytecodesParser.readMethod(cfg, methodName, this.classPaths);
        if (mbcs.size() == 0) {
            return null;
        }
        if (mbcs.size() == 1) {
            result = mbcs.get(0);
        } else {
            result = (Bytecodes)JOptionPane.showInputDialog(null, "Ambiguous methodname: \n" + methodName, "Select method", 3, null, mbcs.toArray(), mbcs.get(0));
            if (result == null) {
                return null;
            }
        }
        this.loadedBytecodes.put(cfg, result);
        return result;
    }

    private FileObject getOptionLocation() {
        return Repository.getDefault().getDefaultFileSystem().findResource("at-ssw-visualizer-bc/classpaths");
    }

    private void loadClassPaths() {
        ArrayList<String> data = new ArrayList<String>();
        try {
            InputStream stream = this.getOptionLocation().getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String cp = reader.readLine();
            while (cp != null) {
                data.add(cp);
                cp = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ex) {
            Logger log = Logger.getLogger(BytecodeModel.class.getName());
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.classPaths = data.size() > 0 ? data.toArray(new String[data.size()]) : this.getDefaultClassPaths();
    }

    private void saveClassPaths() {
        try {
            OutputStream stream = this.getOptionLocation().getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
            for (String cp : this.classPaths) {
                writer.write(cp);
                writer.newLine();
            }
            writer.close();
        }
        catch (IOException ex) {
            Logger log = Logger.getLogger(BytecodeModel.class.getName());
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public String[] getDefaultClassPaths() {
        return System.getProperty("sun.boot.class.path", "").split(System.getProperty("path.separator"));
    }

    public String[] getClassPaths() {
        return this.classPaths;
    }

    public void setClassPaths(String[] classPaths) {
        this.classPaths = classPaths;
        this.loadedBytecodes.clear();
        this.saveClassPaths();
    }
}

