/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.compilation.view;

import at.ssw.visualizer.compilation.view.CompilationModelNode;
import at.ssw.visualizer.compilation.view.action.OpenCompilationAction;
import at.ssw.visualizer.model.CompilationModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class CompilationViewTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    public static final String ACTIONS_COMPILATION = "at-ssw-visualizer-actions-compilation";
    public static final String ACTIONS_CFG = "at-ssw-visualizer-actions-cfg";
    public static final String ACTIONS_INTERVALS = "at-ssw-visualizer-actions-intervals";
    protected ExplorerManager manager;
    protected BeanTreeView view;
    protected CompilationModelNode rootNode;
    protected JToggleButton sortButton;
    protected JToggleButton filterButton;
    protected JToggleButton packageButton;
    private ActionListener configButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            Node[] selectedNodes = CompilationViewTopComponent.this.manager.getSelectedNodes();
            CompilationViewTopComponent.this.rootNode.doRefresh(CompilationViewTopComponent.this.sortButton.isSelected(), CompilationViewTopComponent.this.filterButton.isSelected(), !CompilationViewTopComponent.this.packageButton.isSelected());
            try {
                CompilationViewTopComponent.this.manager.setSelectedNodes(selectedNodes);
            }
            catch (PropertyVetoException ex) {
                throw new Error(ex);
            }
        }
    };
    private ActionListener collapseAllListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            for (Node n : CompilationViewTopComponent.this.rootNode.getChildren().getNodes()) {
                CompilationViewTopComponent.this.view.collapseNode(n);
            }
        }
    };
    private static final String PREFERRED_ID = "CompilationViewTopComponent";
    private static CompilationViewTopComponent instance;

    private CompilationViewTopComponent() {
        this.setName("Compiled Methods");
        this.setToolTipText("List of Compiled Methods");
        this.setIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/compilation/view/icons/compilations.gif"));
        this.manager = new ExplorerManager();
        this.view = new BeanTreeView();
        this.view.setRootVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.createToolbar(), "North");
        this.add((Component)this.view, "Center");
        CompilationModel model = (CompilationModel)Lookup.getDefault().lookup(CompilationModel.class);
        this.rootNode = new CompilationModelNode(model);
        this.manager.setRootContext((Node)this.rootNode);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)this.getActionMap()));
        this.configButtonListener.actionPerformed(null);
    }

    private Toolbar createToolbar() {
        ToolbarPool.getDefault().setPreferredIconSize(16);
        Toolbar toolBar = new Toolbar();
        toolBar.setBorder((Border)UIManager.get("Nb.Editor.Toolbar.border"));
        toolBar.add((Action)new OpenCompilationAction());
        toolBar.addSeparator();
        this.addElements((JToolBar)toolBar, Lookups.forPath((String)ACTIONS_COMPILATION).lookupAll(Action.class));
        toolBar.addSeparator();
        this.addElements((JToolBar)toolBar, Lookups.forPath((String)ACTIONS_CFG).lookupAll(Action.class));
        toolBar.addSeparator();
        this.addElements((JToolBar)toolBar, Lookups.forPath((String)ACTIONS_INTERVALS).lookupAll(Action.class));
        toolBar.addSeparator();
        this.sortButton = new JToggleButton(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/compilation/view/icons/sort.gif")), false);
        this.sortButton.setToolTipText("Sort List of Compilations");
        this.sortButton.addActionListener(this.configButtonListener);
        toolBar.add((Component)this.sortButton);
        this.filterButton = new JToggleButton(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/compilation/view/icons/filter.gif")), true);
        this.filterButton.addActionListener(this.configButtonListener);
        this.filterButton.setToolTipText("Filter Control Flow Graphs that have no IR (generated during bytecode parsing phase)");
        toolBar.add((Component)this.filterButton);
        this.packageButton = new JToggleButton(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/compilation/view/icons/package.gif")), false);
        this.packageButton.addActionListener(this.configButtonListener);
        this.packageButton.setToolTipText("Show Package Names");
        toolBar.add((Component)this.packageButton);
        toolBar.addSeparator();
        JButton collapseAllButton = new JButton(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/compilation/view/icons/collapseall.gif")));
        collapseAllButton.addActionListener(this.collapseAllListener);
        collapseAllButton.setToolTipText("Collapse All");
        toolBar.add((Component)collapseAllButton);
        return toolBar;
    }

    private void addElements(JToolBar toolBar, Collection<? extends Action> actions) {
        for (Action action : actions) {
            if (action instanceof Presenter.Toolbar) {
                toolBar.add(((Presenter.Toolbar)action).getToolbarPresenter());
                continue;
            }
            toolBar.add(action);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static synchronized CompilationViewTopComponent getDefault() {
        if (instance == null) {
            instance = new CompilationViewTopComponent();
        }
        return instance;
    }

    public static synchronized CompilationViewTopComponent findInstance() {
        return (CompilationViewTopComponent)WindowManager.getDefault().findTopComponent(PREFERRED_ID);
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return CompilationViewTopComponent.getDefault();
        }
    }
}

