/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.interval;

import at.ssw.visualizer.core.selection.Selection;
import at.ssw.visualizer.core.selection.SelectionManager;
import at.ssw.visualizer.core.selection.SelectionProvider;
import at.ssw.visualizer.interval.IntervalCanvas;
import at.ssw.visualizer.interval.ViewSettings;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.model.interval.ChildInterval;
import at.ssw.visualizer.model.interval.IntervalList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.Toolbar;
import org.openide.util.ImageUtilities;
import org.openide.windows.CloneableTopComponent;

public final class IntervalEditorTopComponent
extends CloneableTopComponent
implements SelectionProvider {
    private static final String HSIZE_PROP = "visualizer.hsize";
    private static final String VSIZE_PROP = "visualizer.vsize";
    private IntervalCanvas canvas;
    private ViewSettings viewSettings;
    private JToggleButton[] hsizeButtons;
    private JToggleButton[] vsizeButtons;
    private JLabel intervalStatusLabel;
    private JLabel blockStatusLabel;
    private JLabel instructionStatusLabel;
    private IntervalList intervals;
    private Selection selection;
    private boolean selectionUpdating;
    private ActionListener sizeButtonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            int i;
            Object vsize;
            Object hsize = ((JComponent)event.getSource()).getClientProperty(IntervalEditorTopComponent.HSIZE_PROP);
            if (hsize instanceof Integer) {
                IntervalEditorTopComponent.this.viewSettings.setHorizontalSize((Integer)hsize);
            }
            if ((vsize = ((JComponent)event.getSource()).getClientProperty(IntervalEditorTopComponent.VSIZE_PROP)) instanceof Integer) {
                IntervalEditorTopComponent.this.viewSettings.setVerticalSize((Integer)vsize);
            }
            IntervalEditorTopComponent.this.canvas.calcViewData();
            for (i = 0; i < IntervalEditorTopComponent.this.hsizeButtons.length; ++i) {
                IntervalEditorTopComponent.this.hsizeButtons[i].setSelected(((IntervalEditorTopComponent)IntervalEditorTopComponent.this).viewSettings.hsize == i);
            }
            for (i = 0; i < IntervalEditorTopComponent.this.vsizeButtons.length; ++i) {
                IntervalEditorTopComponent.this.vsizeButtons[i].setSelected(((IntervalEditorTopComponent)IntervalEditorTopComponent.this).viewSettings.vsize == i);
            }
        }
    };
    private ChangeListener selectionChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            if (IntervalEditorTopComponent.this.selectionUpdating) {
                return;
            }
            IntervalEditorTopComponent.this.selectionUpdating = true;
            IntervalEditorTopComponent.this.updateBlockSelection();
            IntervalEditorTopComponent.this.updateIntervalSelection();
            IntervalEditorTopComponent.this.selectionUpdating = false;
        }
    };

    protected IntervalEditorTopComponent(IntervalList intervals) {
        this.setName(intervals.getCompilation().getShortName());
        this.setToolTipText(intervals.getCompilation().getMethod() + " - " + intervals.getName());
        this.setIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/interval/icons/intervals.gif"));
        this.intervals = intervals;
        this.selection = new Selection();
        this.selection.put((Object)intervals);
        this.selection.put((Object)intervals.getControlFlowGraph());
        this.selection.addChangeListener(this.selectionChangeListener);
        this.viewSettings = new ViewSettings();
        this.canvas = new IntervalCanvas(this, this.viewSettings, intervals);
        JScrollPane scrollPane = new JScrollPane(this.canvas);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.hsizeButtons = new JToggleButton[3];
        this.hsizeButtons[0] = this.createSizeButton("at/ssw/visualizer/interval/icons/hsizesmall.gif", "Horizontal Size: Small", HSIZE_PROP, 0);
        this.hsizeButtons[1] = this.createSizeButton("at/ssw/visualizer/interval/icons/hsizemedium.gif", "Horizontal Size: Medium", HSIZE_PROP, 1);
        this.hsizeButtons[2] = this.createSizeButton("at/ssw/visualizer/interval/icons/hsizelarge.gif", "Horizontal Size: Large", HSIZE_PROP, 2);
        this.vsizeButtons = new JToggleButton[3];
        this.vsizeButtons[0] = this.createSizeButton("at/ssw/visualizer/interval/icons/vsizesmall.gif", "Vertical Size: Small", VSIZE_PROP, 0);
        this.vsizeButtons[1] = this.createSizeButton("at/ssw/visualizer/interval/icons/vsizemedium.gif", "Vertical Size: Medium", VSIZE_PROP, 1);
        this.vsizeButtons[2] = this.createSizeButton("at/ssw/visualizer/interval/icons/vsizelarge.gif", "Vertical Size: Large", VSIZE_PROP, 2);
        Toolbar toolbar = new Toolbar();
        toolbar.setBorder((Border)UIManager.get("Nb.Editor.Toolbar.border"));
        toolbar.add((Component)this.hsizeButtons[0]);
        toolbar.add((Component)this.hsizeButtons[1]);
        toolbar.add((Component)this.hsizeButtons[2]);
        toolbar.addSeparator();
        toolbar.add((Component)this.vsizeButtons[0]);
        toolbar.add((Component)this.vsizeButtons[1]);
        toolbar.add((Component)this.vsizeButtons[2]);
        this.intervalStatusLabel = this.createStatusLabel("Nb.Editor.Status.leftBorder", new Dimension(200, 18));
        this.instructionStatusLabel = this.createStatusLabel("Nb.Editor.Status.innerBorder", null);
        this.blockStatusLabel = this.createStatusLabel("Nb.Editor.Status.rightBorder", new Dimension(200, 18));
        JPanel statusBar = new JPanel(new BorderLayout());
        statusBar.add((Component)this.intervalStatusLabel, "West");
        statusBar.add((Component)this.blockStatusLabel, "East");
        statusBar.add((Component)this.instructionStatusLabel, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)toolbar, "North");
        this.add(scrollPane, "Center");
        this.add(statusBar, "South");
        this.hsizeButtons[2].doClick();
        this.vsizeButtons[2].doClick();
    }

    public Selection getSelection() {
        return this.selection;
    }

    private JToggleButton createSizeButton(String icon, String tooltip, String propName, int propValue) {
        JToggleButton button = new JToggleButton(new ImageIcon(ImageUtilities.loadImage((String)icon)));
        button.setToolTipText(tooltip);
        button.putClientProperty(propName, propValue);
        button.addActionListener(this.sizeButtonListener);
        return button;
    }

    private JLabel createStatusLabel(String border, Dimension dimension) {
        JLabel label = new JLabel(" ");
        label.setOpaque(true);
        label.setBorder((Border)UIManager.get(border));
        if (dimension != null) {
            label.setPreferredSize(dimension);
        }
        return label;
    }

    public void componentActivated() {
        super.componentActivated();
        this.canvas.requestFocus();
        SelectionManager.getDefault().setSelection(this.selection);
    }

    public void componentClosed() {
        super.componentClosed();
        SelectionManager.getDefault().removeSelection(this.selection);
    }

    private void updateBlockSelection() {
        assert (this.selection.get(ControlFlowGraph.class) == this.intervals.getControlFlowGraph());
        BasicBlock[] blocks = (BasicBlock[])this.selection.get(BasicBlock[].class);
        if (blocks == null || blocks.length == 0 || blocks.length == 1 && blocks[0] == this.canvas.getSelectedBlock()) {
            return;
        }
        int leftCol = Integer.MAX_VALUE;
        int rightCol = Integer.MIN_VALUE;
        for (BasicBlock block : blocks) {
            leftCol = Math.min(leftCol, block.getFirstLirId());
            rightCol = Math.max(rightCol, block.getLastLirId());
        }
        this.canvas.ensureColumnVisible(rightCol);
        this.canvas.ensureColumnVisible(leftCol);
    }

    private void updateIntervalSelection() {
        assert (this.selection.get(IntervalList.class) == this.intervals);
        ChildInterval child = (ChildInterval)this.selection.get(ChildInterval.class);
        if (child == null || child == this.canvas.getSelectedInterval()) {
            return;
        }
        this.canvas.ensureColumnVisible(child.getFrom());
        this.canvas.ensureRowVisible(this.intervals.getIntervals().indexOf(child.getParent()));
    }

    protected void updateCanvasSelection() {
        if (this.selectionUpdating) {
            return;
        }
        this.selectionUpdating = true;
        if (this.canvas.getSelectedBlock() != null) {
            this.selection.put((Object)new BasicBlock[]{this.canvas.getSelectedBlock()});
        }
        if (this.canvas.getSelectedInterval() != null) {
            this.selection.put((Object)this.canvas.getSelectedInterval());
        }
        this.selectionUpdating = false;
    }

    protected void setIntervalStatusText(String text) {
        this.intervalStatusLabel.setText(" " + text);
    }

    protected void setBlockStatusText(String text) {
        this.blockStatusLabel.setText(" " + text);
    }

    protected void setInstructionStatusText(String text) {
        this.instructionStatusLabel.setText(" " + text);
    }

    protected CloneableTopComponent createClonedObject() {
        return new IntervalEditorTopComponent(this.intervals);
    }

    public int getPersistenceType() {
        return 2;
    }
}

