/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.dataflow.editor;

import at.ssw.dataflow.layout.CompoundForceLayouter;
import at.ssw.dataflow.layout.CompoundHierarchicalNodesLayouter;
import at.ssw.dataflow.layout.ExternalGraphLayoutWrapper;
import at.ssw.dataflow.layout.ExternalGraphLayouter;
import at.ssw.dataflow.layout.ForceLayouter;
import at.ssw.dataflow.layout.HierarchicalNodesLayouter;
import at.ssw.dataflow.layout.MagneticSpringForceLayouter;
import at.ssw.dataflow.options.OptionEditor;
import at.ssw.dataflow.options.OptionProvider;
import at.ssw.graphanalyzer.positioning.HierarchicalLayoutManager;
import at.ssw.positionmanager.LayoutManager;
import at.ssw.visualizer.core.selection.Selection;
import at.ssw.visualizer.core.selection.SelectionManager;
import at.ssw.visualizer.core.selection.SelectionProvider;
import at.ssw.visualizer.dataflow.attributes.INodeAttribute;
import at.ssw.visualizer.dataflow.attributes.InvisibleNeighbourAttribute;
import at.ssw.visualizer.dataflow.attributes.TBExpandAllAttribute;
import at.ssw.visualizer.dataflow.attributes.TBShowBlockAttribute;
import at.ssw.visualizer.dataflow.graph.InscribeNodeWidget;
import at.ssw.visualizer.dataflow.graph.InstructionNodeGraphScene;
import at.ssw.visualizer.dataflow.graph.InstructionNodeWidget;
import at.ssw.visualizer.dataflow.graph.InstructionSceneListener;
import at.ssw.visualizer.dataflow.instructions.Instruction;
import at.ssw.visualizer.dataflow.instructions.InstructionSet;
import at.ssw.visualizer.dataflow.instructions.InstructionSetGenerator;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.model.cfg.IRInstruction;
import at.ssw.visualizer.model.cfg.State;
import at.ssw.visualizer.model.cfg.StateEntry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.netbeans.api.visual.widget.Widget;
import org.openide.awt.Toolbar;
import org.openide.util.ImageUtilities;
import org.openide.windows.CloneableTopComponent;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public final class DataFlowEditorTopComponent
extends CloneableTopComponent
implements SelectionProvider {
    private InstructionNodeGraphScene scene = null;
    private ControlFlowGraph cfg;
    private Selection selection;
    private boolean selectionUpdating;
    private BasicBlock[] curBlocks;
    private JButton BUTHideConstant;
    private JToggleButton BUTShowBlocks;
    private JToggleButton BUTExpandAll;
    private JButton BUTHideParameter;
    private JToggleButton BUTUseHierLayout;
    private JToggleButton BUTUseCompoundLayout;
    private JToggleButton BUTUseForceLayout;
    private JToggleButton BUTUseDirectedForceLayout;
    private JToggleButton BUTUseCompoundForceLayout;
    private JToggleButton BUTUseHighlightClustering;
    private JToggleButton BUTForceAutoLayout;
    private JToggleButton BUTClusterLinkGrayed;
    private JToggleButton BUTLayoutInvisibleNodes;
    private JToggleButton BUTClusterBorderVisible;
    private JToggleButton BUTUseNodeAnimation;
    private JToggleButton BUTUseCurrentNodePosition;
    private JButton BUTDoLayout;
    private JButton BUTLayoutOptions;
    private JButton BUTShowConstant;
    private JButton BUTShowParameter;
    private JButton BUTShowAll;
    private JButton BUTHideAll;
    private JButton BUTShowPhi;
    private JButton BUTHidePhi;
    private JButton BUTShowOperation;
    private JButton BUTHideOperation;
    private JButton BUTExportGraph;
    private JToggleButton BUTUseAdvancedHierLayout;
    private static final String ZOOMIN = "Zoom In";
    private static final String ZOOMOUT = "Zoom Out";
    private static final String HIDECONSTANT = "Hide Constants";
    private static final String SHOWBLOCKS = "Show Blocks";
    private static final String EXPANDALL = "Expand All";
    private static final String HIDEPARAMETER = "Hide Parameter";
    private static final String DOLAYOUT = "Do Layout";
    private static final String USEHIERLAYOUT = "Use Hierachical Layout";
    private static final String USECOMPLAYOUT = "Use Compound Layout";
    private static final String USEFORCELAYOUT = "Use Force Layout";
    private static final String USEDIRECTEDFORCELAYOUT = "Use Directed Force Layout";
    private static final String USECOMPOUNDFORCELAYOUT = "Use Compound Force Layout";
    private static final String USEHIGHLIGHTCLUSTERING = "Use Highlight Clustering";
    private static final String FORCEAUTOLAYOUT = "Force Auto Layout";
    private static final String CLUSTERLINKGRAYED = "Cluster Link Grayed";
    private static final String LAYOUTOPTIONS = "Layout Options...";
    private static final String LAYOUTINVISIBLENODES = "Layout Invisible Nodes";
    private static final String CLUSTERBORDERVISIBLE = "Cluster Border Visible";
    private static final String USENODEANIMATION = "Use Node Animation";
    private static final String USECURRENTNODEPOSITION = "The next layout cycle builds on the current node position";
    private static final String SHOWCONSTANT = "Show Constants";
    private static final String SHOWPARAMETER = "Show Parameter";
    private static final String SHOWALL = "Show All";
    private static final String HIDEALL = "Hide All";
    private static final String SHOWPHI = "Show Phi Functions";
    private static final String HIDEPHI = "Hide Phi Functions";
    private static final String SHOWOPERATION = "Show Operations";
    private static final String HIDEOPERATION = "Hide Operations";
    private static final String EXPORTGRAPH = "Export Graph To...";
    private static final String USEADVANCEDHIERLAYOUT = "Use Advanced Hierachical Layout";
    private CompoundHierarchicalNodesLayouter compoundLayouter;
    private HierarchicalNodesLayouter hierarchicalLayouter;
    private ForceLayouter forceLayouter;
    private CompoundForceLayouter compoundForceLayouter;
    private MagneticSpringForceLayouter directedForceLayouter;
    private ExternalGraphLayoutWrapper advancedhierarchicalLayouter;
    private static final String ICON_PATH = "at/ssw/visualizer/dataflow/icons/";
    private static final String ICON_ZOOMIN = "zoomin.gif";
    private static final String ICON_ZOOMOUT = "zoomout.gif";
    private static final String ICON_EDITOR = "dfg.gif";
    private static final String ICON_HIRACHICALLAYOUT = "arrangehier.gif";
    private static final String ICON_HIRACHICALLAYOUTADVANCED = "arrangehieradvanced.gif";
    private static final String ICON_FORCELAYOUT = "arrangeforce.gif";
    private static final String ICON_DIRECTEDFORCELAYOUT = "directedforce.gif";
    private static final String ICON_HIRACHICALLAYOUTCL = "arrangehiercluster.gif";
    private static final String ICON_FORCELAYOUTCL = "arrangeforcecluster.gif";
    private static final String ICON_EXPANDALL = "expall.gif";
    private static final String ICON_EXPANDBLOCKS = "expblocks.gif";
    private static final String ICON_OPTIONS = "options.gif";
    private static final String ICON_LAYOUT = "layout.gif";
    private static final String ICON_AUTOLAYOUT = "autolayout.gif";
    private static final String ICON_LAYOUTINV = "layoutinvisible.gif";
    private static final String ICON_ANIMATE = "animate.gif";
    private static final String ICON_CLUSTERHIGH = "clusterhigh.gif";
    private static final String ICON_LINKGRAY = "linkgrayed.gif";
    private static final String ICON_CLUSTERB = "cluster.gif";
    private static final String ICON_HIDEPARAM = "hideparam.gif";
    private static final String ICON_HIDECONSTANT = "hideconst.gif";
    private static final String ICON_SHOWPARAM = "showparam.gif";
    private static final String ICON_SHOWCONSTANT = "showconst.gif";
    private static final String ICON_HIDEALL = "hideall.gif";
    private static final String ICON_SHOWALL = "showall.gif";
    private static final String ICON_HIDEPHI = "hidephi.gif";
    private static final String ICON_SHOWPHI = "showphi.gif";
    private static final String ICON_HIDEOPERATION = "hideoperation.gif";
    private static final String ICON_SHOWOPERATION = "showoperation.gif";
    private static final String ICON_CURRENTNODE = "currentnode.gif";
    private static final String ICON_EXPORTGRAPH = "disk.gif";
    private JScrollPane scenePane;
    private ChangeListener selectionListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            if (DataFlowEditorTopComponent.this.selectionUpdating) {
                return;
            }
            DataFlowEditorTopComponent.this.selectionUpdating = true;
            Object[] newBlocks = (BasicBlock[])DataFlowEditorTopComponent.this.selection.get(BasicBlock[].class);
            if (newBlocks != null && newBlocks.length > 0 && !Arrays.equals(DataFlowEditorTopComponent.this.curBlocks, newBlocks)) {
                HashSet<Instruction> instructions = new HashSet<Instruction>();
                for (Object b : newBlocks) {
                    for (IRInstruction i : b.getHirInstructions()) {
                        InstructionNodeWidget nw = DataFlowEditorTopComponent.this.scene.getNodeWidget(i.getValue("tid"));
                        if (nw == null) continue;
                        instructions.add(nw.getInstruction());
                    }
                    for (State s : b.getStates()) {
                        for (StateEntry se : s.getEntries()) {
                            InstructionNodeWidget nw = DataFlowEditorTopComponent.this.scene.getNodeWidget(se.getName());
                            if (nw == null || b.getName() == null || !b.getName().equals(nw.getInstruction().getSourceBlock())) continue;
                            instructions.add(nw.getInstruction());
                        }
                    }
                }
                DataFlowEditorTopComponent.this.scene.setSelectedObjects(instructions);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
            }
            DataFlowEditorTopComponent.access$202(DataFlowEditorTopComponent.this, (BasicBlock[])newBlocks);
            DataFlowEditorTopComponent.this.selectionUpdating = false;
        }
    };
    private InstructionSceneListener instructionSceneListener = new InstructionSceneListener(){

        public void selectionChanged(Set<InstructionNodeWidget> w) {
            if (DataFlowEditorTopComponent.this.selectionUpdating) {
                return;
            }
            DataFlowEditorTopComponent.this.selectionUpdating = true;
            ArrayList<BasicBlock> newBlocks = new ArrayList<BasicBlock>();
            for (InstructionNodeWidget widget : w) {
                BasicBlock b;
                String name = widget.getInstruction().getSourceBlock();
                if (name == null || (b = DataFlowEditorTopComponent.this.cfg.getBasicBlockByName(name)) == null) continue;
                newBlocks.add(b);
            }
            DataFlowEditorTopComponent.access$202(DataFlowEditorTopComponent.this, newBlocks.toArray(new BasicBlock[newBlocks.size()]));
            DataFlowEditorTopComponent.this.selection.put((Object)DataFlowEditorTopComponent.this.curBlocks);
            DataFlowEditorTopComponent.this.selectionUpdating = false;
        }

        public void doubleClicked(InstructionNodeWidget w) {
        }

        public void updateNodeData() {
        }
    };

    public DataFlowEditorTopComponent(ControlFlowGraph cfg) {
        this.cfg = cfg;
        this.setIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/dfg.gif", (boolean)true));
        this.setName(cfg.getCompilation().getShortName());
        this.setToolTipText(cfg.getCompilation().getMethod() + " - " + cfg.getName());
        this.scene = new InstructionNodeGraphScene();
        this.scene.addInstructionSceneListener(this.instructionSceneListener);
        this.selection = new Selection();
        this.selection.put((Object)cfg);
        this.selection.put((Object)this.scene);
        this.selection.addChangeListener(this.selectionListener);
        this.scenePane = new JScrollPane(this.scene.createView());
        this.scenePane.setBorder(BorderFactory.createEmptyBorder());
        this.scenePane.setViewportBorder(BorderFactory.createEmptyBorder());
        JPanel scenePanel = new JPanel();
        scenePanel.setLayout(new BorderLayout());
        scenePanel.add((Component)this.scenePane, "Center");
        this.hierarchicalLayouter = new HierarchicalNodesLayouter();
        this.compoundLayouter = new CompoundHierarchicalNodesLayouter();
        this.forceLayouter = new ForceLayouter();
        this.compoundForceLayouter = new CompoundForceLayouter();
        this.directedForceLayouter = new MagneticSpringForceLayouter();
        this.advancedhierarchicalLayouter = new ExternalGraphLayoutWrapper((LayoutManager)new HierarchicalLayoutManager(HierarchicalLayoutManager.Combine.NONE), false, false, false);
        scenePanel.add((Component)this.createToolbar(), "North");
        this.setLayout(new BorderLayout());
        this.add(scenePanel, "Center");
    }

    public Selection getSelection() {
        return this.selection;
    }

    private void activateDataSource() {
        this.scene.validate();
        InstructionSet iset = InstructionSetGenerator.generateFromBlocks((List)this.cfg.getBasicBlocks());
        Instruction[] instructions = iset.getInstructions();
        instructions = InstructionSet.filterInstructionType((Instruction[])instructions, (Instruction.InstructionType)Instruction.InstructionType.CONTROLFLOW);
        this.scene.addInstructions(instructions);
        for (Instruction inst : instructions) {
            InscribeNodeWidget newW;
            InstructionNodeWidget widget;
            InstructionNodeWidget inw = this.scene.getNodeWidget(inst.getID());
            if (inst.getInstructionType() == Instruction.InstructionType.CONSTANT) {
                for (Instruction i : inst.getSuccessors()) {
                    widget = this.scene.getNodeWidget(i.getID());
                    if (widget == null) continue;
                    newW = new InscribeNodeWidget(inst, this.scene);
                    widget.addNodeAttribute((INodeAttribute)new InvisibleNeighbourAttribute((Widget)newW, inw, false));
                }
            }
            if (inst.getInstructionType() == Instruction.InstructionType.PARAMETER) {
                for (Instruction i : inst.getSuccessors()) {
                    widget = this.scene.getNodeWidget(i.getID());
                    if (widget == null) continue;
                    newW = new InscribeNodeWidget(inst, this.scene);
                    widget.addNodeAttribute((INodeAttribute)new InvisibleNeighbourAttribute((Widget)newW, inw, false));
                }
            }
            inw.addNodeAttribute((INodeAttribute)new TBShowBlockAttribute(this.BUTShowBlocks));
            inw.addNodeAttribute((INodeAttribute)new TBExpandAllAttribute(this.BUTExpandAll));
        }
        this.scene.setExternalLayouter((ExternalGraphLayouter)this.hierarchicalLayouter);
        this.scene.refreshAll();
        this.scene.layout();
        this.scene.validate();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.activateDataSource();
    }

    protected void componentActivated() {
        super.componentActivated();
        SelectionManager.getDefault().setSelection(this.selection);
    }

    protected void componentClosed() {
        super.componentClosed();
        SelectionManager.getDefault().removeSelection(this.selection);
    }

    public int getPersistenceType() {
        return 2;
    }

    protected CloneableTopComponent createClonedObject() {
        return new DataFlowEditorTopComponent(this.cfg);
    }

    private Toolbar createToolbar() {
        Toolbar toolBar = new Toolbar();
        toolBar.setBorder((Border)UIManager.get("Nb.Editor.Toolbar.border"));
        JButton zoomIn = new JButton();
        zoomIn.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/zoomin.gif", (boolean)true)));
        zoomIn.setToolTipText(ZOOMIN);
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.setZoomFactor(DataFlowEditorTopComponent.this.scene.getZoomFactor() * 1.2);
                DataFlowEditorTopComponent.this.scene.validate();
            }
        });
        JButton zoomOut = new JButton();
        zoomOut.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/zoomout.gif", (boolean)true)));
        zoomOut.setToolTipText(ZOOMOUT);
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.setZoomFactor(DataFlowEditorTopComponent.this.scene.getZoomFactor() / 1.2);
                DataFlowEditorTopComponent.this.scene.validate();
            }
        });
        this.BUTShowAll = new JButton();
        this.BUTShowAll.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/showall.gif", (boolean)true)));
        this.BUTShowAll.setToolTipText(SHOWALL);
        this.BUTShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.handleSetVisibilityNodeType(true, null);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTHideAll = new JButton();
        this.BUTHideAll.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/hideall.gif", (boolean)true)));
        this.BUTHideAll.setToolTipText(HIDEALL);
        this.BUTHideAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.handleSetVisibilityNodeType(false, null);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTHidePhi = new JButton();
        this.BUTHidePhi.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/hidephi.gif", (boolean)true)));
        this.BUTHidePhi.setToolTipText(HIDEPHI);
        this.BUTHidePhi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.handleSetVisibilityNodeType(false, Instruction.InstructionType.PHI);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTShowPhi = new JButton();
        this.BUTShowPhi.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/showphi.gif", (boolean)true)));
        this.BUTShowPhi.setToolTipText(SHOWPHI);
        this.BUTShowPhi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.handleSetVisibilityNodeType(true, Instruction.InstructionType.PHI);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTShowOperation = new JButton();
        this.BUTShowOperation.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/showoperation.gif", (boolean)true)));
        this.BUTShowOperation.setToolTipText(SHOWOPERATION);
        this.BUTShowOperation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.handleSetVisibilityNodeType(true, Instruction.InstructionType.OPERATION);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTHideOperation = new JButton();
        this.BUTHideOperation.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/hideoperation.gif", (boolean)true)));
        this.BUTHideOperation.setToolTipText(HIDEOPERATION);
        this.BUTHideOperation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.handleSetVisibilityNodeType(false, Instruction.InstructionType.OPERATION);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTShowConstant = new JButton();
        this.BUTShowConstant.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/showconst.gif", (boolean)true)));
        this.BUTShowConstant.setToolTipText(SHOWCONSTANT);
        this.BUTShowConstant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.handleSetVisibilityNodeType(true, Instruction.InstructionType.CONSTANT);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTShowParameter = new JButton();
        this.BUTShowParameter.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/showparam.gif", (boolean)true)));
        this.BUTShowParameter.setToolTipText(SHOWPARAMETER);
        this.BUTShowParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.handleSetVisibilityNodeType(true, Instruction.InstructionType.PARAMETER);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTHideConstant = new JButton();
        this.BUTHideConstant.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/hideconst.gif", (boolean)true)));
        this.BUTHideConstant.setToolTipText(HIDECONSTANT);
        this.BUTHideConstant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.handleSetVisibilityNodeType(false, Instruction.InstructionType.CONSTANT);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTShowBlocks = new JToggleButton();
        this.BUTShowBlocks.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/expblocks.gif", (boolean)true)));
        this.BUTShowBlocks.setToolTipText(SHOWBLOCKS);
        this.BUTShowBlocks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTExpandAll = new JToggleButton();
        this.BUTExpandAll.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/expall.gif", (boolean)true)));
        this.BUTExpandAll.setToolTipText(EXPANDALL);
        this.BUTExpandAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTHideParameter = new JButton();
        this.BUTHideParameter.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/hideparam.gif", (boolean)true)));
        this.BUTHideParameter.setToolTipText(HIDEPARAMETER);
        this.BUTHideParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.handleSetVisibilityNodeType(false, Instruction.InstructionType.PARAMETER);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.autoLayout();
            }
        });
        this.BUTDoLayout = new JButton();
        this.BUTDoLayout.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/layout.gif", (boolean)true)));
        this.BUTDoLayout.setToolTipText(DOLAYOUT);
        this.BUTDoLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.scene.layout();
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
            }
        });
        this.BUTLayoutOptions = new JButton();
        this.BUTLayoutOptions.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/options.gif", (boolean)true)));
        this.BUTLayoutOptions.setToolTipText(LAYOUTOPTIONS);
        this.BUTLayoutOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionEditor ed = new OptionEditor((OptionProvider)DataFlowEditorTopComponent.this.scene.getExternalLayouter());
                ed.setVisible(true);
                DataFlowEditorTopComponent.this.scene.refreshAll();
                DataFlowEditorTopComponent.this.scene.validate();
                DataFlowEditorTopComponent.this.scene.layout();
            }
        });
        this.BUTUseHierLayout = new JToggleButton();
        this.BUTUseHierLayout.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/arrangehier.gif", (boolean)true)));
        this.BUTUseHierLayout.setToolTipText(USEHIERLAYOUT);
        this.BUTUseHierLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.changeLayouter((JToggleButton)e.getSource());
            }
        });
        this.BUTUseHierLayout.setSelected(true);
        this.BUTUseAdvancedHierLayout = new JToggleButton();
        this.BUTUseAdvancedHierLayout.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/arrangehieradvanced.gif", (boolean)true)));
        this.BUTUseAdvancedHierLayout.setToolTipText(USEADVANCEDHIERLAYOUT);
        this.BUTUseAdvancedHierLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.changeLayouter((JToggleButton)e.getSource());
            }
        });
        this.BUTUseCompoundLayout = new JToggleButton();
        this.BUTUseCompoundLayout.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/arrangehiercluster.gif", (boolean)true)));
        this.BUTUseCompoundLayout.setToolTipText(USECOMPLAYOUT);
        this.BUTUseCompoundLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.changeLayouter((JToggleButton)e.getSource());
            }
        });
        this.BUTUseForceLayout = new JToggleButton();
        this.BUTUseForceLayout.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/arrangeforce.gif", (boolean)true)));
        this.BUTUseForceLayout.setToolTipText(USEFORCELAYOUT);
        this.BUTUseForceLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.changeLayouter((JToggleButton)e.getSource());
            }
        });
        this.BUTUseDirectedForceLayout = new JToggleButton();
        this.BUTUseDirectedForceLayout.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/directedforce.gif", (boolean)true)));
        this.BUTUseDirectedForceLayout.setToolTipText(USEDIRECTEDFORCELAYOUT);
        this.BUTUseDirectedForceLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.changeLayouter((JToggleButton)e.getSource());
            }
        });
        this.BUTUseCompoundForceLayout = new JToggleButton();
        this.BUTUseCompoundForceLayout.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/arrangeforcecluster.gif", (boolean)true)));
        this.BUTUseCompoundForceLayout.setToolTipText(USECOMPOUNDFORCELAYOUT);
        this.BUTUseCompoundForceLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataFlowEditorTopComponent.this.changeLayouter((JToggleButton)e.getSource());
            }
        });
        this.BUTUseHighlightClustering = new JToggleButton();
        this.BUTUseHighlightClustering.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/clusterhigh.gif", (boolean)true)));
        this.BUTUseHighlightClustering.setToolTipText(USEHIGHLIGHTCLUSTERING);
        this.BUTUseHighlightClustering.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = DataFlowEditorTopComponent.this.BUTUseHighlightClustering.isSelected();
                DataFlowEditorTopComponent.this.scene.setHighlightClustering(b);
                DataFlowEditorTopComponent.this.scene.layout();
            }
        });
        this.BUTUseHighlightClustering.setEnabled(false);
        this.BUTForceAutoLayout = new JToggleButton();
        this.BUTForceAutoLayout.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/autolayout.gif", (boolean)true)));
        this.BUTForceAutoLayout.setToolTipText(FORCEAUTOLAYOUT);
        this.BUTForceAutoLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = DataFlowEditorTopComponent.this.BUTForceAutoLayout.isSelected();
                DataFlowEditorTopComponent.this.scene.setAutoLayout(b);
            }
        });
        this.BUTForceAutoLayout.setSelected(this.scene.isAutoLayout());
        this.BUTClusterLinkGrayed = new JToggleButton();
        this.BUTClusterLinkGrayed.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/linkgrayed.gif", (boolean)true)));
        this.BUTClusterLinkGrayed.setToolTipText(CLUSTERLINKGRAYED);
        this.BUTClusterLinkGrayed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = DataFlowEditorTopComponent.this.BUTClusterLinkGrayed.isSelected();
                DataFlowEditorTopComponent.this.scene.setInterClusterLinkGrayed(b);
                DataFlowEditorTopComponent.this.scene.validate();
            }
        });
        this.BUTClusterLinkGrayed.setSelected(this.scene.isInterClusterLinkGrayed());
        this.BUTClusterLinkGrayed.setEnabled(false);
        this.BUTClusterBorderVisible = new JToggleButton();
        this.BUTClusterBorderVisible.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/cluster.gif", (boolean)true)));
        this.BUTClusterBorderVisible.setToolTipText(CLUSTERBORDERVISIBLE);
        this.BUTClusterBorderVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = DataFlowEditorTopComponent.this.BUTClusterBorderVisible.isSelected();
                DataFlowEditorTopComponent.this.scene.setClusterBordersVisible(b);
                DataFlowEditorTopComponent.this.scene.validate();
            }
        });
        this.BUTClusterBorderVisible.setSelected(this.scene.isClusterBordersVisible());
        this.BUTClusterBorderVisible.setEnabled(false);
        this.BUTLayoutInvisibleNodes = new JToggleButton();
        this.BUTLayoutInvisibleNodes.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/layoutinvisible.gif", (boolean)true)));
        this.BUTLayoutInvisibleNodes.setToolTipText(LAYOUTINVISIBLENODES);
        this.BUTLayoutInvisibleNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = DataFlowEditorTopComponent.this.BUTLayoutInvisibleNodes.isSelected();
                DataFlowEditorTopComponent.this.scene.setLayoutInvisibleNodes(b);
                DataFlowEditorTopComponent.this.scene.layout();
                DataFlowEditorTopComponent.this.scene.validate();
            }
        });
        this.BUTLayoutInvisibleNodes.setSelected(this.scene.isLayoutInvisibleNodes());
        this.BUTUseNodeAnimation = new JToggleButton();
        this.BUTUseNodeAnimation.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/animate.gif", (boolean)true)));
        this.BUTUseNodeAnimation.setToolTipText(USENODEANIMATION);
        this.BUTUseNodeAnimation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = DataFlowEditorTopComponent.this.BUTUseNodeAnimation.isSelected();
                DataFlowEditorTopComponent.this.scene.setNodeAnimation(b);
            }
        });
        this.BUTUseNodeAnimation.setSelected(this.scene.isNodeAnimation());
        this.BUTUseCurrentNodePosition = new JToggleButton();
        this.BUTUseCurrentNodePosition.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/currentnode.gif", (boolean)true)));
        this.BUTUseCurrentNodePosition.setToolTipText(USECURRENTNODEPOSITION);
        this.BUTUseCurrentNodePosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = DataFlowEditorTopComponent.this.BUTUseCurrentNodePosition.isSelected();
                DataFlowEditorTopComponent.this.scene.setUseCurrentNodePositions(b);
            }
        });
        this.BUTUseCurrentNodePosition.setSelected(this.scene.isUseCurrentNodePositions());
        this.BUTExportGraph = new JButton();
        this.BUTExportGraph.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"at/ssw/visualizer/dataflow/icons/disk.gif", (boolean)true)));
        this.BUTExportGraph.setToolTipText(EXPORTGRAPH);
        this.BUTExportGraph.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setAcceptAllFileFilterUsed(false);
                fc.setDialogTitle(DataFlowEditorTopComponent.EXPORTGRAPH);
                fc.addChoosableFileFilter(new SimpleFileFilter("Scaleable Vector Format (*.svg)", ".svg"));
                fc.addChoosableFileFilter(new SimpleFileFilter("Graph Modelling Language (*.gml)", ".gml"));
                fc.setMultiSelectionEnabled(false);
                fc.showSaveDialog(DataFlowEditorTopComponent.this.scenePane);
                if (fc.getSelectedFile() != null) {
                    File f;
                    SimpleFileFilter filter;
                    String fileName = fc.getSelectedFile().getAbsolutePath().toLowerCase();
                    if (!fileName.endsWith((filter = (SimpleFileFilter)fc.getFileFilter()).getFilter())) {
                        fileName = fileName + filter.getFilter();
                    }
                    if (fileName.endsWith("svg")) {
                        f = new File(fileName);
                        DOMImplementation dom = GenericDOMImplementation.getDOMImplementation();
                        Document document = dom.createDocument("http://www.w3.org/2000/svg", "svg", null);
                        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault(document);
                        ctx.setEmbeddedFontsOn(true);
                        SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, true);
                        DataFlowEditorTopComponent.this.scenePane.paint(svgGenerator);
                        FileOutputStream os = null;
                        try {
                            os = new FileOutputStream(f);
                            OutputStreamWriter out = new OutputStreamWriter((OutputStream)os, "UTF-8");
                            assert (svgGenerator instanceof SVGGraphics2D);
                            SVGGraphics2D svgGraphics = svgGenerator;
                            svgGraphics.stream(out, true);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    if (fileName.endsWith("gml")) {
                        try {
                            f = new File(fileName);
                            DataFlowEditorTopComponent.this.scene.exportToGMLFile(f);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        toolBar.add((Component)zoomIn);
        toolBar.add((Component)zoomOut);
        toolBar.addSeparator();
        toolBar.add((Component)this.BUTHideConstant);
        toolBar.add((Component)this.BUTHideParameter);
        toolBar.add((Component)this.BUTHidePhi);
        toolBar.add((Component)this.BUTHideOperation);
        toolBar.add((Component)this.BUTHideAll);
        toolBar.addSeparator();
        toolBar.add((Component)this.BUTShowConstant);
        toolBar.add((Component)this.BUTShowParameter);
        toolBar.add((Component)this.BUTShowPhi);
        toolBar.add((Component)this.BUTShowOperation);
        toolBar.add((Component)this.BUTShowAll);
        toolBar.addSeparator();
        toolBar.add((Component)this.BUTShowBlocks);
        toolBar.add((Component)this.BUTExpandAll);
        toolBar.addSeparator();
        toolBar.add((Component)this.BUTUseHierLayout);
        toolBar.add((Component)this.BUTUseCompoundLayout);
        toolBar.add((Component)this.BUTUseForceLayout);
        toolBar.add((Component)this.BUTUseDirectedForceLayout);
        toolBar.add((Component)this.BUTUseCompoundForceLayout);
        toolBar.addSeparator();
        toolBar.add((Component)this.BUTDoLayout);
        toolBar.add((Component)this.BUTForceAutoLayout);
        toolBar.add((Component)this.BUTUseCurrentNodePosition);
        toolBar.add((Component)this.BUTLayoutOptions);
        toolBar.add((Component)this.BUTLayoutInvisibleNodes);
        toolBar.add((Component)this.BUTUseNodeAnimation);
        toolBar.addSeparator();
        toolBar.add((Component)this.BUTUseHighlightClustering);
        toolBar.add((Component)this.BUTClusterLinkGrayed);
        toolBar.add((Component)this.BUTClusterBorderVisible);
        toolBar.addSeparator();
        toolBar.add((Component)this.BUTExportGraph);
        return toolBar;
    }

    private void changeLayouter(JToggleButton sender) {
        this.BUTUseHierLayout.setSelected(false);
        this.BUTUseCompoundLayout.setSelected(false);
        this.BUTUseForceLayout.setSelected(false);
        this.BUTUseCompoundForceLayout.setSelected(false);
        this.BUTUseDirectedForceLayout.setSelected(false);
        this.BUTUseAdvancedHierLayout.setSelected(false);
        sender.setSelected(true);
        if (sender == this.BUTUseHierLayout) {
            this.scene.setExternalLayouter((ExternalGraphLayouter)this.hierarchicalLayouter);
        }
        if (sender == this.BUTUseCompoundLayout) {
            this.scene.setExternalLayouter((ExternalGraphLayouter)this.compoundLayouter);
        }
        if (sender == this.BUTUseForceLayout) {
            this.scene.setExternalLayouter((ExternalGraphLayouter)this.forceLayouter);
        }
        if (sender == this.BUTUseCompoundForceLayout) {
            this.scene.setExternalLayouter((ExternalGraphLayouter)this.compoundForceLayouter);
        }
        if (sender == this.BUTUseAdvancedHierLayout) {
            this.scene.setExternalLayouter((ExternalGraphLayouter)this.advancedhierarchicalLayouter);
        }
        if (sender == this.BUTUseDirectedForceLayout) {
            this.scene.setExternalLayouter((ExternalGraphLayouter)this.directedForceLayouter);
        }
        boolean clustering = this.scene.getExternalLayouter().isClusteringSupported();
        this.BUTUseHighlightClustering.setEnabled(clustering);
        this.BUTClusterLinkGrayed.setEnabled(clustering);
        this.BUTClusterBorderVisible.setEnabled(clustering);
        this.scene.refreshAll();
        this.scene.layout();
        this.scene.validate();
    }

    static /* synthetic */ BasicBlock[] access$202(DataFlowEditorTopComponent x0, BasicBlock[] x1) {
        x0.curBlocks = x1;
        return x1;
    }

    class SimpleFileFilter
    extends FileFilter {
        private String desc = null;
        private String filter = null;

        public SimpleFileFilter(String desc, String filter) {
            this.filter = filter.toLowerCase();
            this.desc = desc;
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.getName().toLowerCase().endsWith(this.filter)) {
                return true;
            }
            return f.isDirectory();
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        public String getFilter() {
            return this.filter;
        }
    }
}

