/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.positionmanager.impl;

import at.ssw.positionmanager.LayoutGraph;
import at.ssw.positionmanager.Port;
import at.ssw.positionmanager.Vertex;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Set;

public class GraphPort
implements Port {
    private Vertex vertex;
    private LayoutGraph graph = null;

    public GraphPort(Vertex v) {
        this.vertex = v;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public void setLayoutGraph(LayoutGraph graph) {
        this.graph = graph;
    }

    public Point getRelativePosition() {
        Dimension d = this.vertex.getSize();
        int y = 0;
        int x = 0;
        if (this.graph == null) {
            return new Point(d.width / 2, d.height / 2);
        }
        Set ports = this.graph.getInputPorts(this.vertex);
        if (!ports.contains(this)) {
            ports = this.graph.getOutputPorts(this.vertex);
            y = d.height;
        }
        int offset = d.width / (ports.size() + 1);
        boolean found = false;
        for (Port p : ports) {
            x += offset;
            if (p != this) continue;
            found = true;
            break;
        }
        if (found) {
            return new Point(x, y);
        }
        return new Point(d.width / 2, d.height / 2);
    }
}

