/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.dataflow.graph;

import at.ssw.visualizer.dataflow.attributes.IAdditionalWidgetAttribute;
import at.ssw.visualizer.dataflow.attributes.IExpandNodeAttribute;
import at.ssw.visualizer.dataflow.attributes.IInvisibilityAttribute;
import at.ssw.visualizer.dataflow.attributes.INodeAttribute;
import at.ssw.visualizer.dataflow.attributes.IPathHighlightAttribute;
import at.ssw.visualizer.dataflow.attributes.IPopupContributorAttribute;
import at.ssw.visualizer.dataflow.graph.ClusterWidget;
import at.ssw.visualizer.dataflow.graph.HiddenNodesWidget;
import at.ssw.visualizer.dataflow.graph.InstructionNodeGraphScene;
import at.ssw.visualizer.dataflow.instructions.Instruction;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class InstructionNodeWidget
extends Widget {
    protected static final String DEFAULTFONT = "Arial-12";
    protected static final String ABBREV = "...";
    protected static final int MAXSTRINGLENGTH = 15;
    protected static final int MINSTRINGLENGTH = 7;
    private static Color colorParameter = new Color(255, 230, 200);
    private static Color colorParameterSelect = new Color(240, 180, 0);
    private static Color colorConstant = new Color(255, 200, 200);
    private static Color colorConstantSelect = new Color(240, 0, 0);
    private static Color colorPhi = new Color(200, 200, 255);
    private static Color colorPhiSelect = new Color(0, 0, 240);
    private static Color colorOperation = new Color(200, 255, 200);
    private static Color colorOperationSelect = new Color(0, 240, 0);
    private static Color colorControlFlow = new Color(210, 255, 255);
    private static Color colorControlFlowSelect = new Color(0, 240, 200);
    private static Color colorDefault = new Color(255, 255, 255);
    private static Color colorDefaultSelect = new Color(245, 245, 245);
    private static Color colorLine = Color.BLACK;
    private static Color colorHLLine = Color.GRAY;
    private Border selectedBorder;
    private Border selectedHLBorder;
    private Border border;
    private Border HLBorder;
    private Border emptyBorder;
    public static final int BORDERARC = 10;
    public static final int BORDERINSET = 5;
    private JPopupMenu popup;
    private static final String EXPANDINFLUENCE = "Expand Influenced Tree";
    private static final String EXPANDNODE = "Expand Node";
    private static final String EXPANDPARENTINFLUENCE = "Expand Parent Influence";
    private static final String EXPANDCYCLES = "Expand Cycles";
    private static final String ALL = "(All)";
    private static final String TOGGLEVISIBILITY = "Toggle Visibility";
    private static final String HIDEALLBUT = "Hide All But Current";
    private static final String SHOWINFLUENCE = "Show Influence Tree";
    private static final String SHOWPARENTINFLUENCE = "Show Parent Influence";
    private static final String SHOWCYCLES = "Show Cycles";
    private static final String SHOWPREDECESSORS = "Show Predecessors";
    private static final String SHOWSUCCESSORS = "Show Successors";
    private static final String CYCLEITEMSEPERATOR = "-";
    private static final char CYCLECMDSEPERATOR = '-';
    private static final String GOTOSUCCESSORS = "Go to Successor";
    private static final String GOTOPREDECESSOR = "Go to Predecessor";
    private static final String VISIBILITY = "Visibility";
    private LabelWidget lwID;
    private LabelWidget lwInstruction;
    private LabelWidget lwBlock;
    private Widget pred;
    private Widget suc;
    private Instruction instruction;
    private LinkedList<INodeAttribute> attributeList;
    private LinkedList<Widget> additionalWidgets;
    private boolean pathHighlighted = false;
    private Collection<InstructionNodeWidget[]> cycles = null;
    private ClusterWidget cluster;
    private boolean expanded = false;

    public InstructionNodeWidget(Instruction i, Scene s) {
        super(s);
        this.instruction = i;
        this.additionalWidgets = new LinkedList();
        this.attributeList = new LinkedList();
        this.popup = new JPopupMenu();
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)new PopupMenuProvider(){

            public JPopupMenu getPopupMenu(Widget widget, Point point) {
                return InstructionNodeWidget.this.getPopup();
            }
        }));
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.lwID = new LabelWidget(s, i.getID());
        this.lwID.setFont(Font.decode(DEFAULTFONT).deriveFont(1));
        this.addChild((Widget)this.lwID);
        this.lwID.resolveBounds(this.lwID.getLocation(), this.lwID.getPreferredBounds());
        this.lwInstruction = new LabelWidget(s, InstructionNodeWidget.modifiyStringLength(i.getInstructionString(), 7, 15, ABBREV));
        this.lwInstruction.setFont(Font.decode(DEFAULTFONT));
        this.lwInstruction.setAlignment(LabelWidget.Alignment.CENTER);
        this.addChild((Widget)this.lwInstruction);
        this.lwInstruction.resolveBounds(this.lwInstruction.getLocation(), this.lwInstruction.getPreferredBounds());
        this.lwBlock = new LabelWidget(s, i.getSourceBlock());
        this.lwBlock.setFont(Font.decode(DEFAULTFONT));
        this.addChild((Widget)this.lwBlock);
        this.lwBlock.resolveBounds(this.lwBlock.getLocation(), this.lwBlock.getPreferredBounds());
        this.pred = new HiddenNodesWidget(s, true);
        this.suc = new HiddenNodesWidget(s, false);
        this.setToolTipText(this.createToolTip());
        this.initWidgetBorders();
        this.setWidgetData();
    }

    protected static Color getColorByType(Instruction.InstructionType type, boolean selected) {
        switch (type) {
            case PARAMETER: {
                if (selected) {
                    return colorParameterSelect;
                }
                return colorParameter;
            }
            case CONSTANT: {
                if (selected) {
                    return colorConstantSelect;
                }
                return colorConstant;
            }
            case PHI: {
                if (selected) {
                    return colorPhiSelect;
                }
                return colorPhi;
            }
            case CONTROLFLOW: {
                if (selected) {
                    return colorControlFlowSelect;
                }
                return colorControlFlow;
            }
            case OPERATION: {
                if (selected) {
                    return colorOperationSelect;
                }
                return colorOperation;
            }
        }
        if (selected) {
            return colorDefaultSelect;
        }
        return colorDefault;
    }

    protected static Color getLineColor() {
        return colorLine;
    }

    private void initWidgetBorders() {
        Color c = InstructionNodeWidget.getColorByType(this.instruction.getInstructionType(), false);
        Color cs = InstructionNodeWidget.getColorByType(this.instruction.getInstructionType(), true);
        this.border = BorderFactory.createRoundedBorder((int)10, (int)10, (int)5, (int)5, (Color)c, (Color)colorLine);
        this.selectedBorder = BorderFactory.createRoundedBorder((int)10, (int)10, (int)5, (int)5, (Color)cs, (Color)colorLine);
        this.HLBorder = BorderFactory.createRoundedBorder((int)10, (int)10, (int)5, (int)5, (Color)c, (Color)colorHLLine);
        this.selectedHLBorder = BorderFactory.createRoundedBorder((int)10, (int)10, (int)5, (int)5, (Color)cs, (Color)colorHLLine);
        this.emptyBorder = BorderFactory.createEmptyBorder();
    }

    private void setWidgetData() {
        boolean visible = true;
        boolean showBlock = false;
        boolean showInstr = false;
        this.additionalWidgets.clear();
        this.pathHighlighted = false;
        Iterator iter = this.attributeList.iterator();
        while (iter.hasNext()) {
            INodeAttribute a = (INodeAttribute)iter.next();
            if (!a.validate()) {
                if (!a.removeable()) continue;
                iter.remove();
                continue;
            }
            if (a instanceof IInvisibilityAttribute) {
                visible = false;
            }
            if (a instanceof IExpandNodeAttribute) {
                if (((IExpandNodeAttribute)a).showBlock()) {
                    showBlock = true;
                }
                if (((IExpandNodeAttribute)a).showInstruction()) {
                    showInstr = true;
                }
            }
            if (a instanceof IPathHighlightAttribute) {
                this.pathHighlighted = true;
            }
            if (!(a instanceof IAdditionalWidgetAttribute)) continue;
            this.additionalWidgets.add(((IAdditionalWidgetAttribute)a).getWidget());
        }
        this.removeChildren();
        if (visible) {
            InstructionNodeWidget w;
            InstructionNodeGraphScene s = (InstructionNodeGraphScene)this.getScene();
            for (Instruction i : this.instruction.getPredecessors()) {
                w = s.getNodeWidget(i.getID());
                if (w == null || w.isWidgetVisible()) continue;
                this.addChild(this.pred);
                break;
            }
            this.expanded = false;
            this.addChild((Widget)this.lwID);
            if (showInstr) {
                this.addChild((Widget)this.lwInstruction);
                this.expanded = true;
            }
            if (showBlock) {
                this.addChild((Widget)this.lwBlock);
                this.expanded = true;
            }
            if (showInstr) {
                Iterator iterator = this.additionalWidgets.iterator();
                while (iterator.hasNext()) {
                    this.addChild((Widget)iterator.next());
                }
            }
            for (Instruction i : this.instruction.getSuccessors()) {
                w = s.getNodeWidget(i.getID());
                if (w == null || w.isWidgetVisible()) continue;
                this.addChild(this.suc);
                break;
            }
        }
        this.setWidgetBorder();
        this.resolveBounds(this.getLocation(), this.calculatePreferredBounds());
    }

    private Rectangle calculatePreferredBounds() {
        Insets insets = this.border.getInsets();
        Rectangle clientArea = this.calculateClientArea();
        for (Widget child : this.getChildren()) {
            Point location = child.getLocation();
            Rectangle bounds = child.getPreferredBounds();
            bounds.translate(location.x, location.y);
            clientArea.add(bounds);
        }
        clientArea.x -= insets.left;
        clientArea.y -= insets.top;
        clientArea.width += insets.left + insets.right;
        clientArea.height += insets.top + insets.bottom;
        return clientArea;
    }

    private void setWidgetBorder() {
        if (this.isWidgetVisible()) {
            if (this.getState().isHovered()) {
                if (this.getState().isSelected()) {
                    this.setBorder(this.selectedHLBorder);
                } else {
                    this.setBorder(this.HLBorder);
                }
                this.lwID.setForeground(colorHLLine);
                this.lwInstruction.setForeground(colorHLLine);
                this.lwBlock.setForeground(colorHLLine);
            } else {
                if (this.getState().isSelected()) {
                    this.setBorder(this.selectedBorder);
                } else {
                    this.setBorder(this.border);
                }
                this.lwID.setForeground(colorLine);
                this.lwInstruction.setForeground(colorLine);
                this.lwBlock.setForeground(colorLine);
            }
        } else {
            this.setBorder(this.emptyBorder);
        }
    }

    protected static String modifiyStringLength(String in, int min, int max, String abbrev) {
        StringBuffer mod = in == null ? new StringBuffer("") : new StringBuffer(in);
        if (mod.length() < min) {
            for (int i = mod.length(); i < min; ++i) {
                mod.append(' ');
            }
        } else if (mod.length() > max) {
            mod = new StringBuffer(mod.substring(0, max - abbrev.length()) + abbrev);
        }
        return mod.toString();
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    protected void paintWidget() {
        this.setWidgetBorder();
        super.paintWidget();
    }

    public boolean isWidgetVisible() {
        for (INodeAttribute a : this.attributeList) {
            if (!(a instanceof IInvisibilityAttribute) || !a.validate()) continue;
            return false;
        }
        return true;
    }

    public void makeVisible() {
        for (INodeAttribute att : this.attributeList.toArray(new INodeAttribute[this.attributeList.size()])) {
            if (!(att instanceof IInvisibilityAttribute) || !att.removeable()) continue;
            this.attributeList.remove(att);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void addNodeAttribute(INodeAttribute a) {
        if (a != null) {
            this.attributeList.add(a);
        }
    }

    protected void refresh() {
        this.setWidgetData();
        this.revalidate();
    }

    private void rebuildPopupMenu() {
        StringBuffer st;
        JMenuItem item;
        this.popup.removeAll();
        JMenu menu = new JMenu(GOTOPREDECESSOR);
        if (this.instruction.getPredecessors().length == 0) {
            menu.setEnabled(false);
        } else {
            for (Instruction i : this.instruction.getPredecessors()) {
                item = new JMenuItem(i.getID());
                item.setActionCommand(i.getID());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InstructionNodeGraphScene s = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                        s.setSingleSelectedWidget(e.getActionCommand(), true);
                        s.edit(s.getNodeWidget(e.getActionCommand()));
                    }
                });
                menu.add(item);
            }
        }
        this.popup.add(menu);
        menu = new JMenu(GOTOSUCCESSORS);
        if (this.instruction.getSuccessors().length == 0) {
            menu.setEnabled(false);
        } else {
            for (Instruction i : this.instruction.getSuccessors()) {
                item = new JMenuItem(i.getID());
                item.setActionCommand(i.getID());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InstructionNodeGraphScene s = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                        s.setSingleSelectedWidget(e.getActionCommand(), true);
                        s.edit(s.getNodeWidget(e.getActionCommand()));
                    }
                });
                menu.add(item);
            }
        }
        this.popup.add(menu);
        this.popup.addSeparator();
        item = new JMenuItem(EXPANDNODE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Scene s = InstructionNodeWidget.this.getScene();
                if (s instanceof InstructionNodeGraphScene) {
                    ((InstructionNodeGraphScene)s).handleExpandNode(InstructionNodeWidget.this.instruction);
                }
            }
        });
        this.popup.add(item);
        item = new JMenuItem(EXPANDINFLUENCE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Scene s = InstructionNodeWidget.this.getScene();
                if (s instanceof InstructionNodeGraphScene) {
                    ((InstructionNodeGraphScene)s).handleExpandInfluenceTree(InstructionNodeWidget.this.instruction, true);
                }
            }
        });
        this.popup.add(item);
        item.setEnabled(this.instruction.getSuccessors().length > 0);
        item = new JMenuItem(EXPANDPARENTINFLUENCE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Scene s = InstructionNodeWidget.this.getScene();
                if (s instanceof InstructionNodeGraphScene) {
                    ((InstructionNodeGraphScene)s).handleExpandInfluenceTree(InstructionNodeWidget.this.instruction, false);
                }
            }
        });
        this.popup.add(item);
        item.setEnabled(this.instruction.getPredecessors().length > 0);
        menu = new JMenu(EXPANDCYCLES);
        if (this.cycles == null || this.cycles.size() == 0) {
            menu.setEnabled(false);
        } else {
            item = new JMenuItem(ALL);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Scene s = InstructionNodeWidget.this.getScene();
                    if (s instanceof InstructionNodeGraphScene) {
                        ((InstructionNodeGraphScene)s).handleExpandCycles(InstructionNodeWidget.this.getID());
                    }
                }
            });
            menu.add(item);
            int i = 0;
            for (InstructionNodeWidget[] nw : this.cycles) {
                st = new StringBuffer();
                for (InstructionNodeWidget n : nw) {
                    st.append(n.getID());
                    st.append(CYCLEITEMSEPERATOR);
                }
                st.setLength(st.length() - CYCLEITEMSEPERATOR.length());
                item = new JMenuItem(st.toString());
                item.setActionCommand(this.getID() + '-' + String.valueOf(i));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InstructionNodeGraphScene s = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                        String com = e.getActionCommand();
                        int index = com.indexOf(45);
                        if (index != -1) {
                            try {
                                s.handleExpandCycle(com.substring(0, index), Integer.parseInt(com.substring(index + 1)));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                menu.add(item);
                ++i;
            }
        }
        this.popup.add(menu);
        this.popup.addSeparator();
        item = new JMenuItem(TOGGLEVISIBILITY);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstructionNodeGraphScene s = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                s.handleToggleVisibility(InstructionNodeWidget.this.instruction, true);
            }
        });
        this.popup.add(item);
        item = new JMenuItem(HIDEALLBUT);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstructionNodeGraphScene s = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                s.handleHideAllBut(InstructionNodeWidget.this.instruction);
            }
        });
        this.popup.add(item);
        item = new JMenuItem(SHOWINFLUENCE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstructionNodeGraphScene s = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                s.handleMakeTreeVisible(InstructionNodeWidget.this.instruction, true);
            }
        });
        this.popup.add(item);
        item.setEnabled(this.instruction.getSuccessors().length > 0);
        item = new JMenuItem(SHOWPARENTINFLUENCE);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstructionNodeGraphScene s = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                s.handleMakeTreeVisible(InstructionNodeWidget.this.instruction, false);
            }
        });
        this.popup.add(item);
        item.setEnabled(this.instruction.getPredecessors().length > 0);
        menu = new JMenu(SHOWCYCLES);
        if (this.cycles == null || this.cycles.size() == 0) {
            menu.setEnabled(false);
        } else {
            item = new JMenuItem(ALL);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Scene s = InstructionNodeWidget.this.getScene();
                    if (s instanceof InstructionNodeGraphScene) {
                        ((InstructionNodeGraphScene)s).handleMakeCycleVisible(InstructionNodeWidget.this.getID(), -1);
                    }
                }
            });
            menu.add(item);
            int i = 0;
            for (InstructionNodeWidget[] nw : this.cycles) {
                st = new StringBuffer();
                for (InstructionNodeWidget n : nw) {
                    st.append(n.getID());
                    st.append(CYCLEITEMSEPERATOR);
                }
                st.setLength(st.length() - CYCLEITEMSEPERATOR.length());
                item = new JMenuItem(st.toString());
                item.setActionCommand(this.getID() + '-' + String.valueOf(i));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InstructionNodeGraphScene s = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                        String com = e.getActionCommand();
                        int index = com.indexOf(45);
                        if (index != -1) {
                            try {
                                s.handleMakeCycleVisible(com.substring(0, index), Integer.parseInt(com.substring(index + 1)));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                menu.add(item);
                ++i;
            }
        }
        this.popup.add(menu);
        menu = new JMenu(SHOWPREDECESSORS);
        LinkedList<InstructionNodeWidget> list = new LinkedList<InstructionNodeWidget>();
        InstructionNodeGraphScene s = (InstructionNodeGraphScene)this.getScene();
        for (Instruction i : this.instruction.getPredecessors()) {
            InstructionNodeWidget w = s.getNodeWidget(i.getID());
            if (w == null || w.isWidgetVisible()) continue;
            list.add(w);
        }
        if (list.size() > 0) {
            item = new JMenuItem(ALL);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstructionNodeGraphScene scene = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                    scene.handleShowNodes(InstructionNodeWidget.this.getInstruction().getPredecessors());
                }
            });
            menu.add(item);
            for (InstructionNodeWidget w : list) {
                item = new JMenuItem(w.getID());
                item.setActionCommand(w.getID());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InstructionNodeGraphScene scene = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                        InstructionNodeWidget nw = scene.getNodeWidget(e.getActionCommand());
                        if (nw != null) {
                            Instruction[] inst = new Instruction[]{nw.getInstruction()};
                            scene.handleShowNodes(inst);
                        }
                    }
                });
                menu.add(item);
            }
        } else {
            menu.setEnabled(false);
        }
        this.popup.add(menu);
        menu = new JMenu(SHOWSUCCESSORS);
        list = new LinkedList();
        for (Instruction i : this.instruction.getSuccessors()) {
            InstructionNodeWidget w = s.getNodeWidget(i.getID());
            if (w == null || w.isWidgetVisible()) continue;
            list.add(w);
        }
        if (list.size() > 0) {
            item = new JMenuItem(ALL);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstructionNodeGraphScene scene = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                    scene.handleShowNodes(InstructionNodeWidget.this.getInstruction().getSuccessors());
                }
            });
            menu.add(item);
            for (InstructionNodeWidget w : list) {
                item = new JMenuItem(w.getID());
                item.setActionCommand(w.getID());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InstructionNodeGraphScene scene = (InstructionNodeGraphScene)InstructionNodeWidget.this.getScene();
                        InstructionNodeWidget nw = scene.getNodeWidget(e.getActionCommand());
                        if (nw != null) {
                            Instruction[] inst = new Instruction[]{nw.getInstruction()};
                            scene.handleShowNodes(inst);
                        }
                    }
                });
                menu.add(item);
            }
        } else {
            menu.setEnabled(false);
        }
        this.popup.add(menu);
        boolean first = true;
        for (INodeAttribute a : this.attributeList) {
            if (!(a instanceof IPopupContributorAttribute) || !a.validate()) continue;
            item = ((IPopupContributorAttribute)a).getMenuItem();
            if (first) {
                this.popup.addSeparator();
                first = false;
            }
            this.popup.add(item);
        }
    }

    public boolean isPathHighlighted() {
        return this.pathHighlighted;
    }

    public String getID() {
        return this.instruction.getID();
    }

    public void setCycles(Collection<InstructionNodeWidget[]> cycles) {
        this.cycles = cycles;
        this.setToolTipText(this.createToolTip());
    }

    public Collection<InstructionNodeWidget[]> getCycleWidgets() {
        return this.cycles;
    }

    public void setClusterWidget(ClusterWidget w) {
        this.cluster = w;
    }

    public ClusterWidget getClusterWidget() {
        return this.cluster;
    }

    protected String createToolTip() {
        StringBuffer ret = new StringBuffer();
        ret.append("<html><b>Name: </b>" + this.instruction.getID() + "<p>");
        ret.append("<b>Instruction: </b>" + this.instruction.getInstructionString() + "<p>");
        if (this.cycles != null && this.cycles.size() > 0) {
            ret.append("<b>Cycles:</b>");
            for (InstructionNodeWidget[] a : this.cycles) {
                ret.append("<p> * ");
                for (InstructionNodeWidget w : a) {
                    ret.append(w.getID());
                    ret.append(" ");
                }
            }
        }
        ret.append("</html>");
        return ret.toString();
    }

    public JPopupMenu getPopup() {
        this.rebuildPopupMenu();
        return this.popup;
    }
}

