/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.dataflow.view;

import at.ssw.visualizer.dataflow.graph.ClusterWidget;
import at.ssw.visualizer.dataflow.graph.InstructionNodeGraphScene;
import at.ssw.visualizer.dataflow.graph.InstructionNodeWidget;
import at.ssw.visualizer.dataflow.instructions.Instruction;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;

public class DataflowTableModel
extends AbstractTableModel {
    public static final int COLUMN_VISIBLE = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_BLOCK = 2;
    public static final int COLUMN_TYPE = 3;
    public static final int COLUMN_STATEMENT = 4;
    public static final int COLUMN_SUCC = 5;
    public static final int COLUMN_PRED = 6;
    public static final int COLUMN_CLUSTER = 7;
    public static final String[] COLUMN_NAMES = new String[]{"Visible", "Name", "Block", "Type", "Statement", "Successors", "Predecessors", "Cluster"};
    public static final int[] COLUMN_WIDTHS = new int[]{60, 60, 60, 60, 200, 120, 120, 60};
    private InstructionNodeWidget[] widgets = null;

    public void setDataSource(InstructionNodeGraphScene scene) {
        this.widgets = scene == null ? null : scene.getNodeWidgets();
        this.fireTableDataChanged();
    }

    public void sort(final int column) {
        if (this.widgets == null) {
            return;
        }
        Arrays.sort(this.widgets, new Comparator<InstructionNodeWidget>(){

            @Override
            public int compare(InstructionNodeWidget w1, InstructionNodeWidget w2) {
                String s1 = DataflowTableModel.this.getValue(w1, column).toString();
                String s2 = DataflowTableModel.this.getValue(w2, column).toString();
                if ((column == 1 || column == 2 || column == 7) && s1.length() > 1 && s2.length() > 1) {
                    s1 = s1.substring(1);
                    s2 = s2.substring(1);
                    try {
                        int i1 = Integer.valueOf(s1);
                        int i2 = Integer.valueOf(s2);
                        return i1 - i2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return s1.compareTo(s2);
            }
        });
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.widgets == null ? 0 : this.widgets.length;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.getValue(this.widgets[row], column);
    }

    protected Object getValue(InstructionNodeWidget nw, int column) {
        Instruction inst = nw.getInstruction();
        ClusterWidget cw = nw.getClusterWidget();
        if (inst == null) {
            return "";
        }
        switch (column) {
            case 0: {
                return nw.isWidgetVisible();
            }
            case 1: {
                return nw.getID();
            }
            case 2: {
                return inst.getSourceBlock();
            }
            case 3: {
                return this.getTypeString(inst.getInstructionType());
            }
            case 4: {
                return inst.getInstructionString();
            }
            case 5: {
                return this.getIDString(inst.getSuccessors());
            }
            case 6: {
                return this.getIDString(inst.getPredecessors());
            }
            case 7: {
                return cw == null ? "" : cw.getId();
            }
        }
        throw new Error("invalid column");
    }

    private String getTypeString(Instruction.InstructionType type) {
        switch (type) {
            case CONSTANT: {
                return "constant";
            }
            case CONTROLFLOW: {
                return "control flow";
            }
            case OPERATION: {
                return "operation";
            }
            case PARAMETER: {
                return "parameter";
            }
            case PHI: {
                return "phi";
            }
        }
        return "undefined";
    }

    private String getIDString(Instruction[] instructions) {
        if (instructions == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Instruction instruction : instructions) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(instruction.getID());
        }
        return sb.toString();
    }

    public InstructionNodeWidget getWidgetAtRow(int row) {
        if (this.widgets != null && row < this.widgets.length) {
            return this.widgets[row];
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && this.widgets != null && rowIndex < this.widgets.length) {
            InstructionNodeGraphScene s = (InstructionNodeGraphScene)this.widgets[rowIndex].getScene();
            s.handleToggleVisibility(this.widgets[rowIndex].getInstruction(), false);
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }
}

