/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.bc.options;

import at.ssw.visualizer.bc.model.BytecodeModel;
import at.ssw.visualizer.bc.modelimpl.BytecodeModelImpl;
import at.ssw.visualizer.bc.options.BCOptionsPanelController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;

final class BCOptionPanel
extends JPanel {
    private final BCOptionsPanelController controller;
    private final BytecodeModelImpl bytecodeModel;
    private final DefaultListModel listModel;
    private JButton addDefaultClasspath;
    private JButton addJarZipButton;
    private JButton addPathButton;
    private JList classpathList;
    private JScrollPane classpathScrollPane;
    private JButton removeButton;

    public BCOptionPanel(BCOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.bytecodeModel = (BytecodeModelImpl)Lookup.getDefault().lookup(BytecodeModel.class);
        this.listModel = new DefaultListModel();
        this.classpathList.setModel(this.listModel);
    }

    private void initComponents() {
        this.classpathScrollPane = new JScrollPane();
        this.classpathList = new JList();
        this.addPathButton = new JButton();
        this.removeButton = new JButton();
        this.addJarZipButton = new JButton();
        this.addDefaultClasspath = new JButton();
        this.classpathList.setSelectionMode(0);
        this.classpathScrollPane.setViewportView(this.classpathList);
        Mnemonics.setLocalizedText((AbstractButton)this.addPathButton, (String)"Add folder");
        this.addPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BCOptionPanel.this.addPathButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)"Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BCOptionPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addJarZipButton, (String)"Add Jar/Zip file");
        this.addJarZipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BCOptionPanel.this.addJarZipButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addDefaultClasspath, (String)"Add default classpath");
        this.addDefaultClasspath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BCOptionPanel.this.addDefaultClasspathActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.classpathScrollPane, -1, 309, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.addJarZipButton, -1, -1, Short.MAX_VALUE).addComponent(this.addDefaultClasspath, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE).addComponent(this.addPathButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.addDefaultClasspath, this.addJarZipButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addPathButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addJarZipButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addDefaultClasspath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton)).addComponent(this.classpathScrollPane, -1, 202, Short.MAX_VALUE)).addContainerGap()));
    }

    private void addDefaultClasspathActionPerformed(ActionEvent evt) {
        for (String cp : this.bytecodeModel.getDefaultClassPaths()) {
            this.listModel.addElement(cp);
            this.controller.changed();
            this.classpathList.setSelectedIndex(this.listModel.getSize() - 1);
        }
    }

    private void addJarZipButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new FileNameExtensionFilter("Bytecode archives", "jar", "zip"));
        if (chooser.showOpenDialog(this.getParent()) == 0) {
            this.listModel.addElement(chooser.getSelectedFile().getAbsolutePath());
            this.controller.changed();
            this.classpathList.setSelectedIndex(this.listModel.getSize() - 1);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int idx = this.classpathList.getSelectedIndex();
        if (idx >= 0 && idx < this.listModel.getSize()) {
            this.listModel.remove(idx);
            this.controller.changed();
            if (this.listModel.size() > 0) {
                this.classpathList.setSelectedIndex(Math.max(0, idx - 1));
            }
        }
    }

    private void addPathButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(this.getParent()) == 0) {
            this.listModel.addElement(chooser.getSelectedFile().getAbsolutePath());
            this.controller.changed();
            this.classpathList.setSelectedIndex(this.listModel.getSize() - 1);
        }
    }

    public void update() {
        this.listModel.clear();
        for (String cp : this.bytecodeModel.getClassPaths()) {
            this.listModel.addElement(cp);
        }
    }

    public void applyChanges() {
        Object[] data = new String[this.listModel.getSize()];
        this.listModel.copyInto(data);
        this.bytecodeModel.setClassPaths((String[])data);
    }
}

