/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.texteditor.model;

import java.util.BitSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;

public abstract class Scanner
extends Syntax {
    protected static final int EOF = 0;
    protected static final BitSet DIGIT = Scanner.charsOf("0123456789");
    protected static final BitSet HEX = Scanner.charsOf("0123456789abcdefABCDEF");
    protected static final BitSet LETTER = Scanner.charsOf("_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    protected static final BitSet LETTER_DIGIT = Scanner.charsOf("0123456789_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    protected static final BitSet LC_LETTER = Scanner.charsOf("_abcdefghijklmnopqrstuvwxyz");
    protected static final BitSet LC_LETTER_DIGIT = Scanner.charsOf("0123456789_abcdefghijklmnopqrstuvwxyz");
    protected static final BitSet REFERENCE_CHARS = Scanner.charsOf("*. ");
    protected BitSet whitespace;
    protected char ch;

    protected static BitSet charsOf(String s) {
        BitSet result = new BitSet();
        for (int i = 0; i < s.length(); ++i) {
            result.set(s.charAt(i));
        }
        return result;
    }

    public Scanner(String whitespace, TokenContextPath tokenContextPath) {
        this.whitespace = Scanner.charsOf(whitespace);
        this.whitespace.set(0);
        this.tokenContextPath = tokenContextPath;
    }

    public void setText(Document document) {
        try {
            this.setText(document.getText(0, document.getLength()), 0, document.getLength());
        }
        catch (BadLocationException ex) {
            Logger logger = Logger.getLogger(Scanner.class.getName());
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void setText(String s, int offset, int length) {
        this.buffer = s.toCharArray();
        this.offset = offset;
        this.tokenOffset = offset;
        this.stopOffset = Math.min(this.buffer.length, offset + length);
    }

    public String getTokenString() {
        return new String(this.buffer, this.getTokenOffset(), this.getTokenLength());
    }

    public void findTokenBegin(int offset) {
        this.offset = Math.max(offset, 0);
        this.findTokenBegin();
    }

    protected void findTokenBegin() {
        if (this.offset >= this.stopOffset) {
            this.offset = this.stopOffset - 1;
        }
        if (!this.whitespace.get(this.buffer[this.offset])) {
            while (this.offset > 0 && !this.whitespace.get(this.buffer[this.offset - 1])) {
                --this.offset;
            }
        }
        this.ch = this.buffer[this.offset];
        this.tokenOffset = this.offset;
    }

    protected void readNext() {
        ++this.offset;
        this.ch = this.offset < this.stopOffset ? this.buffer[this.offset] : (char)'\u0000';
    }

    protected boolean isWhitespace() {
        boolean result = false;
        while (this.whitespace.get(this.ch) && this.ch != '\u0000') {
            result = true;
            this.readNext();
        }
        return result;
    }

    protected void readToWhitespace() {
        do {
            this.readNext();
        } while (!this.whitespace.get(this.ch));
    }

    private boolean readNextOrRestart(boolean result, boolean readNext) {
        if (result) {
            if (readNext) {
                this.readNext();
            }
        } else {
            this.offset = this.tokenOffset;
            this.ch = this.buffer[this.offset];
        }
        return result;
    }

    protected boolean isKeyword(Set<String> keywords) {
        int endOffset;
        int beginOffset = this.offset;
        for (endOffset = this.offset; endOffset < this.stopOffset && !this.whitespace.get(this.buffer[endOffset]); ++endOffset) {
        }
        String word = new String(this.buffer, beginOffset, endOffset - beginOffset);
        if (!keywords.contains(word)) {
            return false;
        }
        this.offset = endOffset - 1;
        this.readNext();
        return true;
    }

    protected boolean expectEnd() {
        return this.readNextOrRestart(this.whitespace.get(this.ch), false);
    }

    protected boolean expectEnd(char expected) {
        return this.readNextOrRestart(this.ch == expected, false) && this.offset + 1 < this.stopOffset && this.whitespace.get(this.buffer[this.offset + 1]);
    }

    protected boolean expectChar(char expected) {
        return this.readNextOrRestart(this.ch == expected, true);
    }

    protected boolean expectChar(BitSet expected) {
        return this.readNextOrRestart(expected.get(this.ch), true);
    }

    protected boolean expectChars(BitSet expected) {
        while (expected.get(this.ch)) {
            this.readNext();
        }
        return true;
    }

    protected boolean skipUntil(char expected) {
        while (this.ch != expected && !this.whitespace.get(this.ch)) {
            this.readNext();
        }
        return this.expectChar(expected);
    }

    protected boolean beforeChar(char before) {
        int curOffset;
        for (curOffset = this.offset - 1; curOffset >= 0 && this.buffer[curOffset] != before && this.whitespace.get(this.buffer[curOffset]); --curOffset) {
        }
        return curOffset >= 0 && this.buffer[curOffset] == before;
    }

    protected boolean beforeChars(BitSet before) {
        int curOffset;
        for (curOffset = this.offset - 1; curOffset >= 0 && !before.get(this.buffer[curOffset]) && this.whitespace.get(this.buffer[curOffset]); --curOffset) {
        }
        return curOffset >= 0 && before.get(this.buffer[curOffset]);
    }
}

