/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.texteditor.model;

import at.ssw.visualizer.model.Compilation;
import at.ssw.visualizer.model.cfg.BasicBlock;
import at.ssw.visualizer.model.cfg.ControlFlowGraph;
import at.ssw.visualizer.texteditor.model.BlockRegion;
import at.ssw.visualizer.texteditor.model.FoldingRegion;
import at.ssw.visualizer.texteditor.model.Scanner;
import at.ssw.visualizer.texteditor.model.TextRegion;
import java.util.Map;

public class Text {
    private Compilation compilation;
    private ControlFlowGraph cfg;
    private String text;
    private FoldingRegion[] foldings;
    private Map<String, TextRegion> hyperlinks;
    private Map<String, String> stringHovers;
    private Map<TextRegion, String> regionHovers;
    private Map<String, TextRegion[]> highlighting;
    private Map<BasicBlock, BlockRegion> blocks;
    private Scanner scanner;
    private String mimeType;

    public Text(ControlFlowGraph cfg, String text, FoldingRegion[] foldings, Map<String, TextRegion> hyperlinks, Map<String, String> stringHovers, Map<TextRegion, String> regionHovers, Map<String, TextRegion[]> highlighting, Map<BasicBlock, BlockRegion> blocks, Scanner scanner, String mimeType) {
        this.compilation = cfg.getCompilation();
        this.cfg = cfg;
        this.text = text;
        this.foldings = foldings;
        this.hyperlinks = hyperlinks;
        this.stringHovers = stringHovers;
        this.regionHovers = regionHovers;
        this.highlighting = highlighting;
        this.blocks = blocks;
        this.scanner = scanner;
        this.mimeType = mimeType;
    }

    public Compilation getCompilation() {
        return this.compilation;
    }

    public ControlFlowGraph getCfg() {
        return this.cfg;
    }

    public String getText() {
        return this.text;
    }

    public FoldingRegion[] getFoldings() {
        return this.foldings;
    }

    public TextRegion getHyperlinkTarget(String key) {
        return this.hyperlinks.get(key);
    }

    public String getStringHover(String key) {
        return this.stringHovers.get(key);
    }

    public String getRegionHover(int position) {
        for (TextRegion r : this.regionHovers.keySet()) {
            if (r.getStart() > position || r.getEnd() < position) continue;
            return this.regionHovers.get(r);
        }
        return null;
    }

    public TextRegion[] getHighlighting(String key) {
        return this.highlighting.get(key);
    }

    public Map<BasicBlock, BlockRegion> getBlocks() {
        return this.blocks;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

