/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.texteditor.tooltip;

import at.ssw.visualizer.texteditor.model.Scanner;
import at.ssw.visualizer.texteditor.model.Text;
import at.ssw.visualizer.texteditor.tooltip.StyledToolTip;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.editor.NbEditorKit;

public class ToolTipAction
extends NbEditorKit.NbBuildToolTipAction {
    public ToolTipAction() {
        this.putValue("Name", "build-tool-tip");
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (!this.showTooltip(target)) {
            super.actionPerformed(evt, target);
        }
    }

    private boolean showTooltip(JTextComponent target) {
        BaseDocument document = Utilities.getDocument((JTextComponent)target);
        Text text = (Text)document.getProperty(Text.class);
        if (text == null) {
            return false;
        }
        EditorUI ui = Utilities.getEditorUI((JTextComponent)target);
        ToolTipSupport tts = ui.getToolTipSupport();
        int offset = target.viewToModel(tts.getLastMouseEvent().getPoint());
        String toolTipText = text.getRegionHover(offset);
        if (toolTipText == null) {
            Scanner scanner = text.getScanner();
            scanner.setText((Document)document);
            scanner.findTokenBegin(offset);
            TokenID token = scanner.nextToken();
            if (token.getNumericID() < 0) {
                return false;
            }
            toolTipText = text.getStringHover(scanner.getTokenString());
            if (toolTipText == null) {
                return false;
            }
        }
        StyledToolTip tooltip = new StyledToolTip(toolTipText, target.getUI().getEditorKit(target));
        tts.setToolTip((JComponent)tooltip, PopupManager.ViewPortBounds, PopupManager.Largest, 0, 0);
        return true;
    }
}

