/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.action;

import at.ssw.visualizer.cfg.action.AbstractCfgEditorAction;
import at.ssw.visualizer.cfg.editor.CfgEditorTopComponent;
import at.ssw.visualizer.cfg.graph.CfgEventListener;
import at.ssw.visualizer.cfg.graph.CfgScene;
import at.ssw.visualizer.cfg.model.CfgNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openide.util.HelpCtx;
import org.openide.util.actions.Presenter;

public class ColorAction
extends AbstractCfgEditorAction
implements Presenter.Menu,
Presenter.Popup,
Presenter.Toolbar {
    public static final int IMAGE_WIDTH = 16;
    public static final int IMAGE_HEIGHT = 16;
    private static final String[] COLOR_NAMES = new String[]{"White", "Light Gray", "Dark Gray", "Light Yellow", "Dark Yellow", "Light Green", "Dark Green", "Light Cyan", "Dark Cyan", "Light Blue", "Dark Blue", "Light Magenta", "Dark Magenta", "Light Red", "Dark Red"};
    private static final Color[] COLORS = new Color[]{new Color(0xFFFFFF), new Color(13947080), new Color(10789016), new Color(0xF0F0B0), new Color(0xE0E040), new Color(0xB0F0B0), new Color(0x40E040), new Color(0xB0F0F0), new Color(0x40E0E0), new Color(0xB0B0F0), new Color(0x4040E0), new Color(0xF0B0F0), new Color(0xE040E0), new Color(0xF0B0B0), new Color(0xE04040)};

    public void performAction() {
    }

    protected void performAction(Color color) {
        CfgEditorTopComponent tc = this.getEditor();
        if (tc != null) {
            tc.getCfgScene().setSelectedNodesColor(color);
        }
    }

    public String getName() {
        return "Change NodeColor";
    }

    protected String iconResource() {
        return "at/ssw/visualizer/cfg/icons/color.gif";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    public JMenuItem getMenuPresenter() {
        return new MenuPresenter();
    }

    @Override
    public JMenuItem getPopupPresenter() {
        return new MenuPresenter();
    }

    @Override
    public JComponent getToolbarPresenter() {
        return new ToolbarPresenter();
    }

    protected Icon createIcon(Color color) {
        if (color == null) {
            return this.getIcon();
        }
        return new ColorIcon(color);
    }

    class MenuPresenter
    extends JMenu {
        public MenuPresenter() {
            super((Action)((Object)ColorAction.this));
            this.initGUI();
        }

        protected void initGUI() {
            CfgEditorTopComponent tc = ColorAction.this.getEditor();
            if (tc != null && tc.getCfgScene().getSelectedNodes().size() == 0) {
                this.setEnabled(false);
            } else {
                this.add(new SetColorAction(null, "Automatic"));
                for (int i = 0; i < COLORS.length; ++i) {
                    this.add(new SetColorAction(COLORS[i], COLOR_NAMES[i]));
                }
            }
        }
    }

    class ToolbarPresenter
    extends JButton
    implements CfgEventListener,
    MouseListener {
        final int arrowSize = 5;
        final int arrowMargin = 3;
        JPopupMenu popup;

        public ToolbarPresenter() {
            this.setIcon(this.createIcon());
            this.setToolTipText(ColorAction.this.getName());
            this.popup = new JPopupMenu();
            this.popup.add(new SetColorAction(null, "Automatic"));
            for (int i = 0; i < COLORS.length; ++i) {
                this.popup.add(new SetColorAction(COLORS[i], COLOR_NAMES[i]));
            }
            this.addMouseListener(this);
        }

        public Icon createIcon() {
            BasicArrowButton arrow = new BasicArrowButton(5);
            BufferedImage img = new BufferedImage(27, 16, 2);
            Graphics g = img.getGraphics();
            ColorAction.this.getIcon().paintIcon(this, g, 0, 0);
            arrow.paintTriangle(g, 21, 6, 5, 5, true);
            return new ImageIcon(img);
        }

        @Override
        public void selectionChanged(CfgScene scene) {
            Set<CfgNode> nodes = scene.getSelectedNodes();
            this.setEnabled(nodes.size() > 0);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getX() < this.getInsets().left + 16 + 3) {
                ColorAction.this.performAction(null);
            } else {
                this.popup.show(this, 0, this.getSize().height);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class ColorIcon
    implements Icon {
        Color color;

        public ColorIcon(Color color) {
            this.color = color;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.setColor(this.color);
            g.fillRect(x, y, 16, 16);
            g.setColor(oldColor);
        }
    }

    class SetColorAction
    extends AbstractAction {
        Color color;
        String name;
        Icon icon;

        public SetColorAction(Color color, String name) {
            super(name, ColorAction.this.createIcon(color));
            this.color = color;
            this.name = name;
            this.icon = (Icon)this.getValue("SmallIcon");
        }

        public Color getColor() {
            return this.color;
        }

        public String getName() {
            return this.name;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorAction.this.performAction(this.color);
        }
    }
}

