/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.action;

import at.ssw.visualizer.cfg.action.AbstractCfgEditorAction;
import at.ssw.visualizer.cfg.editor.CfgEditorTopComponent;
import at.ssw.visualizer.cfg.graph.CfgScene;
import java.awt.Component;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ExportAction
extends AbstractCfgEditorAction {
    public static final String DESCRIPTION_SVG = "Scaleable Vector Format (.svg)";
    public static final String EXT_SVG = "svg";
    String lastDirectory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction() {
        CfgEditorTopComponent tc = this.getEditor();
        CfgScene scene = tc.getCfgScene();
        JComponent view = scene.getView();
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(this.getName());
        chooser.setDialogType(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter(DESCRIPTION_SVG, EXT_SVG));
        if (this.lastDirectory != null) {
            chooser.setCurrentDirectory(new File(this.lastDirectory));
        }
        chooser.setSelectedFile(new File(tc.getName()));
        if (chooser.showSaveDialog((Component)((Object)tc)) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        FileNameExtensionFilter filter = (FileNameExtensionFilter)chooser.getFileFilter();
        String fn = file.getAbsolutePath().toLowerCase();
        String ext = filter.getExtensions()[0];
        if (!fn.endsWith("." + ext)) {
            file = new File(file.getParentFile(), file.getName() + "." + ext);
        }
        if (file.exists()) {
            DialogDescriptor descriptor = new DialogDescriptor((Object)("File (" + file.getAbsolutePath() + ") already exists. Do you want to overwrite it?"), "File Exists", true, 0, DialogDescriptor.NO_OPTION, null);
            DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
            if (descriptor.getValue() != DialogDescriptor.YES_OPTION) {
                return;
            }
        }
        this.lastDirectory = chooser.getCurrentDirectory().getAbsolutePath();
        if (ext.equals(EXT_SVG)) {
            DOMImplementation dom = GenericDOMImplementation.getDOMImplementation();
            Document document = dom.createDocument("http://www.w3.org/2000/svg", EXT_SVG, null);
            SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
            ctx.setEmbeddedFontsOn(true);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, true);
            scene.paint((Graphics2D)svgGenerator);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(file);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)os, "UTF-8");
                assert (svgGenerator instanceof SVGGraphics2D);
                SVGGraphics2D svgGraphics = svgGenerator;
                svgGraphics.stream((Writer)out, true);
            }
            catch (IOException iOException) {
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public String getName() {
        return "Export CFG";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource() {
        return "at/ssw/visualizer/cfg/icons/disk.gif";
    }
}

