/*
 * Decompiled with CFR 0.152.
 */
package at.ssw.visualizer.cfg.graph;

import at.ssw.visualizer.cfg.action.ColorAction;
import at.ssw.visualizer.cfg.action.HideEdgesAction;
import at.ssw.visualizer.cfg.action.ShowEdgesAction;
import at.ssw.visualizer.cfg.editor.CfgEditorTopComponent;
import at.ssw.visualizer.cfg.graph.CfgEventListener;
import at.ssw.visualizer.cfg.graph.EdgeSwitchWidget;
import at.ssw.visualizer.cfg.graph.EdgeWidget;
import at.ssw.visualizer.cfg.graph.LoopClusterWidget;
import at.ssw.visualizer.cfg.graph.NodeWidget;
import at.ssw.visualizer.cfg.graph.SelectionWidget;
import at.ssw.visualizer.cfg.graph.SymmetricAnchor;
import at.ssw.visualizer.cfg.graph.layout.HierarchicalCompoundLayout;
import at.ssw.visualizer.cfg.graph.layout.HierarchicalNodeLayout;
import at.ssw.visualizer.cfg.model.CfgEdge;
import at.ssw.visualizer.cfg.model.CfgEnv;
import at.ssw.visualizer.cfg.model.CfgNode;
import at.ssw.visualizer.cfg.model.LoopInfo;
import at.ssw.visualizer.cfg.preferences.CfgPreferences;
import at.ssw.visualizer.cfg.visual.PolylineRouterV2;
import at.ssw.visualizer.cfg.visual.WidgetCollisionCollector;
import at.ssw.visualizer.core.selection.Selection;
import at.ssw.visualizer.core.selection.SelectionManager;
import at.ssw.visualizer.model.cfg.BasicBlock;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.actions.SystemAction;

public class CfgScene
extends GraphScene<CfgNode, CfgEdge>
implements ChangeListener {
    private LayerWidget mainLayer = new LayerWidget((Scene)this);
    private LayerWidget connectionLayer = new LayerWidget((Scene)this);
    private LayerWidget interractionLayer = new LayerWidget((Scene)this);
    private LayerWidget clusterLayer = new LayerWidget((Scene)this);
    private Set<CfgNode> selectedNodes = Collections.emptySet();
    private Map<Integer, LoopClusterWidget> loopidx2clusterwidget = new HashMap<Integer, LoopClusterWidget>();
    private Map<CfgNode, EdgeSwitchWidget> inputSwitches = new HashMap<CfgNode, EdgeSwitchWidget>();
    private Map<CfgNode, EdgeSwitchWidget> outputSwitches = new HashMap<CfgNode, EdgeSwitchWidget>();
    private WidgetAction moveAction = ActionFactory.createMoveAction((MoveStrategy)ActionFactory.createFreeMoveStrategy(), (MoveProvider)this.createMoveProvider());
    private SceneLayout sceneLayout;
    private CfgEnv env;
    private int currentLayout = -1;
    private int currentRouter = -1;
    private CfgEditorTopComponent cfgtc;
    private EventListenerList listenerList = new EventListenerList();
    private WidgetAction contextPopupAction = this.createContextMenuAction(this);
    private List<NodeWidget> nodeWidgets = null;
    private boolean loopClustersVisible = true;
    private boolean selectionUpdating = false;

    public CfgScene(CfgEditorTopComponent cfgtc) {
        this.addChild((Widget)this.clusterLayer);
        this.addChild((Widget)this.mainLayer);
        this.addChild((Widget)this.interractionLayer);
        this.addChild((Widget)this.connectionLayer);
        this.loadDefaults();
        this.cfgtc = cfgtc;
        this.loadModel(new CfgEnv(cfgtc.getCfg()));
        this.setSceneLayout(1);
        this.getInputBindings().setZoomActionModifiers(0);
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.1));
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((RectangularSelectDecorator)this.createSelectDecorator(this), (LayerWidget)this.interractionLayer, (RectangularSelectProvider)this.createRectangularSelectProvider()));
        this.getActions().addAction(this.contextPopupAction);
        this.addSceneListener(this.createSceneListener(this));
        this.validate();
    }

    private void loadModel(CfgEnv cfgenv) {
        this.env = cfgenv;
        for (CfgNode n : this.env.getNodes()) {
            this.addNode(n);
        }
        for (CfgEdge e : this.env.getEdges()) {
            this.addEdge(e);
            this.setEdgeSource(e, e.getSourceNode());
            this.setEdgeTarget(e, e.getTargetNode());
        }
        this.stackLoops(cfgenv.getLoopMap());
        this.autoHideEdges();
    }

    public void loadDefaults() {
        this.setRouter(1);
        CfgPreferences prefs = CfgPreferences.getInstance();
        this.setBackground(prefs.getBackgroundColor());
    }

    private void stackLoops(Map<CfgNode, LoopInfo> map) {
        this.clusterLayer.removeChildren();
        HashSet cache = new HashSet();
        for (LoopInfo info : map.values()) {
            if (cache.contains(info)) continue;
            LoopClusterWidget widget = this.loopidx2clusterwidget.get(info.getLoopIndex());
            for (LoopInfo parent = info.getParent(); parent != null; parent = parent.getParent()) {
                LoopClusterWidget parentWidget = this.loopidx2clusterwidget.get(parent.getLoopIndex());
                assert (parentWidget != null);
                if (widget.getParentWidget() != null) {
                    widget.removeFromParent();
                }
                parentWidget.addChild(widget);
                widget = parentWidget;
            }
            widget.removeFromParent();
            this.clusterLayer.addChild((Widget)widget);
        }
    }

    private void autoHideEdges() {
        for (CfgNode n : this.getNodes()) {
            EdgeSwitchWidget esw;
            int fanin = n.getInputEdges().length;
            int fanout = n.getOutputEdges().length;
            if (fanin > 8) {
                assert (this.inputSwitches.containsKey(n));
                if (this.inputSwitches.containsKey(n)) {
                    esw = this.inputSwitches.get(n);
                    esw.changeEdgeVisibility(false);
                }
            }
            if (fanout <= 8 || !this.outputSwitches.containsKey(n)) continue;
            esw = this.outputSwitches.get(n);
            esw.changeEdgeVisibility(false);
        }
    }

    public void applyLayout() {
        this.sceneLayout.invokeLayoutImmediately();
    }

    public Set<CfgNode> getSelectedNodes() {
        return Collections.unmodifiableSet(this.selectedNodes);
    }

    public Map<Integer, LoopClusterWidget> getLoopidx2clusterwidget() {
        return this.loopidx2clusterwidget;
    }

    public void setSelectedNodesColor(Color color) {
        if (color == null) {
            CfgPreferences prefs = CfgPreferences.getInstance();
            boolean customized = false;
            for (CfgNode n : this.selectedNodes) {
                color = null;
                color = prefs.getFlagsSetting().getColor(n.getBasicBlock().getFlags());
                customized = color != null;
                NodeWidget nw = (NodeWidget)this.findWidget(n);
                nw.setNodeColor(customized ? color : prefs.getNodeColor(), customized);
            }
        } else {
            for (CfgNode n : this.selectedNodes) {
                NodeWidget nw = (NodeWidget)this.findWidget(n);
                nw.setNodeColor(color, true);
            }
        }
        this.validate();
    }

    public void setSelectedEdgesVisibility(boolean visible) {
        for (CfgNode n : this.selectedNodes) {
            EdgeSwitchWidget in = this.inputSwitches.get(n);
            EdgeSwitchWidget out = this.outputSwitches.get(n);
            if (in != null) {
                in.changeEdgeVisibility(visible);
            }
            if (out == null) continue;
            out.changeEdgeVisibility(visible);
        }
        this.fireSelectionChanged();
        this.validate();
    }

    public EdgeSwitchWidget getInputSwitch(CfgNode n) {
        return this.inputSwitches.get(n);
    }

    public EdgeSwitchWidget getOutputSwitch(CfgNode n) {
        return this.outputSwitches.get(n);
    }

    public CfgEnv getCfgEnv() {
        return this.env;
    }

    public boolean isLoopClusterVisible() {
        return this.loopClustersVisible;
    }

    public void setLoopWidgets(boolean visible) {
        for (Widget widget : this.loopidx2clusterwidget.values()) {
            widget.setVisible(visible);
            widget.revalidate();
        }
        this.loopClustersVisible = visible;
        this.validate();
    }

    public void setRouter(int newRouter) {
        Router router;
        if (newRouter == this.currentRouter) {
            return;
        }
        this.currentRouter = newRouter;
        switch (newRouter) {
            case 2: {
                router = new PolylineRouterV2(new WidgetCollisionCollector(){

                    @Override
                    public void collectCollisions(List<Widget> collisions) {
                        collisions.addAll(CfgScene.this.getNodeWidgets());
                    }
                });
                break;
            }
            case 1: {
                router = RouterFactory.createDirectRouter();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Router ID: " + newRouter);
            }
        }
        for (CfgEdge e : this.getEdges()) {
            EdgeWidget ew = (EdgeWidget)this.findWidget(e);
            ew.setRouter(router);
        }
        this.validate();
    }

    public Collection<NodeWidget> getNodeWidgets() {
        if (this.nodeWidgets != null && this.nodeWidgets.size() == this.getNodes().size()) {
            return this.nodeWidgets;
        }
        ArrayList<NodeWidget> widgets = new ArrayList<NodeWidget>();
        for (CfgNode n : this.getNodes()) {
            NodeWidget w = (NodeWidget)this.findWidget(n);
            widgets.add(w);
        }
        this.nodeWidgets = Collections.unmodifiableList(widgets);
        return widgets;
    }

    public void setSceneLayout(int newLayout) {
        if (this.currentLayout == newLayout) {
            return;
        }
        GraphLayout graphLayout = null;
        switch (newLayout) {
            case 1: {
                graphLayout = new HierarchicalNodeLayout(this);
                break;
            }
            case 2: {
                graphLayout = new HierarchicalCompoundLayout(this);
            }
        }
        this.currentLayout = newLayout;
        if (graphLayout != null) {
            this.sceneLayout = LayoutFactory.createSceneGraphLayout((GraphScene)this, (GraphLayout)graphLayout);
        }
    }

    protected void attachEdgeSourceAnchor(CfgEdge edge, CfgNode oldSourceNode, CfgNode sourceNode) {
        EdgeWidget edgeWidget = (EdgeWidget)this.findWidget(edge);
        Widget sourceWidget = this.findWidget(sourceNode);
        Anchor sourceAnchor = edge.isSymmetric() ? new SymmetricAnchor(sourceWidget, true, true) : AnchorFactory.createRectangularAnchor((Widget)sourceWidget);
        edgeWidget.setSourceAnchor(sourceAnchor);
    }

    protected void attachEdgeTargetAnchor(CfgEdge edge, CfgNode oldtarget, CfgNode targetNode) {
        ConnectionWidget edgeWidget = (ConnectionWidget)this.findWidget(edge);
        Widget targetWidget = this.findWidget(targetNode);
        Anchor targetAnchor = edge.isSymmetric() ? new SymmetricAnchor(targetWidget, true, false) : AnchorFactory.createRectangularAnchor((Widget)targetWidget);
        edgeWidget.setTargetAnchor(targetAnchor);
    }

    protected Widget attachEdgeWidget(CfgEdge edge) {
        EdgeWidget widget = new EdgeWidget(this, edge);
        this.connectionLayer.addChild((Widget)widget);
        this.attachSourceSwitchWidget(edge);
        this.attachTargetSwitchWidget(edge);
        return widget;
    }

    protected Widget attachNodeWidget(CfgNode node) {
        this.nodeWidgets = null;
        NodeWidget nw = new NodeWidget(this, node);
        WidgetAction.Chain actions = nw.getActions();
        actions.addAction(this.contextPopupAction);
        actions.addAction(this.moveAction);
        actions.addAction(this.createObjectHoverAction());
        if (node.isLoopMember()) {
            LoopClusterWidget loopWidget = this.attachLoopMember(node);
            loopWidget.addMember(nw);
        }
        this.mainLayer.addChild((Widget)nw);
        return nw;
    }

    private LoopClusterWidget attachLoopMember(CfgNode node) {
        LoopClusterWidget lw = this.loopidx2clusterwidget.get(node.getLoopIndex());
        if (lw == null) {
            lw = new LoopClusterWidget(this, node.getLoopDepth(), node.getLoopIndex());
            this.loopidx2clusterwidget.put(node.getLoopIndex(), lw);
            this.clusterLayer.addChild((Widget)lw);
        }
        return lw;
    }

    private boolean detachLoopMember(CfgNode node, NodeWidget nodeWidget) {
        LoopClusterWidget rm = this.loopidx2clusterwidget.get(node.getLoopIndex());
        if (rm == null) {
            return false;
        }
        if (rm.removeMember(nodeWidget)) {
            if (rm.getMembers().size() == 0) {
                this.loopidx2clusterwidget.remove(rm.getLoopIndex());
                ArrayList childs = new ArrayList(rm.getChildren());
                for (Widget w : childs) {
                    w.removeFromParent();
                    rm.getParentWidget().addChild(w);
                }
                rm.removeFromParent();
            }
            return true;
        }
        return false;
    }

    protected void detachNodeWidget(CfgNode node, Widget nodeWidget) {
        EdgeSwitchWidget esw;
        if (node.isLoopMember() && nodeWidget instanceof NodeWidget) {
            this.detachLoopMember(node, (NodeWidget)nodeWidget);
        }
        super.detachNodeWidget((Object)node, nodeWidget);
        assert (nodeWidget.getParentWidget() == null);
        if (this.inputSwitches.containsKey(node)) {
            esw = this.inputSwitches.remove(node);
            this.connectionLayer.removeChild((Widget)esw);
        }
        if (this.outputSwitches.containsKey(node)) {
            esw = this.outputSwitches.remove(node);
            this.connectionLayer.removeChild((Widget)esw);
        }
    }

    protected EdgeSwitchWidget attachSourceSwitchWidget(CfgEdge e) {
        CfgNode sourceNode = e.getSourceNode();
        NodeWidget sourceWidget = (NodeWidget)this.findWidget(sourceNode);
        EdgeSwitchWidget out = this.outputSwitches.get(sourceNode);
        if (out == null) {
            out = new EdgeSwitchWidget(this, sourceWidget, true);
            this.connectionLayer.addChild((Widget)out);
            this.outputSwitches.put(sourceNode, out);
        }
        return out;
    }

    protected EdgeSwitchWidget attachTargetSwitchWidget(CfgEdge e) {
        CfgNode targetNode = e.getTargetNode();
        NodeWidget targetWidget = (NodeWidget)this.findWidget(targetNode);
        EdgeSwitchWidget in = this.inputSwitches.get(targetNode);
        if (in == null) {
            in = new EdgeSwitchWidget(this, targetWidget, false);
            this.connectionLayer.addChild((Widget)in);
            this.inputSwitches.put(targetNode, in);
        }
        return in;
    }

    private void cleanNodeSelection() {
        if (this.selectedNodes.size() != 0) {
            this.userSelectionSuggested(Collections.emptySet(), false);
            this.selectedNodes = Collections.emptySet();
            this.fireSelectionChanged();
            this.validate();
        }
    }

    public void setNodeSelection(Set<CfgNode> newSelection) {
        this.setSceneSelection(newSelection);
        this.updateGlobalSelection();
    }

    private void setSceneSelection(Set<CfgNode> newSelection) {
        if (newSelection.equals(this.selectedNodes)) {
            return;
        }
        this.selectedNodes = newSelection;
        HashSet<CfgNode> selectedObjects = new HashSet<CfgNode>();
        for (CfgNode n : newSelection) {
            selectedObjects.addAll(this.findNodeEdges(n, true, true));
        }
        selectedObjects.addAll(newSelection);
        if (this.selectionUpdating) {
            this.centerSelection();
        }
        this.userSelectionSuggested(selectedObjects, false);
        this.fireSelectionChanged();
        this.validate();
    }

    public void updateGlobalSelection() {
        Selection selection = SelectionManager.getDefault().getCurSelection();
        ArrayList<BasicBlock> newBlocks = new ArrayList<BasicBlock>();
        for (CfgNode n : this.selectedNodes) {
            newBlocks.add(n.getBasicBlock());
        }
        BasicBlock[] curBlocks = newBlocks.toArray(new BasicBlock[newBlocks.size()]);
        selection.put((Object)curBlocks);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (this.selectionUpdating) {
            return;
        }
        this.selectionUpdating = true;
        Object source = event.getSource();
        if (source instanceof Selection) {
            Selection selection = (Selection)source;
            HashSet<CfgNode> newSelection = new HashSet<CfgNode>();
            BasicBlock[] newBlocks = (BasicBlock[])selection.get(BasicBlock[].class);
            if (newBlocks != null) {
                for (BasicBlock b : newBlocks) {
                    for (CfgNode n : this.getNodes()) {
                        if (n.getBasicBlock() != b) continue;
                        newSelection.add(n);
                    }
                }
                this.setSceneSelection(newSelection);
            }
        }
        this.selectionUpdating = false;
    }

    private void centerSelection() {
        Point sceneCenter = null;
        Collection<CfgNode> nodes = this.selectedNodes;
        if (nodes.size() == 0) {
            nodes = this.getNodes();
        }
        for (CfgNode n : nodes) {
            if (sceneCenter == null) {
                sceneCenter = this.findWidget(n).getLocation();
                continue;
            }
            Point location = this.findWidget(n).getLocation();
            sceneCenter.x = (location.x + sceneCenter.x) / 2;
            sceneCenter.y = (location.y + sceneCenter.y) / 2;
        }
        JComponent view = this.getView();
        if (view != null) {
            Rectangle viewBounds = view.getVisibleRect();
            Point viewCenter = this.convertSceneToView(sceneCenter);
            view.scrollRectToVisible(new Rectangle(viewCenter.x - viewBounds.width / 2, viewCenter.y - viewBounds.height / 2, viewBounds.width, viewBounds.height));
        }
    }

    public void zoomScene() {
        JScrollPane pane = this.cfgtc.getJScrollPanel();
        Rectangle prefBounds = this.getPreferredBounds();
        Dimension viewDim = pane.getViewportBorderBounds().getSize();
        double realwidth = (double)prefBounds.width * this.getZoomFactor();
        double realheight = (double)prefBounds.height * this.getZoomFactor();
        double zoomX = (double)viewDim.width / realwidth;
        double zoomY = (double)viewDim.height / realheight;
        double zoomFactor = Math.min(zoomX, zoomY);
        this.animateZoom(zoomFactor * 0.9);
    }

    public void animateZoom(double zoomfactor) {
        this.getSceneAnimator().animateZoomFactor(this.getZoomFactor() * zoomfactor);
    }

    public void addCfgEventListener(CfgEventListener l) {
        this.listenerList.add(CfgEventListener.class, l);
    }

    public void removeCfgEventListener(CfgEventListener l) {
        this.listenerList.remove(CfgEventListener.class, l);
    }

    public void fireSelectionChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CfgEventListener.class) continue;
            ((CfgEventListener)listeners[i + 1]).selectionChanged(this);
        }
    }

    public void paintChildren() {
        Object anti = this.getGraphics().getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object textAnti = this.getGraphics().getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        this.getGraphics().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.getGraphics().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintChildren();
        this.getGraphics().setRenderingHint(RenderingHints.KEY_ANTIALIASING, anti);
        this.getGraphics().setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textAnti);
    }

    private RectangularSelectProvider createRectangularSelectProvider() {
        return new RectangularSelectProvider(){

            public void performSelection(Rectangle rectangle) {
                HashSet<CfgNode> set = new HashSet<CfgNode>();
                if (rectangle.width < 0) {
                    rectangle.x += rectangle.width;
                    rectangle.width *= -1;
                }
                if (rectangle.height < 0) {
                    rectangle.y += rectangle.height;
                    rectangle.height *= -1;
                }
                for (NodeWidget n : CfgScene.this.getNodeWidgets()) {
                    Point p = n.getLocation();
                    if (p == null || !rectangle.contains(p)) continue;
                    set.add(n.getNodeModel());
                }
                CfgScene.this.setNodeSelection(set);
            }
        };
    }

    private RectangularSelectDecorator createSelectDecorator(final CfgScene scene) {
        return new RectangularSelectDecorator(){

            public Widget createSelectionWidget() {
                scene.cleanNodeSelection();
                scene.revalidate();
                return new SelectionWidget(CfgScene.this.getScene());
            }
        };
    }

    private MoveProvider createMoveProvider() {
        return new MoveProvider(){
            private HashMap<Widget, Point> originals = new HashMap();
            private Point original = null;

            public void movementStarted(Widget widget) {
                this.originals.clear();
                NodeWidget nw = (NodeWidget)widget;
                if (CfgScene.this.selectedNodes.contains(nw.getNodeModel())) {
                    for (CfgNode n : CfgScene.this.selectedNodes) {
                        Widget w = CfgScene.this.findWidget(n);
                        this.originals.put(w, w.getLocation());
                    }
                } else {
                    CfgNode n = nw.getNodeModel();
                    HashSet<CfgNode> selectedNode = new HashSet<CfgNode>(1);
                    selectedNode.add(n);
                    CfgScene.this.setNodeSelection(selectedNode);
                    this.originals.put(widget, widget.getPreferredLocation());
                    widget.revalidate();
                    CfgScene.this.validate();
                }
            }

            public void movementFinished(Widget widget) {
                NodeWidget nw = (NodeWidget)widget;
                if (CfgScene.this.selectedNodes.contains(nw.getNodeModel())) {
                    return;
                }
                HashSet<CfgNode> selectedNode = new HashSet<CfgNode>(1);
                selectedNode.add(nw.getNodeModel());
                CfgScene.this.setNodeSelection(selectedNode);
                this.originals.clear();
                this.original = null;
            }

            public Point getOriginalLocation(Widget widget) {
                if (this.original == null) {
                    this.original = widget.getLocation();
                }
                return this.original;
            }

            public void setNewLocation(Widget widget, Point location) {
                Point org = this.getOriginalLocation(widget);
                int dx = location.x - org.x;
                int dy = location.y - org.y;
                for (Map.Entry<Widget, Point> entry : this.originals.entrySet()) {
                    Point point = entry.getValue();
                    entry.getKey().setPreferredLocation(new Point(point.x + dx, point.y + dy));
                }
                for (CfgEdge e : CfgScene.this.getEdges()) {
                    EdgeWidget ew = (EdgeWidget)CfgScene.this.findWidget(e);
                    if (!ew.isVisible()) continue;
                    ew.reroute();
                }
            }
        };
    }

    private WidgetAction createContextMenuAction(final CfgScene scene) {
        return ActionFactory.createPopupMenuAction((PopupMenuProvider)new PopupMenuProvider(){

            public JPopupMenu getPopupMenu(Widget widget, Point point) {
                JPopupMenu menu = new JPopupMenu();
                NodeWidget nw = null;
                if (widget instanceof NodeWidget) {
                    nw = (NodeWidget)widget;
                    if (!CfgScene.this.selectedNodes.contains(nw.getNodeModel())) {
                        HashSet<CfgNode> selectedNode = new HashSet<CfgNode>(1);
                        selectedNode.add(nw.getNodeModel());
                        CfgScene.this.setNodeSelection(selectedNode);
                    }
                } else if (scene.getSelectedNodes().size() == 1) {
                    nw = (NodeWidget)scene.findWidget(scene.getSelectedNodes().iterator().next());
                }
                if (nw != null) {
                    GotoNodeAction action;
                    CfgNode node = nw.getNodeModel();
                    ArrayList<CfgNode> successors = new ArrayList<CfgNode>();
                    ArrayList<CfgNode> predecessors = new ArrayList<CfgNode>();
                    for (CfgEdge e : node.getOutputEdges()) {
                        successors.add(e.getTargetNode());
                    }
                    for (CfgEdge e : node.getInputEdges()) {
                        predecessors.add(e.getSourceNode());
                    }
                    if (predecessors.size() > 0) {
                        Collections.sort(predecessors, new NodeNameComparator());
                        JMenu predmenu = new JMenu("Go to predecessor");
                        for (CfgNode n : predecessors) {
                            action = new GotoNodeAction(n);
                            predmenu.add(action);
                        }
                        menu.add(predmenu);
                    }
                    if (successors.size() > 0) {
                        Collections.sort(successors, new NodeNameComparator());
                        JMenu succmenu = new JMenu("Go to successor");
                        for (CfgNode n : successors) {
                            action = new GotoNodeAction(n);
                            succmenu.add(action);
                        }
                        menu.add(succmenu);
                    }
                    if (successors.size() > 0 || predecessors.size() > 0) {
                        menu.addSeparator();
                    }
                }
                menu.add((Action)SystemAction.get(ShowEdgesAction.class));
                menu.add((Action)SystemAction.get(HideEdgesAction.class));
                menu.addSeparator();
                menu.add(((ColorAction)SystemAction.get(ColorAction.class)).getPopupPresenter());
                return menu;
            }
        });
    }

    private Scene.SceneListener createSceneListener(final CfgScene scene) {
        return new Scene.SceneListener(){

            public void sceneRepaint() {
            }

            public void sceneValidating() {
            }

            public void sceneValidated() {
                if (scene.isLoopClusterVisible()) {
                    for (LoopClusterWidget cw : CfgScene.this.getLoopidx2clusterwidget().values()) {
                        cw.updateClusterBounds();
                    }
                }
                for (EdgeSwitchWidget esw : CfgScene.this.inputSwitches.values()) {
                    esw.updatePosition();
                }
                for (EdgeSwitchWidget esw : CfgScene.this.outputSwitches.values()) {
                    esw.updatePosition();
                }
            }
        };
    }

    private class GotoNodeAction
    extends AbstractAction {
        CfgNode node;

        GotoNodeAction(CfgNode node) {
            super(node.getBasicBlock().getName());
            this.node = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashSet<CfgNode> nodes = new HashSet<CfgNode>(1);
            nodes.add(this.node);
            CfgScene.this.setNodeSelection(nodes);
            CfgScene.this.centerSelection();
        }
    }

    private class NodeNameComparator
    implements Comparator<CfgNode> {
        private NodeNameComparator() {
        }

        @Override
        public int compare(CfgNode node1, CfgNode node2) {
            String name1 = node1.getBasicBlock().getName().substring(1);
            String name2 = node2.getBasicBlock().getName().substring(1);
            Integer blocknum1 = Integer.parseInt(name1);
            Integer blocknum2 = Integer.parseInt(name2);
            return blocknum1.compareTo(blocknum2);
        }
    }
}

